/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterIO;

@XStreamAlias(value="variable")
public class SystemVariable {
    String key;
    String value;
    boolean isShared;

    SystemVariable() {
        this.key = "";
        this.value = "";
        this.isShared = false;
    }

    public SystemVariable(String key, String value) {
        this.key = key;
        this.value = value;
        this.isShared = false;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.resolve();
    }

    public void setValue(String value) {
        this.value = value;
        if (this.value != null && !this.value.isEmpty() && this.isShared) {
            ToolAdapterIO.saveVariable(this.key, this.value);
        }
    }

    public boolean isShared() {
        return this.isShared;
    }

    public void setShared(boolean value) {
        this.isShared = value;
    }

    public SystemVariable createCopy() {
        SystemVariable newVariable = new SystemVariable();
        newVariable.setKey(this.key);
        newVariable.setValue(this.value);
        newVariable.setShared(this.isShared);
        return newVariable;
    }

    protected String resolve() {
        String existingValue = System.getenv(this.key);
        if (existingValue == null || existingValue.isEmpty()) {
            existingValue = ToolAdapterIO.getVariableValue(this.key, this.value, this.isShared);
        } else if (this.isShared) {
            ToolAdapterIO.saveVariable(this.key, existingValue);
        }
        return existingValue;
    }
}

