/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.preferences;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.esa.snap.rcp.preferences.DefaultConfigController;
import org.esa.snap.rcp.preferences.Preference;
import org.esa.snap.rcp.util.Dialogs;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;

public class ToolAdapterOptionsController
extends DefaultConfigController {
    public static final String PREFERENCE_KEY_TABBED_WINDOW = "sta.use.tabs";
    public static final String PREFERENCE_KEY_VALIDATE_PATHS = "sta.validate.paths";
    public static final String PREFERENCE_KEY_SHOW_EMPTY_PRODUCT_WARNING = "sta.warn.no.product";
    public static final String PREFERENCE_KEY_AUTOCOMPLETE = "sta.autocomplete";
    public static final String PREFERENCE_KEY_SHOW_EXECUTION_OUTPUT = "sta.display.output";
    public static final boolean DEFAULT_VALUE_TABBED_WINDOW = true;
    public static final boolean DEFAULT_VALUE_VALIDATE_PATHS = true;
    public static final boolean DEFAULT_VALUE_SHOW_EMPTY_PRODUCT_WARINING = true;
    public static final boolean DEFAULT_VALUE_SHOW_EXECUTION_OUTPUT = true;
    public static final boolean DEFAULT_VALUE_AUTOCOMPLETE = false;
    private static final String DECISION_SUFFIX = ".decision";
    private BindingContext context;
    private Preferences preferences;

    protected PropertySet createPropertySet() {
        return this.createPropertySet(new STAOptionsBean());
    }

    protected JPanel createPanel(BindingContext context) {
        this.context = context;
        this.preferences = NbPreferences.forModule(Dialogs.class);
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTablePadding(4, 10);
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setRowWeightY(4, Double.valueOf(1.0));
        JPanel pageUI = new JPanel((LayoutManager)tableLayout);
        PropertyEditorRegistry registry = PropertyEditorRegistry.getInstance();
        Property useTabsControl = context.getPropertySet().getProperty(PREFERENCE_KEY_TABBED_WINDOW);
        this.setPropertyValue(useTabsControl, true);
        Property pathValidationControl = context.getPropertySet().getProperty(PREFERENCE_KEY_VALIDATE_PATHS);
        this.setPropertyValue(pathValidationControl, true);
        Property noProductWarningControl = context.getPropertySet().getProperty(PREFERENCE_KEY_SHOW_EMPTY_PRODUCT_WARNING);
        this.setPropertyValue(noProductWarningControl, true);
        Property displayOutputControl = context.getPropertySet().getProperty(PREFERENCE_KEY_SHOW_EXECUTION_OUTPUT);
        this.setPropertyValue(displayOutputControl, true);
        Property autocompleteControl = context.getPropertySet().getProperty(PREFERENCE_KEY_AUTOCOMPLETE);
        this.setPropertyValue(autocompleteControl, false);
        JComponent[] useTabsComponents = registry.findPropertyEditor(useTabsControl.getDescriptor()).createComponents(useTabsControl.getDescriptor(), context);
        JComponent[] pathValidationComponents = registry.findPropertyEditor(pathValidationControl.getDescriptor()).createComponents(pathValidationControl.getDescriptor(), context);
        JComponent[] noProductWarningComponents = registry.findPropertyEditor(noProductWarningControl.getDescriptor()).createComponents(noProductWarningControl.getDescriptor(), context);
        JComponent[] displayOutputComponents = registry.findPropertyEditor(displayOutputControl.getDescriptor()).createComponents(displayOutputControl.getDescriptor(), context);
        JComponent[] autocompleteComponents = registry.findPropertyEditor(autocompleteControl.getDescriptor()).createComponents(autocompleteControl.getDescriptor(), context);
        tableLayout.setRowPadding(0, new Insets(10, 80, 10, 4));
        pageUI.add(useTabsComponents[0]);
        pageUI.add(pathValidationComponents[0]);
        pageUI.add(noProductWarningComponents[0]);
        pageUI.add(displayOutputComponents[0]);
        pageUI.add(autocompleteComponents[0]);
        pageUI.add(tableLayout.createVerticalSpacer());
        return pageUI;
    }

    public void update() {
        Property property = this.context.getPropertySet().getProperty(PREFERENCE_KEY_TABBED_WINDOW);
        if (property != null) {
            this.preferences.put(PREFERENCE_KEY_TABBED_WINDOW, property.getValueAsText());
        }
        if ((property = this.context.getPropertySet().getProperty(PREFERENCE_KEY_VALIDATE_PATHS)) != null) {
            this.preferences.put(PREFERENCE_KEY_VALIDATE_PATHS, property.getValueAsText());
        }
        if ((property = this.context.getPropertySet().getProperty(PREFERENCE_KEY_SHOW_EXECUTION_OUTPUT)) != null) {
            this.preferences.put(PREFERENCE_KEY_SHOW_EXECUTION_OUTPUT, property.getValueAsText());
        }
        if ((property = this.context.getPropertySet().getProperty(PREFERENCE_KEY_AUTOCOMPLETE)) != null) {
            this.preferences.put(PREFERENCE_KEY_AUTOCOMPLETE, property.getValueAsText());
        }
        if ((property = this.context.getPropertySet().getProperty(PREFERENCE_KEY_SHOW_EMPTY_PRODUCT_WARNING)) != null) {
            if (Boolean.parseBoolean(property.getValueAsText())) {
                this.preferences.remove("sta.warn.no.product.decision");
            } else {
                this.preferences.put("sta.warn.no.product.decision", "no");
            }
        }
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("sta_editor");
    }

    private boolean getPropertyValue(String key, boolean defaultValue) {
        if (this.preferences == null) {
            this.preferences = NbPreferences.forModule(Dialogs.class);
        }
        return this.preferences.getBoolean(key, defaultValue);
    }

    private void setPropertyValue(Property property, boolean defaultValue) {
        try {
            property.setValue((Object)this.getPropertyValue(property.getName(), defaultValue));
        }
        catch (ValidationException e) {
            e.printStackTrace();
        }
    }

    static class STAOptionsBean {
        @Preference(label="Use tabs to display tool adapter details", key="sta.use.tabs")
        boolean useTabs = true;
        @Preference(label="Validate tool paths and variables on save", key="sta.validate.paths")
        boolean validatePaths = true;
        @Preference(label="Display warning when source products are missing", key="sta.warn.no.product")
        boolean warnNoProduct = true;
        @Preference(label="Display execution output", key="sta.display.output")
        boolean displayOutput = true;
        @Preference(label="Use autocomplete of parameters for template editing [experimental]", key="sta.autocomplete")
        boolean autocomplete = false;

        STAOptionsBean() {
        }
    }
}

