/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.model;

import com.bc.ceres.swing.binding.BindingContext;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.esa.snap.core.gpf.descriptor.PropertyAttributeException;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;

public abstract class PropertyMemberUIWrapper
implements FocusListener {
    protected String attributeName;
    protected JComponent UIComponent;
    protected int width = 0;
    protected ToolParameterDescriptor paramDescriptor;
    protected ToolAdapterOperatorDescriptor opDescriptor;
    private CallBackAfterEdit callback;
    private BindingContext context;
    private Logger logger;

    public PropertyMemberUIWrapper(String attributeName, ToolParameterDescriptor paramDescriptor, ToolAdapterOperatorDescriptor opDescriptor, BindingContext context) {
        this.attributeName = attributeName;
        this.paramDescriptor = paramDescriptor;
        this.opDescriptor = opDescriptor;
        this.context = context;
        this.logger = Logger.getLogger(PropertyMemberUIWrapper.class.getName());
    }

    public PropertyMemberUIWrapper(String attributeName, ToolParameterDescriptor paramDescriptor, ToolAdapterOperatorDescriptor opDescriptor, BindingContext context, int width, CallBackAfterEdit callback) {
        this(attributeName, paramDescriptor, opDescriptor, context);
        this.width = width;
        this.callback = callback;
        try {
            this.getUIComponent();
        }
        catch (Exception ex) {
            this.logger.warning(ex.getMessage());
        }
    }

    public BindingContext getContext() {
        return this.context;
    }

    public ToolParameterDescriptor getParamDescriptor() {
        return this.paramDescriptor;
    }

    public String getErrorValueMessage(Object value) {
        return null;
    }

    protected abstract void setMemberValue(Object var1) throws PropertyAttributeException;

    public abstract Object getMemberValue() throws PropertyAttributeException;

    public JComponent getUIComponent() throws Exception {
        if (this.UIComponent == null) {
            this.buildAndLinkUIComponent();
        }
        return this.UIComponent;
    }

    public JComponent reloadUIComponent(Class<?> newParamType) throws Exception {
        this.buildAndLinkUIComponent();
        return this.UIComponent;
    }

    public void buildAndLinkUIComponent() throws Exception {
        this.UIComponent = this.buildUIComponent();
        if (this.width != -1) {
            this.UIComponent.setPreferredSize(new Dimension(this.width, 20));
        }
        this.UIComponent.addFocusListener(this);
    }

    protected abstract JComponent buildUIComponent() throws Exception;

    public void setMemberValueWithCheck(Object value) throws PropertyAttributeException {
        String msg = this.getErrorValueMessage(value);
        if (msg != null) {
            throw new PropertyAttributeException(msg);
        }
        this.setMemberValue(value);
    }

    public boolean memberUIComponentNeedsRevalidation() {
        return false;
    }

    public boolean propertyUIComponentsNeedsRevalidation() {
        return false;
    }

    public boolean contextUIComponentsNeedsRevalidation() {
        return false;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!e.isTemporary()) {
            try {
                if (this.getValueFromUIComponent().equals(this.getMemberValue())) {
                    return;
                }
                this.setMemberValueWithCheck(this.getValueFromUIComponent());
                if (this.callback != null) {
                    this.callback.doCallBack(null, this.paramDescriptor, null, this.attributeName);
                }
            }
            catch (PropertyAttributeException ex) {
                if (this.callback != null) {
                    this.callback.doCallBack(ex, this.paramDescriptor, null, this.attributeName);
                }
                this.UIComponent.requestFocusInWindow();
            }
        }
    }

    public void setCallback(CallBackAfterEdit callback) {
        this.callback = callback;
    }

    protected abstract Object getValueFromUIComponent() throws PropertyAttributeException;

    public static interface CallBackAfterEdit {
        public void doCallBack(PropertyAttributeException var1, ToolParameterDescriptor var2, ToolParameterDescriptor var3, String var4);
    }
}

