/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.model;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;

public class OperatorsTableModel
extends AbstractTableModel {
    private String[] columnNames = new String[]{"Alias", "Description"};
    private List<ToolAdapterOperatorDescriptor> data = null;

    public OperatorsTableModel(List<ToolAdapterOperatorDescriptor> operators) {
        this.data = operators;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.data.get(rowIndex).getAlias();
            }
            case 1: {
                return this.data.get(rowIndex).getDescription();
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Class getColumnClass(int c) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    public ToolAdapterOperatorDescriptor getObjectAt(int rowIndex) {
        ToolAdapterOperatorDescriptor result = null;
        if (rowIndex >= 0 && rowIndex <= this.data.size() - 1) {
            result = this.data.get(rowIndex);
        }
        return result;
    }
}

