/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.model;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.DefaultPropertySetDescriptor;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.PropertySetDescriptor;
import com.bc.ceres.swing.binding.BindingContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.PropertyAttributeException;
import org.esa.snap.core.gpf.descriptor.TemplateParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.esa.snap.ui.tooladapter.dialogs.TemplateParameterEditorDialog;
import org.esa.snap.ui.tooladapter.dialogs.ToolParameterEditorDialog;
import org.esa.snap.ui.tooladapter.model.Bundle;
import org.esa.snap.ui.tooladapter.model.CustomParameterClass;
import org.esa.snap.ui.tooladapter.model.PropertyMemberUIWrapper;
import org.esa.snap.ui.tooladapter.model.PropertyMemberUIWrapperFactory;

public class OperatorParametersTable
extends JTable {
    private static String[] columnNames = new String[]{"", "Name", "Description", "Label", "Data type", "Default value", ""};
    private static String[] columnsMembers = new String[]{"del", "name", "description", "alias", "dataType", "defaultValue", "edit"};
    private static int[] widths = new int[]{27, 100, 200, 80, 100, 249, 30};
    private static final BidiMap typesMap = new DualHashBidiMap();
    private ToolAdapterOperatorDescriptor operator = null;
    private Map<ToolParameterDescriptor, PropertyMemberUIWrapper> propertiesValueUIDescriptorMap;
    private MultiRenderer tableRenderer;
    private BindingContext context;
    private DefaultCellEditor comboCellEditor;
    private TableCellRenderer comboCellRenderer;
    private AppContext appContext;
    private DefaultTableCellRenderer labelTypeCellRenderer = new DefaultTableCellRenderer();
    private Logger logger = Logger.getLogger(OperatorParametersTable.class.getName());

    public void stopVariablesTableEditing() {
        if (this.getEditingRow() >= 0 && this.getEditingColumn() >= 0) {
            this.getCellEditor(this.getEditingRow(), this.getEditingColumn()).stopCellEditing();
        }
    }

    public OperatorParametersTable(ToolAdapterOperatorDescriptor operator, AppContext appContext) {
        this.operator = operator;
        this.appContext = appContext;
        this.propertiesValueUIDescriptorMap = new HashMap<ToolParameterDescriptor, PropertyMemberUIWrapper>();
        JComboBox<Object> typesComboBox = new JComboBox<Object>(typesMap.keySet().toArray());
        this.comboCellEditor = new DefaultCellEditor(typesComboBox);
        this.comboCellRenderer = new DefaultTableCellRenderer();
        this.labelTypeCellRenderer.setText(Bundle.Type_ProductList_Text());
        List data = operator.getToolParameterDescriptors();
        PropertySet propertySet = new OperatorParameterSupport((OperatorDescriptor)operator).getPropertySet();
        this.context = new BindingContext(propertySet);
        for (ToolParameterDescriptor paramDescriptor : data) {
            if (paramDescriptor.getName().equals("sourceProduct")) {
                this.propertiesValueUIDescriptorMap.put(paramDescriptor, PropertyMemberUIWrapperFactory.buildEmptyPropertyWrapper());
                continue;
            }
            this.propertiesValueUIDescriptorMap.put(paramDescriptor, PropertyMemberUIWrapperFactory.buildPropertyWrapper("defaultValue", paramDescriptor, operator, this.context, null));
        }
        this.tableRenderer = new MultiRenderer();
        this.setModel(new OperatorParametersTableNewTableModel());
        this.setAutoResizeMode(0);
        for (int i = 0; i < widths.length; ++i) {
            this.getColumnModel().getColumn(i).setPreferredWidth(widths[i]);
        }
        this.putClientProperty("JComboBox.isTableCellEditor", Boolean.FALSE);
        this.setRowHeight(20);
    }

    public void addParameterToTable(ToolParameterDescriptor param) {
        try {
            PropertyDescriptor property = ParameterDescriptorFactory.convert((ParameterDescriptor)param, (Map)new ParameterDescriptorFactory().getSourceProductMap());
            this.operator.getToolParameterDescriptors().add(param);
            DefaultPropertySetDescriptor propertySetDescriptor = new DefaultPropertySetDescriptor();
            try {
                property.setDefaultValue((Object)param.getDefaultValue());
            }
            catch (Exception ex) {
                this.logger.warning(ex.getMessage());
            }
            propertySetDescriptor.addPropertyDescriptor(property);
            PropertyContainer container = PropertyContainer.createMapBacked(new HashMap(), (PropertySetDescriptor)propertySetDescriptor);
            this.context.getPropertySet().addProperties(container.getProperties());
            this.propertiesValueUIDescriptorMap.put(param, PropertyMemberUIWrapperFactory.buildPropertyWrapper("defaultValue", param, this.operator, this.context, null));
            this.revalidate();
        }
        catch (Exception ex) {
            this.logger.warning(ex.getMessage());
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component component = super.prepareRenderer(renderer, row, column);
        ToolParameterDescriptor descriptor = (ToolParameterDescriptor)this.operator.getToolParameterDescriptors().get(row);
        switch (descriptor.getName()) {
            case "sourceProduct": 
            case "sourceProductFile": 
            case "targetProduct": 
            case "targetProductFile": {
                component.setBackground(Color.lightGray);
                break;
            }
            default: {
                component.setBackground(SystemColor.text);
                component.setForeground(SystemColor.textText);
            }
        }
        return component;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        switch (column) {
            case 0: 
            case 5: 
            case 6: {
                return this.tableRenderer;
            }
            case 4: {
                ToolParameterDescriptor descriptor = (ToolParameterDescriptor)this.operator.getToolParameterDescriptors().get(row);
                if (descriptor.getName().equals("sourceProduct")) {
                    return this.labelTypeCellRenderer;
                }
                return this.comboCellRenderer;
            }
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        switch (column) {
            case 0: 
            case 5: 
            case 6: {
                return this.tableRenderer;
            }
            case 4: {
                return this.comboCellEditor;
            }
        }
        return this.getDefaultEditor(String.class);
    }

    public BindingContext getBindingContext() {
        return this.context;
    }

    @Override
    public boolean editCellAt(int row, int column) {
        return super.editCellAt(row, column);
    }

    private void rebuildEditorCell(ToolParameterDescriptor descriptor, Map<String, Object> attributes) {
        Property actualProperty = this.context.getPropertySet().getProperty(descriptor.getName());
        Object attribute = actualProperty.getDescriptor().getAttribute("directory");
        boolean flag = attribute != null && (Boolean)attribute != false;
        this.context.getPropertySet().removeProperty(actualProperty);
        try {
            PropertyDescriptor property;
            try {
                property = ParameterDescriptorFactory.convert((ParameterDescriptor)descriptor, (Map)new ParameterDescriptorFactory().getSourceProductMap());
            }
            catch (Exception ex) {
                this.logger.warning(ex.getMessage());
                descriptor.setDefaultValue("");
                property = ParameterDescriptorFactory.convert((ParameterDescriptor)descriptor, (Map)new ParameterDescriptorFactory().getSourceProductMap());
            }
            try {
                property.setDefaultValue((Object)descriptor.getDefaultValue());
            }
            catch (Exception ex) {
                this.logger.warning(ex.getMessage());
                property.setDefaultValue((Object)"");
            }
            if (attributes != null) {
                for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                    property.setAttribute(entry.getKey(), entry.getValue());
                }
            }
            DefaultPropertySetDescriptor propertySetDescriptor = new DefaultPropertySetDescriptor();
            propertySetDescriptor.addPropertyDescriptor(property);
            PropertyContainer container = PropertyContainer.createMapBacked(new HashMap(), (PropertySetDescriptor)propertySetDescriptor);
            try {
                container.getProperty(property.getName()).setValue(descriptor.getDefaultTypedValue());
            }
            catch (Exception ex) {
                this.logger.warning(ex.getMessage());
                try {
                    container.getProperty(property.getName()).setValue((Object)"");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.context.getPropertySet().addProperties(container.getProperties());
            this.propertiesValueUIDescriptorMap.put(descriptor, PropertyMemberUIWrapperFactory.buildPropertyWrapper("defaultValue", descriptor, this.operator, this.context, null));
            this.revalidate();
            this.repaint();
        }
        catch (ConversionException e) {
            this.logger.warning(e.getMessage());
            Dialogs.showError((String)e.getMessage());
        }
    }

    static {
        typesMap.put((Object)Bundle.Type_TemplateFileClass_Text(), (Object)CustomParameterClass.TemplateFileClass);
        typesMap.put((Object)Bundle.Type_BeforeTemplateFileClass_Text(), (Object)CustomParameterClass.BeforeTemplateFileClass);
        typesMap.put((Object)Bundle.Type_AfterTemplateFileClass_Text(), (Object)CustomParameterClass.AfterTemplateFileClass);
        typesMap.put((Object)Bundle.Type_RegularFileClass_Text(), (Object)CustomParameterClass.RegularFileClass);
        typesMap.put((Object)Bundle.Type_FolderClass_Text(), (Object)CustomParameterClass.FolderClass);
        typesMap.put((Object)Bundle.Type_FileListClass_Text(), (Object)CustomParameterClass.FileListClass);
        typesMap.put((Object)Bundle.Type_StringClass_Text(), (Object)CustomParameterClass.StringClass);
        typesMap.put((Object)Bundle.Type_IntegerClass_Text(), (Object)CustomParameterClass.IntegerClass);
        typesMap.put((Object)Bundle.Type_ListClass_Text(), (Object)CustomParameterClass.ListClass);
        typesMap.put((Object)Bundle.Type_BooleanClass_Text(), (Object)CustomParameterClass.BooleanClass);
        typesMap.put((Object)Bundle.Type_FloatClass_Text(), (Object)CustomParameterClass.FloatClass);
    }

    class MultiRenderer
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        private TableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
        private AbstractButton delButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"/org/esa/snap/resources/images/icons/DeleteShapeTool16.gif"), (boolean)false);
        private AbstractButton editButton = new JButton("...");

        public MultiRenderer() {
            this.delButton.addActionListener(e -> this.fireEditingStopped());
            this.editButton.addActionListener(e -> this.fireEditingStopped());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ToolParameterDescriptor descriptor = (ToolParameterDescriptor)OperatorParametersTable.this.operator.getToolParameterDescriptors().get(row);
            switch (column) {
                case 0: {
                    return this.delButton;
                }
                case 5: {
                    try {
                        return ((PropertyMemberUIWrapper)OperatorParametersTable.this.propertiesValueUIDescriptorMap.get(descriptor)).getUIComponent();
                    }
                    catch (Exception e) {
                        OperatorParametersTable.this.logger.warning(e.getMessage());
                        return null;
                    }
                }
                case 6: {
                    return this.editButton;
                }
            }
            return this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ToolParameterDescriptor descriptor = (ToolParameterDescriptor)OperatorParametersTable.this.operator.getToolParameterDescriptors().get(row);
            switch (column) {
                case 0: {
                    return this.delButton;
                }
                case 5: {
                    try {
                        return ((PropertyMemberUIWrapper)OperatorParametersTable.this.propertiesValueUIDescriptorMap.get(descriptor)).getUIComponent();
                    }
                    catch (Exception e) {
                        OperatorParametersTable.this.logger.warning(e.getMessage());
                        return null;
                    }
                }
                case 6: {
                    return this.editButton;
                }
            }
            return OperatorParametersTable.this.getDefaultEditor(String.class).getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    class OperatorParametersTableNewTableModel
    extends AbstractTableModel {
        OperatorParametersTableNewTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return columnNames[column];
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            return OperatorParametersTable.this.operator.getToolParameterDescriptors().size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            ToolParameterDescriptor descriptor = (ToolParameterDescriptor)OperatorParametersTable.this.operator.getToolParameterDescriptors().get(row);
            switch (column) {
                case 0: {
                    return false;
                }
                case 4: {
                    if (descriptor.getName().equals("sourceProduct")) {
                        return Bundle.Type_ProductList_Text();
                    }
                    if (descriptor.getName().equals("sourceProductFile")) {
                        return Bundle.Type_FileListClass_Text();
                    }
                    if (CustomParameterClass.getObject(descriptor.getDataType(), descriptor.getParameterType()).equals(CustomParameterClass.FolderClass)) {
                        return Bundle.Type_FolderClass_Text();
                    }
                    return typesMap.getKey((Object)CustomParameterClass.getObject(descriptor.getDataType(), descriptor.getParameterType()));
                }
                case 6: {
                    return false;
                }
            }
            try {
                return descriptor.getAttribute(columnsMembers[column]);
            }
            catch (PropertyAttributeException e) {
                OperatorParametersTable.this.logger.warning(e.getMessage());
                return String.format("Error: %s", e.getMessage());
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            ToolParameterDescriptor descriptor = (ToolParameterDescriptor)OperatorParametersTable.this.operator.getToolParameterDescriptors().get(rowIndex);
            String descriptorName = descriptor.getName();
            Class dataType = descriptor.getDataType();
            return !"sourceProduct".equals(descriptorName) && !"sourceProductFile".equals(descriptorName) && (!"targetProductFile".equals(descriptorName) || columnIndex != 0 && columnIndex != 1 && columnIndex != 4 && columnIndex != 6) && (!dataType.isArray() || columnIndex <= 4);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ToolParameterDescriptor descriptor = (ToolParameterDescriptor)OperatorParametersTable.this.operator.getToolParameterDescriptors().get(rowIndex);
            String oldName = descriptor.getName();
            Object defaultValue = OperatorParametersTable.this.context.getPropertySet().getProperty(oldName).getValue();
            switch (columnIndex) {
                case 0: {
                    OperatorParametersTable.this.operator.removeParamDescriptor(descriptor);
                    OperatorParametersTable.this.revalidate();
                    break;
                }
                case 1: {
                    descriptor.setName(aValue.toString());
                    OperatorParametersTable.this.context.getPropertySet().removeProperty(OperatorParametersTable.this.context.getPropertySet().getProperty(oldName));
                    try {
                        PropertyDescriptor property = ParameterDescriptorFactory.convert((ParameterDescriptor)descriptor, (Map)new ParameterDescriptorFactory().getSourceProductMap());
                        if (defaultValue != null) {
                            descriptor.setDefaultValue(defaultValue.toString());
                            try {
                                property.setDefaultValue(defaultValue);
                            }
                            catch (Exception ex) {
                                OperatorParametersTable.this.logger.warning(ex.getMessage());
                            }
                        }
                        if (descriptor.getParameterType().equals("FolderParameter")) {
                            property.setAttribute("directory", (Object)true);
                        }
                        DefaultPropertySetDescriptor propertySetDescriptor = new DefaultPropertySetDescriptor();
                        propertySetDescriptor.addPropertyDescriptor(property);
                        PropertyContainer container = PropertyContainer.createMapBacked(new HashMap(), (PropertySetDescriptor)propertySetDescriptor);
                        try {
                            container.setDefaultValues();
                        }
                        catch (IllegalStateException ex) {
                            OperatorParametersTable.this.logger.warning(ex.getMessage());
                        }
                        OperatorParametersTable.this.context.getPropertySet().addProperties(container.getProperties());
                        OperatorParametersTable.this.propertiesValueUIDescriptorMap.put(descriptor, PropertyMemberUIWrapperFactory.buildPropertyWrapper("defaultValue", descriptor, OperatorParametersTable.this.operator, OperatorParametersTable.this.context, null));
                        OperatorParametersTable.this.revalidate();
                        OperatorParametersTable.this.repaint();
                    }
                    catch (ConversionException e) {
                        OperatorParametersTable.this.logger.warning(e.getMessage());
                        Dialogs.showError((String)e.getMessage());
                    }
                    break;
                }
                case 4: {
                    if (descriptor.isTemplateParameter() && "TemplateParamater".equals(descriptor.getParameterType()) && (((TemplateParameterDescriptor)descriptor).getTemplate() != null || ((TemplateParameterDescriptor)descriptor).getParameterDescriptors().stream().findFirst().isPresent())) {
                        return;
                    }
                    HashMap<String, Boolean> extra = null;
                    CustomParameterClass customClass = (CustomParameterClass)typesMap.get(aValue);
                    if (customClass == null) {
                        customClass = CustomParameterClass.StringClass;
                    }
                    if (customClass.equals(CustomParameterClass.FolderClass)) {
                        extra = new HashMap<String, Boolean>();
                        extra.put("directory", Boolean.TRUE);
                    }
                    descriptor.setParameterType(customClass.getTypeMask());
                    if (descriptor.getDataType() == customClass.getParameterClass()) break;
                    descriptor.setDataType(customClass.getParameterClass());
                    if (defaultValue != null) {
                        descriptor.setDefaultValue(defaultValue.toString());
                    }
                    OperatorParametersTable.this.rebuildEditorCell(descriptor, extra);
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    int returnCode = -1;
                    if (!descriptor.isParameter() && descriptor.getDataType().equals(File.class)) {
                        try {
                            TemplateParameterEditorDialog editor = new TemplateParameterEditorDialog(OperatorParametersTable.this.appContext, "", (TemplateParameterDescriptor)descriptor, (PropertyMemberUIWrapper)OperatorParametersTable.this.propertiesValueUIDescriptorMap.get(descriptor), OperatorParametersTable.this.operator);
                            returnCode = editor.show();
                        }
                        catch (Exception ex) {
                            Dialogs.showError((String)ex.getMessage());
                        }
                    } else {
                        Object value = OperatorParametersTable.this.getBindingContext().getBinding(descriptor.getName()).getPropertyValue();
                        try {
                            ToolParameterEditorDialog editor = new ToolParameterEditorDialog(OperatorParametersTable.this.appContext, "Parameter editor for " + descriptor.getName(), descriptor, value);
                            returnCode = editor.show();
                        }
                        catch (Exception ex) {
                            OperatorParametersTable.this.logger.warning(ex.getMessage());
                            Dialogs.showError((String)("Could not edit parameter " + descriptor.getName() + " : " + ex.getMessage()));
                        }
                    }
                    if (returnCode != 1) break;
                    OperatorParametersTable.this.rebuildEditorCell(descriptor, null);
                    break;
                }
                default: {
                    try {
                        descriptor.setAttribute(columnsMembers[columnIndex], (Object)(aValue == null ? null : aValue.toString()));
                        break;
                    }
                    catch (PropertyAttributeException e) {
                        OperatorParametersTable.this.logger.warning(e.getMessage());
                    }
                }
            }
        }
    }
}

