/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.model;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class AutoCompleteTextArea
extends JTextArea {
    private InputOptionsPanel suggestion;
    private List<String> autoCompleteEntries;
    private char triggerChar;

    public AutoCompleteTextArea(String text, int rows, int columns) {
        super(text, rows, columns);
        this.addKeyListener(new KeyListener(){
            private boolean triggerCharPressed;

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n' || e.getKeyChar() == '\t' || e.getKeyChar() == ' ') {
                    if (AutoCompleteTextArea.this.suggestion != null && (this.triggerCharPressed || AutoCompleteTextArea.this.suggestion.isVisible()) && AutoCompleteTextArea.this.suggestion.insertSelection()) {
                        int position = AutoCompleteTextArea.this.getCaretPosition();
                        SwingUtilities.invokeLater(() -> {
                            try {
                                AutoCompleteTextArea.this.getDocument().remove(position - 1, 1);
                            }
                            catch (BadLocationException ex) {
                                ex.printStackTrace();
                            }
                        });
                    }
                    this.triggerCharPressed = false;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 40 && AutoCompleteTextArea.this.suggestion != null && this.triggerCharPressed) {
                    AutoCompleteTextArea.this.suggestion.moveDown();
                } else if (e.getKeyCode() == 38 && AutoCompleteTextArea.this.suggestion != null && this.triggerCharPressed) {
                    AutoCompleteTextArea.this.suggestion.moveUp();
                } else if (e.getKeyChar() == AutoCompleteTextArea.this.triggerChar) {
                    this.triggerCharPressed = true;
                    SwingUtilities.invokeLater(AutoCompleteTextArea.this::showSuggestion);
                } else if (Character.isLetterOrDigit(e.getKeyChar()) && this.triggerCharPressed || e.getKeyCode() == 8) {
                    SwingUtilities.invokeLater(AutoCompleteTextArea.this::showSuggestion);
                } else if (Character.isWhitespace(e.getKeyChar()) || e.getKeyCode() == 27) {
                    this.triggerCharPressed = false;
                    AutoCompleteTextArea.this.hideSuggestion();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
    }

    public void setTriggerChar(char trigger) {
        this.triggerChar = trigger;
    }

    public void setAutoCompleteEntries(List<String> entries) {
        this.autoCompleteEntries = entries;
    }

    protected void showSuggestion() {
        ArrayList<String> filtered;
        List<String> list;
        Point location;
        this.hideSuggestion();
        int position = this.getCaretPosition();
        try {
            location = this.modelToView(position).getLocation();
        }
        catch (BadLocationException e2) {
            return;
        }
        String text = this.getText();
        int start = Math.max(0, text.lastIndexOf(this.triggerChar, position));
        if (start + 1 > position) {
            return;
        }
        String subWord = text.substring(start + 1, position);
        if (this.suggestion == null) {
            this.suggestion = new InputOptionsPanel(this);
        }
        if (this.autoCompleteEntries != null) {
            list = this.autoCompleteEntries.stream().filter(e -> e.startsWith(subWord)).collect(Collectors.toList());
        } else {
            this.autoCompleteEntries = new ArrayList<String>();
            list = filtered = this.autoCompleteEntries;
        }
        if (filtered.isEmpty()) {
            this.hideSuggestion();
        } else {
            this.suggestion.setSuggestionList(subWord.isEmpty() ? this.autoCompleteEntries : filtered, subWord);
            this.suggestion.show(position, location);
            SwingUtilities.invokeLater(this::requestFocusInWindow);
        }
    }

    protected void hideSuggestion() {
        if (this.suggestion != null) {
            this.suggestion.hide();
        }
    }

    class InputOptionsPanel {
        private JList<String> list;
        private JPopupMenu popupMenu = new JPopupMenu();
        private String subWord;
        private int insertionPosition;
        private final JTextArea textArea;

        public InputOptionsPanel(JTextArea parent) {
            this.popupMenu.setOpaque(false);
            this.popupMenu.setBorder(null);
            this.textArea = parent;
        }

        public void hide() {
            this.popupMenu.setVisible(false);
        }

        public void show(int position, Point location) {
            this.insertionPosition = position;
            this.popupMenu.show(this.textArea, location.x, this.textArea.getBaseline(0, 0) + location.y);
        }

        public boolean isVisible() {
            return this.popupMenu.isVisible();
        }

        public void setSuggestionList(List<String> entries, String subWord) {
            this.popupMenu.removeAll();
            this.subWord = subWord;
            this.createSuggestionList(entries);
            this.popupMenu.add(this.list, "Center");
        }

        public boolean insertSelection() {
            if (this.list.getSelectedValue() != null) {
                String text = this.textArea.getText();
                try {
                    String selectedSuggestion = this.list.getSelectedValue();
                    Document document = this.textArea.getDocument();
                    int insertIndex = text.lastIndexOf(this.subWord, this.insertionPosition);
                    document.remove(insertIndex, this.subWord.length());
                    document.insertString(insertIndex, selectedSuggestion, null);
                    return true;
                }
                catch (BadLocationException ignored) {
                    this.textArea.setText(text);
                    this.hide();
                }
            }
            return false;
        }

        public void moveUp() {
            int index = Math.max(this.list.getSelectedIndex() - 1, 0);
            this.selectIndex(index);
        }

        public void moveDown() {
            int index = Math.min(this.list.getSelectedIndex() + 1, this.list.getModel().getSize() - 1);
            this.selectIndex(index);
        }

        private void createSuggestionList(List<String> entries) {
            if (this.list == null) {
                this.list = new JList<String>(entries.toArray(new String[entries.size()]));
                this.list.setDoubleBuffered(true);
                this.list.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 0));
                this.list.setSelectionMode(0);
                this.list.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() == 2) {
                            InputOptionsPanel.this.insertSelection();
                        }
                    }
                });
            } else {
                this.list.removeAll();
                this.list.setListData((String[])entries.toArray(new String[entries.size()]));
            }
            this.list.setSelectedIndex(0);
        }

        private void selectIndex(int index) {
            int position = this.textArea.getCaretPosition();
            this.list.setSelectedIndex(index);
            SwingUtilities.invokeLater(() -> this.textArea.setCaretPosition(position));
        }
    }
}

