/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs;

import com.bc.ceres.binding.DefaultPropertySetDescriptor;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.PropertySetDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.internal.CheckBoxEditor;
import com.bc.ceres.swing.binding.internal.TextFieldEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.gpf.descriptor.DefaultParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.tooladapter.actions.EscapeAction;
import org.esa.snap.ui.tooladapter.dialogs.ToolAdapterEditorDialog;
import org.esa.snap.ui.tooladapter.model.PropertyMemberUIWrapper;
import org.esa.snap.ui.tooladapter.model.PropertyMemberUIWrapperFactory;
import org.esa.snap.ui.tooladapter.validators.RequiredFieldValidator;
import org.esa.snap.ui.tooladapter.validators.TypedValueValidator;

public class ToolParameterEditorDialog
extends ModalDialog {
    private ToolParameterDescriptor parameter;
    private ToolParameterDescriptor oldParameter;
    private PropertyContainer container;
    private BindingContext valuesContext;
    private BindingContext paramContext;
    private PropertyMemberUIWrapper uiWrapper;
    private JComponent editorComponent;
    private JPanel mainPanel;
    public static final String helpID = "sta_editor";
    private Logger logger;
    private static final BidiMap typesMap = new DualHashBidiMap();

    public ToolParameterEditorDialog(AppContext appContext, String title, ToolParameterDescriptor parameter, Object value) throws Exception {
        super(appContext.getApplicationWindow(), parameter.getName(), 33, helpID);
        this.oldParameter = parameter;
        this.parameter = new ToolParameterDescriptor((DefaultParameterDescriptor)parameter);
        this.parameter.setDefaultValue(value != null ? value.toString() : parameter.getDataType().newInstance().toString());
        this.container = PropertyContainer.createObjectBacked((Object)this.parameter);
        this.valuesContext = new BindingContext((PropertySet)this.container);
        this.createContextForValueEditor();
        this.logger = Logger.getLogger(ToolAdapterEditorDialog.class.getName());
        this.setContent(this.createMainPanel());
        this.getJDialog().setPreferredSize(new Dimension(500, 500));
        EscapeAction.register(this.getJDialog());
    }

    private void createContextForValueEditor() throws Exception {
        PropertyDescriptor property = ParameterDescriptorFactory.convert((ParameterDescriptor)this.parameter, (Map)new ParameterDescriptorFactory().getSourceProductMap());
        DefaultPropertySetDescriptor propertySetDescriptor = new DefaultPropertySetDescriptor();
        try {
            property.setDefaultValue((Object)this.parameter.getDefaultValue());
        }
        catch (Exception ex) {
            this.logger.warning(ex.getMessage());
        }
        propertySetDescriptor.addPropertyDescriptor(property);
        PropertyContainer container = PropertyContainer.createMapBacked(new HashMap(), (PropertySetDescriptor)propertySetDescriptor);
        container.getProperty(property.getName()).setValueFromText(this.parameter.getDefaultValue());
        this.paramContext = new BindingContext((PropertySet)container);
        this.uiWrapper = PropertyMemberUIWrapperFactory.buildPropertyWrapper("defaultValue", this.parameter, null, this.paramContext, null);
        this.editorComponent = this.uiWrapper.getUIComponent();
    }

    public JPanel createMainPanel() {
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{100, 390};
        this.mainPanel = new JPanel(layout);
        this.addTextPropertyEditor(this.mainPanel, "Name: ", "name", this.parameter.getName(), 0, true);
        this.addTextPropertyEditor(this.mainPanel, "Alias: ", "alias", this.parameter.getAlias(), 1, true);
        this.mainPanel.add((Component)new JLabel("Type"), this.getConstraints(2, 0, 1));
        JComboBox<Object> comboEditor = new JComboBox<Object>(typesMap.keySet().toArray());
        comboEditor.setSelectedItem(typesMap.getKey((Object)this.parameter.getDataType()));
        comboEditor.addActionListener(ev -> {
            JComboBox cb = (JComboBox)ev.getSource();
            String typeName = (String)cb.getSelectedItem();
            if (!this.parameter.getDataType().equals(typesMap.get((Object)typeName))) {
                this.parameter.setDataType((Class)typesMap.get((Object)typeName));
                this.parameter.setValueSet(null);
                this.paramContext.getPropertySet().getProperty(this.parameter.getName()).getDescriptor().setValueSet(null);
                try {
                    this.valuesContext.getPropertySet().getProperty("valueSet").setValue(null);
                }
                catch (ValidationException e) {
                    this.logger.warning(e.getMessage());
                }
                try {
                    if (this.editorComponent != null) {
                        this.mainPanel.remove(this.editorComponent);
                    }
                    this.editorComponent = this.uiWrapper.reloadUIComponent((Class)typesMap.get((Object)typeName));
                    if (!"File".equals(typeName) && !"List".equals(typeName)) {
                        this.editorComponent.setInputVerifier(new TypedValueValidator("The value entered is not of the specified data type", this.parameter.getDataType()));
                    }
                    this.mainPanel.add((Component)this.editorComponent, this.getConstraints(3, 1, 1));
                    this.mainPanel.revalidate();
                }
                catch (Exception e) {
                    this.logger.warning(e.getMessage());
                    Dialogs.showError((String)e.getMessage());
                }
            }
        });
        this.mainPanel.add(comboEditor, this.getConstraints(2, 1, 1));
        this.mainPanel.add((Component)new JLabel("Default value"), this.getConstraints(3, 0, 1));
        try {
            this.editorComponent = this.uiWrapper.getUIComponent();
            this.mainPanel.add((Component)this.editorComponent, this.getConstraints(3, 1, 1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addTextPropertyEditor(this.mainPanel, "Description: ", "description", this.parameter.getDescription(), 4, false);
        this.addTextPropertyEditor(this.mainPanel, "Label: ", "label", this.parameter.getLabel(), 5, false);
        this.addTextPropertyEditor(this.mainPanel, "Unit: ", "unit", this.parameter.getUnit(), 6, false);
        this.addTextPropertyEditor(this.mainPanel, "Interval: ", "interval", this.parameter.getInterval(), 7, false);
        final JComponent valueSetEditor = this.addTextPropertyEditor(this.mainPanel, "Value set: ", "valueSet", StringUtils.join((Object[])this.parameter.getValueSet(), (String)","), 8, false);
        valueSetEditor.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent ev) {
                try {
                    String newValueSet = ((JTextField)valueSetEditor).getText();
                    if (newValueSet.isEmpty()) {
                        ToolParameterEditorDialog.this.parameter.setValueSet(null);
                        ToolParameterEditorDialog.this.valuesContext.getPropertySet().getProperty("valueSet").setValue(null);
                    } else {
                        ToolParameterEditorDialog.this.parameter.setValueSet(newValueSet.split(","));
                        ToolParameterEditorDialog.this.valuesContext.getPropertySet().getProperty("valueSet").setValue((Object)newValueSet.split(","));
                    }
                    if (ToolParameterEditorDialog.this.editorComponent != null) {
                        ToolParameterEditorDialog.this.mainPanel.remove(ToolParameterEditorDialog.this.editorComponent);
                    }
                    ToolParameterEditorDialog.this.createContextForValueEditor();
                    if (!File.class.equals((Object)ToolParameterEditorDialog.this.parameter.getDataType()) && !ToolParameterEditorDialog.this.parameter.getDataType().isArray()) {
                        ToolParameterEditorDialog.this.editorComponent.setInputVerifier(new TypedValueValidator("The value entered is not of the specified data type", ToolParameterEditorDialog.this.parameter.getDataType()));
                    }
                    ToolParameterEditorDialog.this.mainPanel.add((Component)ToolParameterEditorDialog.this.editorComponent, ToolParameterEditorDialog.this.getConstraints(3, 1, 1));
                    ToolParameterEditorDialog.this.mainPanel.revalidate();
                }
                catch (Exception e) {
                    ToolParameterEditorDialog.this.logger.warning(e.getMessage());
                    Dialogs.showError((String)e.getMessage());
                }
            }
        });
        this.addTextPropertyEditor(this.mainPanel, "Condition: ", "condition", this.parameter.getCondition(), 9, false);
        this.addTextPropertyEditor(this.mainPanel, "Pattern: ", "pattern", this.parameter.getPattern(), 10, false);
        this.addTextPropertyEditor(this.mainPanel, "Format: ", "format", this.parameter.getFormat(), 11, false);
        this.addBoolPropertyEditor(this.mainPanel, "Not null", "notNull", this.parameter.isNotNull(), 12);
        this.addBoolPropertyEditor(this.mainPanel, "Not empty", "notEmpty", this.parameter.isNotEmpty(), 13);
        this.addTextPropertyEditor(this.mainPanel, "ItemAlias: ", "itemAlias", this.parameter.getItemAlias(), 14, false);
        this.addBoolPropertyEditor(this.mainPanel, "Deprecated", "deprecated", this.parameter.isDeprecated(), 15);
        return this.mainPanel;
    }

    private JComponent addTextPropertyEditor(JPanel parent, String label, String propertyName, String value, int line, boolean isRequired) {
        parent.add((Component)new JLabel(label), this.getConstraints(line, 0, 1));
        PropertyDescriptor propertyDescriptor = this.container.getDescriptor(propertyName);
        TextFieldEditor textEditor = new TextFieldEditor();
        JComponent editorComponent = textEditor.createEditorComponent(propertyDescriptor, this.valuesContext);
        ((JTextField)editorComponent).setText(value);
        if (isRequired) {
            editorComponent.setInputVerifier(new RequiredFieldValidator("This field is required"));
        }
        parent.add((Component)editorComponent, this.getConstraints(line, 1, 1));
        return editorComponent;
    }

    private JComponent addBoolPropertyEditor(JPanel parent, String label, String propertyName, Boolean value, int line) {
        parent.add((Component)new JLabel(label), this.getConstraints(line, 1, 1));
        PropertyDescriptor propertyDescriptor = this.container.getDescriptor(propertyName);
        CheckBoxEditor boolEditor = new CheckBoxEditor();
        JComponent editorComponent = boolEditor.createEditorComponent(propertyDescriptor, this.valuesContext);
        ((JCheckBox)editorComponent).setSelected(value);
        editorComponent.setPreferredSize(new Dimension(30, 30));
        GridBagConstraints constraints = this.getConstraints(line, 0, 1);
        constraints.fill = 0;
        constraints.anchor = 22;
        parent.add((Component)editorComponent, constraints);
        return editorComponent;
    }

    private GridBagConstraints getConstraints(int row, int col, int noCells) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = col;
        c.gridy = row;
        if (noCells != -1) {
            c.gridwidth = noCells;
        }
        c.insets = new Insets(2, 10, 2, 10);
        return c;
    }

    protected void onOK() {
        super.onOK();
        if (this.parameter.getName() != null) {
            this.oldParameter.setName(this.parameter.getName());
        }
        if (this.parameter.getAlias() != null) {
            this.oldParameter.setAlias(this.parameter.getAlias());
        }
        if (this.parameter.getDataType() != null) {
            this.oldParameter.setDataType(this.parameter.getDataType());
        }
        if (this.paramContext.getBinding(this.parameter.getName()).getPropertyValue() != null) {
            this.oldParameter.setDefaultValue(this.paramContext.getBinding(this.parameter.getName()).getPropertyValue().toString());
        }
        if (this.parameter.getDescription() != null) {
            this.oldParameter.setDescription(this.parameter.getDescription());
        }
        if (this.parameter.getLabel() != null) {
            this.oldParameter.setLabel(this.parameter.getLabel());
        }
        if (this.parameter.getUnit() != null) {
            this.oldParameter.setUnit(this.parameter.getUnit());
        }
        if (this.parameter.getInterval() != null) {
            this.oldParameter.setInterval(this.parameter.getInterval());
        }
        if (this.parameter.getValueSet() != null) {
            this.oldParameter.setValueSet(this.parameter.getValueSet());
        }
        if (this.parameter.getCondition() != null) {
            this.oldParameter.setCondition(this.parameter.getCondition());
        }
        if (this.parameter.getPattern() != null) {
            this.oldParameter.setPattern(this.parameter.getPattern());
        }
        if (this.parameter.getFormat() != null) {
            this.oldParameter.setFormat(this.parameter.getFormat());
        }
        this.oldParameter.setNotNull(this.parameter.isNotNull());
        this.oldParameter.setNotEmpty(this.parameter.isNotEmpty());
        if (this.parameter.getRasterDataNodeClass() != null) {
            this.oldParameter.setRasterDataNodeClass(this.parameter.getRasterDataNodeClass());
        }
        if (this.parameter.getValidatorClass() != null) {
            this.oldParameter.setValidatorClass(this.parameter.getValidatorClass());
        }
        if (this.parameter.getConverterClass() != null) {
            this.oldParameter.setConverterClass(this.parameter.getConverterClass());
        }
        if (this.parameter.getDomConverterClass() != null) {
            this.oldParameter.setDomConverterClass(this.parameter.getDomConverterClass());
        }
        if (this.parameter.getItemAlias() != null) {
            this.oldParameter.setItemAlias(this.parameter.getItemAlias());
        }
        this.oldParameter.setDeprecated(this.parameter.isDeprecated());
        this.oldParameter.setParameterType(this.parameter.getParameterType());
    }

    static {
        typesMap.put((Object)"String", String.class);
        typesMap.put((Object)"File", File.class);
        typesMap.put((Object)"Integer", Integer.class);
        typesMap.put((Object)"List", String[].class);
        typesMap.put((Object)"Boolean", Boolean.class);
    }
}

