/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.validators.NotEmptyValidator;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import com.bc.ceres.swing.binding.internal.TextFieldEditor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import org.esa.snap.core.gpf.descriptor.SystemDependentVariable;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.core.gpf.descriptor.TemplateParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.esa.snap.ui.tooladapter.dialogs.AbstractAdapterEditor;
import org.esa.snap.ui.tooladapter.dialogs.Bundle;
import org.esa.snap.ui.tooladapter.model.OperationType;
import org.esa.snap.ui.tooladapter.validators.RegexFieldValidator;
import org.esa.snap.utils.SpringUtilities;

public class ToolAdapterTabbedEditorDialog
extends AbstractAdapterEditor {
    public ToolAdapterTabbedEditorDialog(AppContext appContext, JDialog parent, ToolAdapterOperatorDescriptor operatorDescriptor, OperationType operation) {
        super(appContext, parent, operatorDescriptor, operation);
    }

    public ToolAdapterTabbedEditorDialog(AppContext appContext, JDialog parent, ToolAdapterOperatorDescriptor operatorDescriptor, int newNameIndex, OperationType operation) {
        super(appContext, parent, operatorDescriptor, newNameIndex, operation);
    }

    @Override
    protected JTabbedPane createMainPanel() {
        JTabbedPane tabbedPane = new JTabbedPane(2);
        tabbedPane.setBorder(BorderFactory.createEmptyBorder());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        double widthRatio = 0.5;
        this.formWidth = Math.max((int)((double)screenSize.width * widthRatio), 640);
        double heightRatio = 0.5;
        int formHeight = Math.max((int)((double)screenSize.height * heightRatio), 512);
        tabbedPane.setPreferredSize(new Dimension(this.formWidth, formHeight));
        this.getJDialog().setMinimumSize(new Dimension(this.formWidth + 16, formHeight + 72));
        this.addTab(tabbedPane, Bundle.CTL_Panel_OperatorDescriptor_Text(), this.createDescriptorTab());
        this.addTab(tabbedPane, Bundle.CTL_Panel_ConfigParams_Text(), this.createToolInfoPanel());
        this.addTab(tabbedPane, Bundle.CTL_Panel_PreProcessing_Border_TitleText(), this.createPreProcessingTab());
        this.addTab(tabbedPane, Bundle.CTL_Panel_OpParams_Border_TitleText(), this.createParametersTab(this.formWidth));
        this.addTab(tabbedPane, Bundle.CTL_Panel_SysVar_Border_TitleText(), this.createVariablesPanel());
        this.formWidth = tabbedPane.getTabComponentAt(0).getWidth();
        return tabbedPane;
    }

    @Override
    protected JPanel createDescriptorPanel() {
        JPanel descriptorPanel = new JPanel(new SpringLayout());
        TextFieldEditor textEditor = new TextFieldEditor();
        this.addValidatedTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Alias_Text(), "alias", "[^\\\\\\?%\\*:\\|\"<>\\./]*");
        this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_UniqueName_Text(), "name", true);
        this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Label_Text(), "label", true);
        this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Version_Text(), "version", true);
        this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Copyright_Text(), "copyright", false);
        this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Authors_Text(), "authors", false);
        this.addTextField(descriptorPanel, textEditor, Bundle.CTL_Label_Description_Text(), "description", false);
        this.propertyContainer.addPropertyChangeListener("alias", evt -> this.propertyContainer.setValue("name", (Object)("org.esa.snap.core.gpf.operators.tooladapter." + evt.getNewValue().toString())));
        List<String> menus = this.getAvailableMenuOptions(null);
        this.addComboField(descriptorPanel, Bundle.CTL_Label_MenuLocation_Text(), "menuLocation", menus, true, true);
        this.addComboField(descriptorPanel, Bundle.CTL_Label_TemplateType_Text(), "templateType", true, false);
        SpringUtilities.makeCompactGrid(descriptorPanel, 9, 2, 2, 2, 2, 2);
        return descriptorPanel;
    }

    @Override
    protected JPanel createVariablesPanel() {
        JPanel variablesBorderPanel = new JPanel();
        BoxLayout layout = new BoxLayout(variablesBorderPanel, 3);
        variablesBorderPanel.setLayout(layout);
        AbstractButton addVariableButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)Bundle.Icon_Add()), (boolean)false);
        addVariableButton.setText(Bundle.CTL_Button_Add_Variable_Text());
        addVariableButton.setMaximumSize(new Dimension(150, this.controlHeight));
        addVariableButton.setAlignmentX(0.0f);
        AbstractButton addDependentVariableButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)Bundle.Icon_Add()), (boolean)false);
        addDependentVariableButton.setText(Bundle.CTL_Button_Add_PDVariable_Text());
        addDependentVariableButton.setMaximumSize(new Dimension(250, this.controlHeight));
        addDependentVariableButton.setAlignmentX(0.0f);
        JPanel buttonsPannel = new JPanel(new SpringLayout());
        buttonsPannel.add(addVariableButton);
        buttonsPannel.add(addDependentVariableButton);
        SpringUtilities.makeCompactGrid(buttonsPannel, 1, 2, 0, 0, 0, 0);
        buttonsPannel.setAlignmentX(0.0f);
        variablesBorderPanel.add(buttonsPannel);
        this.varTable.setAutoResizeMode(3);
        this.varTable.setRowHeight(this.controlHeight);
        int[] widths = new int[]{this.controlHeight, (int)((double)this.formWidth * 0.3), (int)((double)this.formWidth * 0.7) - this.controlHeight};
        for (int i = 0; i < widths.length; ++i) {
            this.varTable.getColumnModel().getColumn(i).setPreferredWidth(widths[i]);
        }
        JScrollPane scrollPane = new JScrollPane(this.varTable);
        scrollPane.setAlignmentX(0.0f);
        variablesBorderPanel.add(scrollPane);
        variablesBorderPanel.setAlignmentX(0.0f);
        Dimension variablesPanelDimension = new Dimension((this.formWidth - 6) / 2 - 4, 130);
        variablesBorderPanel.setMinimumSize(variablesPanelDimension);
        variablesBorderPanel.setMaximumSize(variablesPanelDimension);
        variablesBorderPanel.setPreferredSize(variablesPanelDimension);
        addVariableButton.addActionListener(e -> {
            this.newOperatorDescriptor.getVariables().add(new SystemVariable("key", ""));
            this.varTable.revalidate();
        });
        addDependentVariableButton.addActionListener(e -> {
            this.newOperatorDescriptor.getVariables().add(new SystemDependentVariable("key", ""));
            this.varTable.revalidate();
        });
        return variablesBorderPanel;
    }

    @Override
    protected JPanel createPreProcessingPanel() {
        JPanel preProcessingPanel = new JPanel(new SpringLayout());
        PropertyDescriptor propertyDescriptor = this.propertyContainer.getDescriptor("preprocessorExternalTool");
        PropertyEditor editor = PropertyEditorRegistry.getInstance().findPropertyEditor(propertyDescriptor);
        JComponent editorComponent = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        editorComponent.setMaximumSize(new Dimension(editorComponent.getMaximumSize().width, this.controlHeight));
        editorComponent.setPreferredSize(new Dimension(editorComponent.getPreferredSize().width, this.controlHeight));
        preProcessingPanel.add(this.createCheckboxComponent("preprocessTool", editorComponent, this.newOperatorDescriptor.getPreprocessTool()));
        preProcessingPanel.add(new JLabel(Bundle.CTL_Label_PreprocessingTool_Text()));
        preProcessingPanel.add(editorComponent);
        propertyDescriptor = this.propertyContainer.getDescriptor("processingWriter");
        editor = PropertyEditorRegistry.getInstance().findPropertyEditor(propertyDescriptor);
        editorComponent = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        editorComponent.setMaximumSize(new Dimension(editorComponent.getMaximumSize().width, this.controlHeight));
        editorComponent.setPreferredSize(new Dimension(editorComponent.getPreferredSize().width, this.controlHeight));
        JComponent writeComponent = this.createCheckboxComponent("writeForProcessing", editorComponent, this.newOperatorDescriptor.shouldWriteBeforeProcessing());
        preProcessingPanel.add(writeComponent);
        preProcessingPanel.add(new JLabel(Bundle.CTL_Label_WriteBefore_Text()));
        preProcessingPanel.add(editorComponent);
        SpringUtilities.makeCompactGrid(preProcessingPanel, 2, 3, 2, 2, 2, 2);
        return preProcessingPanel;
    }

    @Override
    protected JPanel createToolInfoPanel() {
        JPanel configPanel = new JPanel(new SpringLayout());
        JPanel panelToolFiles = new JPanel(new SpringLayout());
        PropertyEditorRegistry editorRegistry = PropertyEditorRegistry.getInstance();
        PropertyDescriptor propertyDescriptor = this.propertyContainer.getDescriptor("mainToolFileLocation");
        propertyDescriptor.setValidator((Validator)new NotEmptyValidator());
        PropertyEditor editor = editorRegistry.findPropertyEditor(propertyDescriptor);
        JComponent editorComponent = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        editorComponent.setMaximumSize(new Dimension(editorComponent.getMaximumSize().width, this.controlHeight));
        editorComponent.setPreferredSize(new Dimension(editorComponent.getPreferredSize().width, this.controlHeight));
        panelToolFiles.add(new JLabel(Bundle.CTL_Label_ToolLocation_Text()));
        panelToolFiles.add(editorComponent);
        propertyDescriptor = this.propertyContainer.getDescriptor("workingDir");
        propertyDescriptor.setAttribute("directory", (Object)true);
        propertyDescriptor.setValidator((property, value) -> {
            if (value == null || value.toString().trim().isEmpty()) {
                throw new ValidationException(MessageFormat.format("Value for ''{0}'' must not be empty.", property.getDescriptor().getDisplayName()));
            }
        });
        editor = editorRegistry.findPropertyEditor(propertyDescriptor);
        editorComponent = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        editorComponent.setMaximumSize(new Dimension(editorComponent.getMaximumSize().width, this.controlHeight));
        editorComponent.setPreferredSize(new Dimension(editorComponent.getPreferredSize().width, this.controlHeight));
        panelToolFiles.add(new JLabel(Bundle.CTL_Label_WorkDir_Text()));
        panelToolFiles.add(editorComponent);
        SpringUtilities.makeCompactGrid(panelToolFiles, 2, 2, 2, 2, 2, 2);
        configPanel.add(panelToolFiles);
        JPanel checkPanel = new JPanel(new SpringLayout());
        propertyDescriptor = this.propertyContainer.getDescriptor("isHandlingOutputName");
        editor = editorRegistry.findPropertyEditor(propertyDescriptor);
        editorComponent = editor.createEditorComponent(propertyDescriptor, this.bindingContext);
        editorComponent.setMaximumSize(new Dimension(editorComponent.getMaximumSize().width, this.controlHeight));
        editorComponent.setPreferredSize(new Dimension(editorComponent.getPreferredSize().width, this.controlHeight));
        checkPanel.add(editorComponent);
        checkPanel.add(new JLabel("Tool produces the name of the output product"));
        SpringUtilities.makeCompactGrid(checkPanel, 1, 2, 2, 2, 2, 2);
        configPanel.add(checkPanel);
        JLabel label = new JLabel(Bundle.CTL_Label_CmdLineTemplate_Text());
        configPanel.add(label);
        JScrollPane scrollPane = new JScrollPane(this.createTemplateEditorField());
        configPanel.add(scrollPane);
        configPanel.add(this.createPatternsPanel());
        SpringUtilities.makeCompactGrid(configPanel, 5, 1, 2, 2, 2, 2);
        return configPanel;
    }

    @Override
    protected JPanel createPatternsPanel() {
        JPanel patternsPanel = new JPanel(new SpringLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(Bundle.CTL_Panel_OutputPattern_Border_TitleText());
        titledBorder.setTitleJustification(2);
        patternsPanel.setBorder(titledBorder);
        TextFieldEditor textEditor = new TextFieldEditor();
        this.addTextField(patternsPanel, textEditor, Bundle.CTL_Label_ProgressPattern(), "progressPattern", false);
        this.propertyContainer.getDescriptor("progressPattern").setValidator((Validator)new RegexFieldValidator());
        this.addTextField(patternsPanel, textEditor, Bundle.CTL_Label_StepPattern(), "stepPattern", false);
        this.propertyContainer.getDescriptor("stepPattern").setValidator((Validator)new RegexFieldValidator());
        this.addTextField(patternsPanel, textEditor, Bundle.CTL_Label_ErrorPattern(), "errorPattern", false);
        this.propertyContainer.getDescriptor("errorPattern").setValidator((Validator)new RegexFieldValidator());
        SpringUtilities.makeCompactGrid(patternsPanel, 3, 2, 2, 2, 2, 2);
        return patternsPanel;
    }

    @Override
    protected JPanel createParametersPanel() {
        JPanel paramsPanel = new JPanel();
        BoxLayout layout = new BoxLayout(paramsPanel, 3);
        paramsPanel.setLayout(layout);
        AbstractButton addParamBut = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)Bundle.Icon_Add()), (boolean)false);
        addParamBut.setText("New Parameter");
        addParamBut.setMaximumSize(new Dimension(150, this.controlHeight));
        addParamBut.setAlignmentX(0.0f);
        addParamBut.setAlignmentY(0.0f);
        paramsPanel.add(addParamBut);
        JScrollPane tableScrollPane = new JScrollPane(this.paramsTable);
        tableScrollPane.setAlignmentX(0.0f);
        paramsPanel.add(tableScrollPane);
        addParamBut.addActionListener(e -> {
            this.paramsTable.addParameterToTable((ToolParameterDescriptor)new TemplateParameterDescriptor("parameterName", String.class));
            int rowIndex = this.paramsTable.getRowCount() - 1;
            this.paramsTable.setRowSelectionInterval(rowIndex, rowIndex);
            this.paramsTable.setEditingRow(rowIndex);
        });
        return paramsPanel;
    }

    private JPanel createPreProcessingTab() {
        JPanel preprocessAndPatternsPanel = new JPanel(new SpringLayout());
        preprocessAndPatternsPanel.add(this.createPreProcessingPanel());
        SpringUtilities.makeCompactGrid(preprocessAndPatternsPanel, 1, 1, 2, 2, 2, 2);
        preprocessAndPatternsPanel.setMaximumSize(preprocessAndPatternsPanel.getSize());
        return preprocessAndPatternsPanel;
    }

    private JPanel createDescriptorTab() {
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.add(this.createDescriptorPanel());
        SpringUtilities.makeCompactGrid(jPanel, 1, 1, 2, 2, 2, 2);
        jPanel.setMaximumSize(jPanel.getSize());
        return jPanel;
    }

    private JPanel createParametersTab(int width) {
        JPanel paramsPanel = this.createParametersPanel();
        int tableWidth = width - 4;
        int[] widths = new int[]{this.controlHeight, 5 * this.controlHeight, 5 * this.controlHeight, 3 * this.controlHeight, 3 * this.controlHeight, (int)((double)tableWidth * 0.3), 30};
        for (int i = 0; i < widths.length; ++i) {
            this.paramsTable.getColumnModel().getColumn(i).setPreferredWidth(widths[i]);
        }
        this.paramsTable.setRowHeight(this.controlHeight);
        return paramsPanel;
    }

    private void addTab(JTabbedPane tabControl, String title, JPanel content) {
        JLabel tabText = new JLabel(title, 2);
        tabText.setPreferredSize(new Dimension(6 * this.controlHeight, this.controlHeight));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(title);
        titledBorder.setTitleJustification(2);
        content.setBorder(titledBorder);
        tabControl.addTab(null, content);
        tabControl.setTabComponentAt(tabControl.getTabCount() - 1, tabText);
    }
}

