/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs;

import com.bc.ceres.binding.ValidationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.esa.snap.core.gpf.descriptor.DefaultParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.core.gpf.descriptor.TemplateParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.template.TemplateException;
import org.esa.snap.core.gpf.descriptor.template.TemplateFile;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterOp;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.esa.snap.ui.tooladapter.actions.EscapeAction;
import org.esa.snap.ui.tooladapter.model.AutoCompleteTextArea;
import org.esa.snap.ui.tooladapter.model.OperatorParametersTable;
import org.esa.snap.ui.tooladapter.model.PropertyMemberUIWrapper;

public class TemplateParameterEditorDialog
extends ModalDialog {
    private TemplateParameterDescriptor parameter;
    private ToolAdapterOperatorDescriptor fakeOperatorDescriptor;
    private ToolAdapterOperatorDescriptor parentDescriptor;
    private PropertyMemberUIWrapper fileWrapper;
    private AppContext appContext;
    private AutoCompleteTextArea fileContentArea = new AutoCompleteTextArea("", 10, 10);
    OperatorParametersTable paramsTable;
    private Logger logger;
    private PropertyChangeListener pcListener;
    private static String EMPTY_FILE_CONTENT = "[no content]";

    public TemplateParameterEditorDialog(AppContext appContext, String title, String helpID) {
        super(appContext.getApplicationWindow(), title, 33, helpID);
        this.appContext = appContext;
        this.logger = Logger.getLogger(TemplateParameterEditorDialog.class.getName());
        EscapeAction.register(this.getJDialog());
    }

    public TemplateParameterEditorDialog(AppContext appContext, String helpID, TemplateParameterDescriptor parameter, PropertyMemberUIWrapper fileWrapper, ToolAdapterOperatorDescriptor parent) {
        this(appContext, parameter.getName(), helpID);
        this.parameter = parameter;
        this.parentDescriptor = parent;
        try {
            parameter.setTemplateEngine(this.parentDescriptor.getTemplateEngine());
        }
        catch (TemplateException e) {
            e.printStackTrace();
            this.logger.warning(e.getMessage());
        }
        this.fakeOperatorDescriptor = new ToolAdapterOperatorDescriptor("OperatorForParameters", ToolAdapterOp.class);
        for (ToolParameterDescriptor param : parameter.getParameterDescriptors()) {
            this.fakeOperatorDescriptor.getToolParameterDescriptors().add(new ToolParameterDescriptor((DefaultParameterDescriptor)param));
        }
        this.fileWrapper = fileWrapper;
        if (this.fileWrapper.getContext().getPropertySet().getProperty(this.parameter.getName()).getValue() == null) {
            try {
                this.fileWrapper.getContext().getPropertySet().getProperty(this.parameter.getName()).setValue((Object)parameter.getTemplate().getTemplatePath());
            }
            catch (ValidationException e) {
                e.printStackTrace();
                this.logger.warning(e.getMessage());
            }
        }
        this.pcListener = evt -> this.updateFileAreaContent();
        this.fileWrapper.getContext().addPropertyChangeListener(this.pcListener);
        this.setContent(this.createMainPanel());
        this.pcListener = evt -> this.updateFileAreaContent();
    }

    public JPanel createParametersPanel() {
        JPanel paramsPanel = new JPanel();
        BoxLayout layout = new BoxLayout(paramsPanel, 3);
        paramsPanel.setLayout(layout);
        AbstractButton addParamBut = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"/org/esa/snap/resources/images/icons/Add16.png"), (boolean)false);
        addParamBut.setAlignmentX(0.0f);
        paramsPanel.add(addParamBut);
        this.paramsTable = new OperatorParametersTable(this.fakeOperatorDescriptor, this.appContext);
        JScrollPane tableScrollPane = new JScrollPane(this.paramsTable);
        tableScrollPane.setPreferredSize(new Dimension(500, 130));
        tableScrollPane.setAlignmentX(0.0f);
        paramsPanel.add(tableScrollPane);
        addParamBut.addActionListener(e -> this.paramsTable.addParameterToTable(new ToolParameterDescriptor("parameterName", String.class)));
        TitledBorder title = BorderFactory.createTitledBorder("Template Parameters");
        paramsPanel.setBorder(title);
        return paramsPanel;
    }

    private JPanel createMainPanel() {
        BorderLayout layout = new BorderLayout();
        JPanel mainPanel = new JPanel(layout);
        mainPanel.setPreferredSize(new Dimension(800, 550));
        JPanel filePanel = new JPanel();
        filePanel.add(new JLabel("File:"));
        try {
            JComponent fileEditor = this.fileWrapper.getUIComponent();
            fileEditor.setPreferredSize(new Dimension(770, 25));
            filePanel.add(fileEditor);
        }
        catch (Exception e) {
            this.logger.warning(e.getMessage());
        }
        mainPanel.add((Component)filePanel, "First");
        this.fileContentArea.setAutoCompleteEntries(this.getAutocompleteEntries());
        this.fileContentArea.setTriggerChar('$');
        mainPanel.add((Component)new JScrollPane(this.fileContentArea), "Center");
        this.updateFileAreaContent();
        mainPanel.add((Component)this.createParametersPanel(), "Last");
        return mainPanel;
    }

    private void updateFileAreaContent() {
        String result = null;
        try {
            File file = (File)this.fileWrapper.getContext().getPropertySet().getProperty(this.parameter.getName()).getValue();
            this.parameter.getTemplate().setFileName(file.getName());
            if (!file.isAbsolute()) {
                file = this.parameter.getTemplate().getTemplatePath();
            }
            if (file.exists()) {
                result = new String(Files.readAllBytes(file.toPath()));
            }
        }
        catch (Exception e) {
            this.logger.warning(e.getMessage());
            this.showWarningDialog("There was an error loading the template file: " + e.getMessage());
        }
        if (result != null) {
            this.fileContentArea.setText(result);
            this.fileContentArea.setCaretPosition(0);
        } else {
            this.fileContentArea.setText(EMPTY_FILE_CONTENT);
        }
    }

    protected void onOK() {
        super.onOK();
        TemplateFile template = this.parameter.getTemplate();
        this.parameter.setDefaultValue(template.getFileName());
        this.parameter.getParameterDescriptors().clear();
        for (ToolParameterDescriptor subparameter : this.fakeOperatorDescriptor.getToolParameterDescriptors()) {
            Object propertyValue;
            if (this.paramsTable.getBindingContext().getBinding(subparameter.getName()) != null && (propertyValue = this.paramsTable.getBindingContext().getBinding(subparameter.getName()).getPropertyValue()) != null) {
                subparameter.setDefaultValue(propertyValue.toString());
            }
            this.parameter.addParameterDescriptor(subparameter);
        }
        try {
            String content = this.fileContentArea.getText();
            if (!content.equals(EMPTY_FILE_CONTENT)) {
                template.setContents(content, true);
                template.save();
            }
        }
        catch (IOException | TemplateException e) {
            this.logger.warning(e.getMessage());
        }
    }

    private List<String> getAutocompleteEntries() {
        ArrayList<String> entries = new ArrayList<String>();
        entries.addAll(this.parentDescriptor.getVariables().stream().map(SystemVariable::getKey).collect(Collectors.toList()));
        for (ParameterDescriptor parameterDescriptor : this.fakeOperatorDescriptor.getParameterDescriptors()) {
            entries.add(parameterDescriptor.getName());
        }
        entries.sort(Comparator.naturalOrder());
        return entries;
    }
}

