/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.dialogs;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class ConsolePane
extends JScrollPane {
    private JTextPane textArea;
    private final StringBuilder buffer = new StringBuilder();

    public ConsolePane() {
        this.textArea = new JTextPane();
        this.textArea.setBackground(Color.BLACK);
        this.textArea.setFont(new Font("Lucida Console", 0, 10));
        this.textArea.setForeground(Color.WHITE);
        this.setViewportView(this.textArea);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(22);
        this.setWheelScrollingEnabled(true);
        this.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){
            BoundedRangeModel brm;
            boolean wasAtBottom;
            {
                this.brm = ConsolePane.this.getVerticalScrollBar().getModel();
                this.wasAtBottom = true;
            }

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!this.brm.getValueIsAdjusting()) {
                    if (this.wasAtBottom) {
                        this.brm.setValue(this.brm.getMaximum());
                    }
                } else {
                    this.wasAtBottom = this.brm.getValue() + this.brm.getExtent() == this.brm.getMaximum();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (ConsolePane.this.buffer.length() > 0) {
                    ConsolePane.this.append(ConsolePane.this.buffer.toString());
                }
                ConsolePane.this.buffer.setLength(0);
            }
        });
    }

    public void append(String text) {
        if (this.isVisible()) {
            StyleContext sc = StyleContext.getDefaultStyleContext();
            AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, Color.WHITE);
            aset = sc.addAttribute(aset, StyleConstants.Alignment, 0);
            int len = this.textArea.getDocument().getLength();
            this.textArea.setCaretPosition(len);
            this.textArea.setCharacterAttributes(aset, false);
            this.textArea.replaceSelection("\n" + text);
            this.textArea.repaint();
        } else {
            this.buffer.append(text);
        }
    }

    public void clear() {
        this.textArea.setText("");
    }
}

