/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.actions;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterActivator;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterListener;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterOpSpi;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterRegistry;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.tooladapter.actions.ExecuteToolAdapterAction;
import org.esa.snap.utils.AdapterWatcher;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ToolAdapterActionRegistrar {
    private static final String DEFAULT_MENU_PATH = "Menu/Tools/External Tools";
    private static final Map<String, ToolAdapterOperatorDescriptor> actionMap = new HashMap<String, ToolAdapterOperatorDescriptor>();
    private static final ToolAdapterListener listener = new ToolAdapterListener(){

        public void adapterAdded(ToolAdapterOperatorDescriptor operatorDescriptor) {
            ToolAdapterActionRegistrar.registerOperatorMenu(operatorDescriptor);
        }

        public void adapterRemoved(ToolAdapterOperatorDescriptor operatorDescriptor) {
            ToolAdapterActionRegistrar.removeOperatorMenu(operatorDescriptor);
        }
    };

    public static Map<String, ToolAdapterOperatorDescriptor> getActionMap() {
        return actionMap;
    }

    public static String getDefaultMenuLocation() {
        return DEFAULT_MENU_PATH;
    }

    public static void registerOperatorMenu(ToolAdapterOperatorDescriptor operator) {
        String menuGroup = operator.getMenuLocation();
        if (menuGroup == null) {
            operator.setMenuLocation(DEFAULT_MENU_PATH);
        }
        ToolAdapterActionRegistrar.registerOperatorMenu(operator, true);
    }

    public static void registerOperatorMenu(ToolAdapterOperatorDescriptor operator, boolean hasChanged) {
        String menuLocation = operator.getMenuLocation();
        try {
            ToolAdapterActionRegistrar.getDefaultLocation();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (menuLocation == null) {
            menuLocation = ToolAdapterActionRegistrar.getDefaultMenuLocation();
            operator.setMenuLocation(menuLocation);
        }
        FileObject menuFolder = FileUtil.getConfigFile((String)menuLocation);
        try {
            String menuKey;
            FileObject newItem;
            if (menuFolder == null) {
                menuFolder = FileUtil.getConfigFile((String)"Menu");
                String[] menuTokens = menuLocation.split("/");
                for (int i = 1; i < menuTokens.length; ++i) {
                    FileObject subMenu = menuFolder.getFileObject(menuTokens[i]);
                    menuFolder = subMenu == null ? menuFolder.createFolder(menuTokens[i]) : subMenu;
                }
                menuFolder.setAttribute("position", (Object)9999);
            }
            if ((newItem = menuFolder.getFileObject(menuKey = operator.getAlias(), "instance")) == null) {
                newItem = menuFolder.createData(menuKey, "instance");
            }
            ExecuteToolAdapterAction action = new ExecuteToolAdapterAction(menuKey);
            newItem.setAttribute("instanceCreate", (Object)action);
            newItem.setAttribute("instanceClass", (Object)((Object)((Object)action)).getClass().getName());
            if (actionMap.containsKey(menuKey)) {
                actionMap.remove(menuKey);
            }
            actionMap.put(menuKey, operator);
        }
        catch (IOException e) {
            Dialogs.showError((String)("Error:" + e.getMessage()));
        }
    }

    public static void removeOperatorMenu(ToolAdapterOperatorDescriptor operator) {
        FileObject menuFolder = FileUtil.getConfigFile((String)operator.getMenuLocation());
        try {
            FileObject defaultLocation;
            FileObject[] children;
            if (menuFolder != null) {
                FileObject[] children2;
                String operatorAlias = operator.getAlias();
                FileObject newItem = menuFolder.getFileObject(operatorAlias, "instance");
                if (newItem != null) {
                    newItem.delete();
                }
                if (actionMap.containsKey(operatorAlias)) {
                    actionMap.remove(operatorAlias);
                }
                if ((children2 = menuFolder.getChildren()) == null || children2.length == 0) {
                    menuFolder.delete();
                }
            }
            if ((children = (defaultLocation = ToolAdapterActionRegistrar.getDefaultLocation()).getChildren()) == null || children.length == 0) {
                defaultLocation.delete();
            }
        }
        catch (IOException e) {
            Dialogs.showError((String)("Error:" + e.getMessage()));
        }
    }

    private static FileObject getDefaultLocation() throws IOException {
        FileObject defaultMenu = FileUtil.getConfigFile((String)DEFAULT_MENU_PATH);
        if (defaultMenu == null) {
            defaultMenu = FileUtil.getConfigFile((String)"Menu").getFileObject("Tools");
            defaultMenu = defaultMenu.createFolder(DEFAULT_MENU_PATH.replace("Menu/Tools/", ""));
            FileObject[] objects = defaultMenu.getParent().getChildren();
            int position = 9999;
            Object value = objects[objects.length - 1].getAttribute("position");
            if (value != null) {
                position = (Integer)value + 1;
            }
            defaultMenu.setAttribute("position", (Object)position);
        }
        return defaultMenu;
    }

    public static class StopOp
    implements Runnable {
        @Override
        public void run() {
            AdapterWatcher.INSTANCE.stopMonitor();
        }
    }

    public static class StartOp
    implements Runnable {
        @Override
        public void run() {
            while (!ToolAdapterActivator.isInitialized()) {
                Thread.yield();
            }
            Map operatorMap = ToolAdapterRegistry.INSTANCE.getOperatorMap();
            if (operatorMap.size() > 0) {
                for (ToolAdapterOpSpi opSpiEntry : operatorMap.values()) {
                    ToolAdapterOperatorDescriptor operatorDescriptor = (ToolAdapterOperatorDescriptor)opSpiEntry.getOperatorDescriptor();
                    ToolAdapterActionRegistrar.registerOperatorMenu(operatorDescriptor, false);
                }
            }
            ToolAdapterRegistry.INSTANCE.addListener(listener);
            AdapterWatcher.INSTANCE.startMonitor();
        }
    }
}

