/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.modules;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterIO;

public final class ModulePackager {
    private static final Manifest _manifest = new Manifest();
    private static final Attributes.Name ATTR_DESCRIPTION_NAME;
    private static final Attributes.Name ATTR_MODULE;
    private static final Attributes.Name ATTR_MODULE_NAME;
    private static final Attributes.Name ATTR_MODULE_TYPE;
    private static final Attributes.Name ATTR_MODULE_VERSION;
    private static final Attributes.Name ATTR_MODULE_ALIAS;
    private static final File modulesPath;
    private static final String layerXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE filesystem PUBLIC \"-//NetBeans//DTD Filesystem 1.1//EN\" \"http://www.netbeans.org/dtds/filesystem-1_1.dtd\">\n<filesystem>\n    <folder name=\"Actions\">\n        <folder name=\"Tools\">\n            <file name=\"org-esa-snap-ui-tooladapter-actions-ExecuteToolAdapterAction.instance\"/>\n            <attr name=\"displayName\" stringvalue=\"#NAME#\"/>\n            <attr name=\"instanceCreate\" methodvalue=\"org.openide.awt.Actions.alwaysEnabled\"/>\n        </folder>\n    </folder>\n    <folder name=\"Menu\">\n        <folder name=\"Tools\">\n            <folder name=\"External Tools\">\n                <file name=\"org-esa-snap-ui-tooladapter-actions-ExecuteToolAdapterAction.shadow\">\n                    <attr name=\"originalFile\" stringvalue=\"Actions/Tools/org-esa-snap-ui-tooladapter-actions-ExecuteToolAdapterAction.instance\"/>\n                    <attr name=\"position\" intvalue=\"1000\"/>\n                </file>\n            </folder>\n        </folder>\n    </folder>\n</filesystem>";
    private static final String LAYER_XML_PATH = "org/esa/snap/ui/tooladapter/layer.xml";

    public static void packModule(ToolAdapterOperatorDescriptor descriptor, File nbmFile) throws IOException {
        StringBuilder xmlBuilder = new StringBuilder();
        byte[] byteBuffer = null;
        try (ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(nbmFile));){
            ZipEntry entry = new ZipEntry("Info/info.xml");
            zipStream.putNextEntry(entry);
            xmlBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Autoupdate Module Info 2.5//EN\" \"http://www.netbeans.org/dtds/autoupdate-info-2_5.dtd\">");
            xmlBuilder.append("<module codenamebase=\"").append(descriptor.getName().toLowerCase()).append("\" distribution=\"").append(nbmFile.getName()).append("\" downloadsize=\"0\" homepage=\"https://github.com/senbox-org/s2tbx\" needsrestart=\"true\" releasedate=\"").append(new SimpleDateFormat("yyyy/MM/dd").format(new Date())).append("\">\n").append("<manifest AutoUpdate-Essential-Module=\"true\" AutoUpdate-Show-In-Client=\"false\" OpenIDE-Module=\"").append(descriptor.getName()).append("\" OpenIDE-Module-Display-Category=\"SNAP\" OpenIDE-Module-Implementation-Version=\"2.0.0-").append(new SimpleDateFormat("yyyyMMdd").format(new Date())).append("\" OpenIDE-Module-Java-Dependencies=\"Java &gt; 1.8\" OpenIDE-Module-Long-Description=\"&lt;p&gt;").append(descriptor.getDescription()).append("&lt;/p&gt;\" OpenIDE-Module-Module-Dependencies=\"org.esa.snap.snap.sta &gt; 2.0.0, org.esa.snap.snap.sta.ui &gt; 2.0.0, org.esa.snap.snap.rcp &gt; 2.0.0, org.esa.snap.snap.core &gt; 2.0.0\" OpenIDE-Module-Name=\"").append(descriptor.getName()).append("\" OpenIDE-Module-Requires=\"org.openide.modules.ModuleFormat1\" OpenIDE-Module-Short-Description=\"").append(descriptor.getDescription()).append("\" OpenIDE-Module-Specification-Version=\"2.0.0\"/>\n</module>");
            byteBuffer = xmlBuilder.toString().getBytes();
            zipStream.write(byteBuffer, 0, byteBuffer.length);
            zipStream.closeEntry();
            xmlBuilder.setLength(0);
            entry = new ZipEntry("META-INF/MANIFEST.MF");
            zipStream.putNextEntry(entry);
            xmlBuilder.append("Manifest-Version: 1.0\nCreated-By: 1.8.0_31-b13 (Oracle Corporation)\n");
            byteBuffer = xmlBuilder.toString().getBytes();
            zipStream.write(byteBuffer, 0, byteBuffer.length);
            zipStream.closeEntry();
            String jarName = descriptor.getName().replace(".", "-") + ".jar";
            xmlBuilder.setLength(0);
            entry = new ZipEntry("netbeans/config/Modules/" + descriptor.getName().replace(".", "-") + ".xml");
            zipStream.putNextEntry(entry);
            xmlBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"\n\"http://www.netbeans.org/dtds/module-status-1_0.dtd\">\n").append("<module name=\"").append(descriptor.getName()).append("\">\n<param name=\"autoload\">false</param><param name=\"eager\">false</param><param name=\"enabled\">true</param>\n").append("<param name=\"jar\">modules/").append(jarName).append("</param><param name=\"reloadable\">false</param>\n</module>");
            byteBuffer = xmlBuilder.toString().getBytes();
            zipStream.write(byteBuffer, 0, byteBuffer.length);
            zipStream.closeEntry();
            xmlBuilder.setLength(0);
            entry = new ZipEntry("netbeans/modules/ext/");
            zipStream.putNextEntry(entry);
            zipStream.closeEntry();
            entry = new ZipEntry("netbeans/modules/" + jarName);
            zipStream.putNextEntry(entry);
            zipStream.write(ModulePackager.packAdapterJar(descriptor));
            zipStream.closeEntry();
            entry = new ZipEntry("netbeans/update_tracking/");
            zipStream.putNextEntry(entry);
            zipStream.closeEntry();
        }
    }

    public static void unpackAdapterJar(File jarFile, File unpackFolder) throws IOException {
        block24: {
            ToolAdapterIO.unpackAdapterJar((File)jarFile, (File)unpackFolder);
            try (JarFile jar = new JarFile(jarFile);){
                Attributes attributes = jar.getManifest().getMainAttributes();
                if (!attributes.containsKey(ATTR_MODULE_VERSION)) break block24;
                String version = attributes.getValue(ATTR_MODULE_VERSION);
                File versionFile = new File(unpackFolder, "version.txt");
                try (FileOutputStream fos = new FileOutputStream(versionFile);){
                    fos.write(version.getBytes());
                    fos.close();
                }
            }
        }
    }

    public static String getAdapterVersion(File jarFile) throws IOException {
        String version = null;
        JarFile jar = new JarFile(jarFile);
        Attributes attributes = jar.getManifest().getMainAttributes();
        if (attributes.containsKey(ATTR_MODULE_VERSION)) {
            version = attributes.getValue(ATTR_MODULE_VERSION);
        }
        jar.close();
        return version;
    }

    public static String getAdapterAlias(File jarFile) throws IOException {
        String attrValue = null;
        JarFile jar = new JarFile(jarFile);
        Attributes attributes = jar.getManifest().getMainAttributes();
        if (attributes.containsKey(ATTR_MODULE_TYPE) && "STA".equals(attributes.getValue(ATTR_MODULE_TYPE))) {
            if (attributes.containsKey(ATTR_MODULE_ALIAS)) {
                attrValue = attributes.getValue(ATTR_MODULE_ALIAS);
            } else if (attributes.containsKey(ATTR_MODULE_NAME)) {
                attrValue = attributes.getValue(ATTR_MODULE_NAME);
            } else if (attributes.containsKey(ATTR_MODULE)) {
                attrValue = attributes.getValue(ATTR_MODULE);
            }
        }
        jar.close();
        return attrValue;
    }

    private static byte[] packAdapterJar(ToolAdapterOperatorDescriptor descriptor) throws IOException {
        _manifest.getMainAttributes().put(ATTR_DESCRIPTION_NAME, descriptor.getAlias());
        _manifest.getMainAttributes().put(ATTR_MODULE, descriptor.getName());
        _manifest.getMainAttributes().put(ATTR_MODULE_NAME, descriptor.getName());
        _manifest.getMainAttributes().put(ATTR_MODULE_VERSION, descriptor.getVersion());
        _manifest.getMainAttributes().put(ATTR_MODULE_ALIAS, descriptor.getAlias());
        File moduleFolder = new File(modulesPath, descriptor.getAlias());
        ByteArrayOutputStream fOut = new ByteArrayOutputStream();
        try (JarOutputStream jarOut = new JarOutputStream((OutputStream)fOut, _manifest);){
            File[] files = moduleFolder.listFiles();
            if (files != null) {
                for (File child : files) {
                    try {
                        if (child.getName().endsWith("ModuleInstaller.class")) {
                            child.delete();
                            continue;
                        }
                        ModulePackager.addFile(child, jarOut);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                String contents = layerXml.replace("#NAME#", descriptor.getLabel());
                JarEntry entry = new JarEntry(LAYER_XML_PATH);
                jarOut.putNextEntry(entry);
                byte[] buffer = contents.getBytes();
                jarOut.write(buffer, 0, buffer.length);
                jarOut.closeEntry();
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
            jarOut.close();
        }
        return fOut.toByteArray();
    }

    private static void addFile(File source, JarOutputStream target) throws IOException {
        String entryName = source.getPath().replace(modulesPath.getAbsolutePath(), "").replace("\\", "/").substring(1);
        if (!(entryName = entryName.substring(entryName.indexOf("/") + 1)).toLowerCase().endsWith("manifest.mf")) {
            if (source.isDirectory()) {
                File[] files;
                if (!entryName.isEmpty()) {
                    if (!entryName.endsWith("/")) {
                        entryName = entryName + "/";
                    }
                    JarEntry entry = new JarEntry(entryName);
                    entry.setTime(source.lastModified());
                    target.putNextEntry(entry);
                    target.closeEntry();
                }
                if ((files = source.listFiles()) != null) {
                    for (File nestedFile : files) {
                        ModulePackager.addFile(nestedFile, target);
                    }
                }
                return;
            }
            JarEntry entry = new JarEntry(entryName);
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            ModulePackager.writeBytes(source, target);
            target.closeEntry();
        }
    }

    private static void addFile(Class fromClass, JarOutputStream target) throws IOException {
        String classEntry = fromClass.getName().replace('.', '/') + ".class";
        URL classURL = fromClass.getClassLoader().getResource(classEntry);
        if (classURL != null) {
            JarEntry entry = new JarEntry(classEntry);
            target.putNextEntry(entry);
            if (!classURL.toString().contains("!")) {
                String fileName = classURL.getFile();
                ModulePackager.writeBytes(fileName, target);
            } else {
                try (InputStream stream = fromClass.getClassLoader().getResourceAsStream(classEntry);){
                    ModulePackager.writeBytes(stream, target);
                }
            }
            target.closeEntry();
        }
    }

    private static void writeBytes(String fileName, JarOutputStream target) throws IOException {
        ModulePackager.writeBytes(new File(fileName), target);
    }

    private static void writeBytes(File file, JarOutputStream target) throws IOException {
        try (FileInputStream fileStream = new FileInputStream(file);
             BufferedInputStream inputStream = new BufferedInputStream(fileStream);){
            int count;
            byte[] buffer = new byte[1024];
            while ((count = inputStream.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
        }
    }

    private static void writeBytes(InputStream stream, JarOutputStream target) throws IOException {
        int count;
        byte[] buffer = new byte[1024];
        while ((count = stream.read(buffer)) != -1) {
            target.write(buffer, 0, count);
        }
    }

    static {
        Attributes attributes = _manifest.getMainAttributes();
        ATTR_DESCRIPTION_NAME = new Attributes.Name("OpenIDE-Module-Short-Description");
        ATTR_MODULE = new Attributes.Name("OpenIDE-Module");
        ATTR_MODULE_NAME = new Attributes.Name("OpenIDE-Module-Name");
        ATTR_MODULE_TYPE = new Attributes.Name("OpenIDE-Module-Type");
        ATTR_MODULE_VERSION = new Attributes.Name("OpenIDE-Module-Implementation-Version");
        ATTR_MODULE_ALIAS = new Attributes.Name("OpenIDE-Module-Alias");
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.put(new Attributes.Name("OpenIDE-Module-Java-Dependencies"), "Java > 1.8");
        attributes.put(new Attributes.Name("OpenIDE-Module-Module-Dependencies"), "org.esa.snap.snap.sta, org.esa.snap.snap.sta.ui");
        attributes.put(new Attributes.Name("OpenIDE-Module-Display-Category"), "SNAP");
        attributes.put(ATTR_MODULE_TYPE, "STA");
        attributes.put(ATTR_DESCRIPTION_NAME, "External tool adapter");
        modulesPath = ToolAdapterIO.getAdaptersPath().toFile();
    }
}

