/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.util;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwindx.examples.util.DialogAnnotationController;
import gov.nasa.worldwindx.examples.util.PowerOfTwoPaddedImage;
import gov.nasa.worldwindx.examples.util.SlideShowAnnotation;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class SlideShowAnnotationController
extends DialogAnnotationController {
    public static final String BUFFERED_IMAGE_CACHE_SIZE = "gov.nasa.worldwind.avkey.BufferedImageCacheSize";
    public static final String BUFFERED_IMAGE_CACHE_NAME = BufferedImage.class.getName();
    protected static final long SLIDESHOW_UPDATE_DELAY_MILLIS = 2000L;
    protected static final long DEFAULT_BUFFERED_IMAGE_CACHE_SIZE = 30000000L;
    protected static Dimension SMALL_IMAGE_PREFERRED_SIZE = new Dimension(320, 240);
    protected static Dimension LARGE_IMAGE_PREFERRED_SIZE = new Dimension(600, 450);
    protected int index = -1;
    protected String state = "gov.nasa.worldwind.avkey.Stop";
    protected List<Object> imageSources = new ArrayList<Object>();
    protected Thread readThread;
    protected Timer updateTimer;

    public SlideShowAnnotationController(WorldWindow worldWindow, SlideShowAnnotation slideShowAnnotation, Iterable<?> iterable) {
        super(worldWindow, slideShowAnnotation);
        if (iterable != null) {
            for (Object obj : iterable) {
                if (obj == null) continue;
                this.imageSources.add(obj);
            }
        }
        if (!WorldWind.getMemoryCacheSet().containsCache(BUFFERED_IMAGE_CACHE_NAME)) {
            long l = Configuration.getLongValue(BUFFERED_IMAGE_CACHE_SIZE, 30000000L);
            BasicMemoryCache basicMemoryCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
            WorldWind.getMemoryCacheSet().addCache(BUFFERED_IMAGE_CACHE_NAME, basicMemoryCache);
        }
        this.initializeSlideShow();
    }

    public SlideShowAnnotationController(WorldWindow worldWindow, SlideShowAnnotation slideShowAnnotation) {
        this(worldWindow, slideShowAnnotation, null);
    }

    protected void initializeSlideShow() {
        SlideShowAnnotation slideShowAnnotation = (SlideShowAnnotation)this.getAnnotation();
        this.setPreferredImageSize(SMALL_IMAGE_PREFERRED_SIZE);
        if (this.imageSources.size() <= 1) {
            slideShowAnnotation.getPlayButton().getAttributes().setVisible(false);
            slideShowAnnotation.getPreviousButton().getAttributes().setVisible(false);
            slideShowAnnotation.getNextButton().getAttributes().setVisible(false);
            slideShowAnnotation.getBeginButton().getAttributes().setVisible(false);
            slideShowAnnotation.getEndButton().getAttributes().setVisible(false);
        }
        if (!this.imageSources.isEmpty()) {
            this.doGoToImage(0);
        }
    }

    public List<? extends Object> getImageSources() {
        return Collections.unmodifiableList(this.imageSources);
    }

    public void setImageSources(Iterable<? extends Object> iterable) {
        this.imageSources.clear();
        if (iterable != null) {
            for (Object object : iterable) {
                if (object == null) continue;
                this.imageSources.add(object);
            }
        }
    }

    public String getState() {
        return this.state;
    }

    public int getIndex() {
        return this.index;
    }

    public void goToImage(int n) {
        if (this.getAnnotation() == null) {
            return;
        }
        if (this.getState() == "gov.nasa.worldwind.avkey.Play") {
            this.stopSlideShow();
        }
        this.doGoToImage(n);
    }

    public void startSlideShow() {
        if (this.getAnnotation() == null) {
            return;
        }
        if (this.hasNextIndex() && this.getState() == "gov.nasa.worldwind.avkey.Stop") {
            this.state = "gov.nasa.worldwind.avkey.Play";
            SlideShowAnnotation slideShowAnnotation = (SlideShowAnnotation)this.getAnnotation();
            slideShowAnnotation.setPlayButtonState("gov.nasa.worldwind.avkey.Pause");
            this.startSlideShowUpdate();
        }
    }

    public void stopSlideShow() {
        if (this.getAnnotation() == null) {
            return;
        }
        if (this.getState() == "gov.nasa.worldwind.avkey.Play") {
            this.state = "gov.nasa.worldwind.avkey.Stop";
            SlideShowAnnotation slideShowAnnotation = (SlideShowAnnotation)this.getAnnotation();
            slideShowAnnotation.setPlayButtonState("gov.nasa.worldwind.avkey.Play");
            this.stopSlideShowUpdate();
        }
    }

    public void stopRetrievalTasks() {
        this.stopImageRetrieval();
    }

    public Dimension getPreferredImageSize() {
        if (this.getAnnotation() == null) {
            return null;
        }
        SlideShowAnnotation slideShowAnnotation = (SlideShowAnnotation)this.getAnnotation();
        return slideShowAnnotation.getImageAnnotation().getAttributes().getSize();
    }

    public void setPreferredImageSize(Dimension dimension) {
        if (this.getAnnotation() == null) {
            return;
        }
        SlideShowAnnotation slideShowAnnotation = (SlideShowAnnotation)this.getAnnotation();
        slideShowAnnotation.getImageAnnotation().getAttributes().setSize(dimension);
    }

    protected boolean hasPreviousIndex() {
        return true;
    }

    protected boolean hasNextIndex() {
        return true;
    }

    protected int getPreviousIndex() {
        int n = this.imageSources.size() - 1;
        return this.index > 0 ? this.index - 1 : n;
    }

    protected int getNextIndex() {
        int n = this.imageSources.size() - 1;
        return this.index < n ? this.index + 1 : 0;
    }

    protected void doGoToImage(int n) {
        int n2 = this.imageSources.size() - 1;
        if (n < 0 || n > n2) {
            return;
        }
        if (n == this.index) {
            return;
        }
        this.retrieveAndSetImage(this.imageSources.get(n), n);
    }

    protected void doSetImage(PowerOfTwoPaddedImage powerOfTwoPaddedImage, int n) {
        int n2 = this.imageSources.size();
        Object object = this.imageSources.get(n);
        String string = this.createTitle(object);
        String string2 = this.createPositionText(n, n2);
        this.index = n;
        SlideShowAnnotation slideShowAnnotation = (SlideShowAnnotation)this.getAnnotation();
        slideShowAnnotation.getTitleLabel().setText(string);
        slideShowAnnotation.getPositionLabel().setText(string2);
        slideShowAnnotation.getImageAnnotation().setImageSource(powerOfTwoPaddedImage.getPowerOfTwoImage(), powerOfTwoPaddedImage.getOriginalWidth(), powerOfTwoPaddedImage.getOriginalHeight());
        slideShowAnnotation.getBeginButton().setEnabled(this.hasPreviousIndex());
        slideShowAnnotation.getPreviousButton().setEnabled(this.hasPreviousIndex());
        slideShowAnnotation.getNextButton().setEnabled(this.hasNextIndex());
        slideShowAnnotation.getEndButton().setEnabled(this.hasNextIndex());
        this.getWorldWindow().redraw();
    }

    @Override
    public void onActionPerformed(ActionEvent actionEvent) {
        super.onActionPerformed(actionEvent);
        if (actionEvent.getActionCommand() == "gov.nasa.worldwind.avkey.Play") {
            this.playPressed(actionEvent);
        } else if (actionEvent.getActionCommand() == "gov.nasa.worldwind.avkey.Previous") {
            this.previousPressed(actionEvent);
        } else if (actionEvent.getActionCommand() == "gov.nasa.worldwind.avkey.Next") {
            this.nextPressed(actionEvent);
        } else if (actionEvent.getActionCommand() == "gov.nasa.worldwind.avkey.Begin") {
            this.beginPressed(actionEvent);
        } else if (actionEvent.getActionCommand() == "gov.nasa.worldwind.avkey.End") {
            this.endPressed(actionEvent);
        } else if (actionEvent.getActionCommand() == "gov.nasa.worldwind.avkey.Resize") {
            this.resizePressed(actionEvent);
        }
    }

    protected void playPressed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        if (this.getAnnotation() == null) {
            return;
        }
        this.onPlayPressed(actionEvent);
    }

    protected void previousPressed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        if (this.getAnnotation() == null) {
            return;
        }
        this.onPreviousPressed(actionEvent);
    }

    protected void nextPressed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        if (this.getAnnotation() == null) {
            return;
        }
        this.onNextPressed(actionEvent);
    }

    protected void beginPressed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        if (this.getAnnotation() == null) {
            return;
        }
        this.onBeginPressed(actionEvent);
    }

    protected void endPressed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        if (this.getAnnotation() == null) {
            return;
        }
        this.onEndPressed(actionEvent);
    }

    protected void resizePressed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        if (this.getAnnotation() == null) {
            return;
        }
        this.onResizePressed(actionEvent);
    }

    protected void onPlayPressed(ActionEvent actionEvent) {
        String string = this.getState();
        if (string == null) {
            return;
        }
        if (string == "gov.nasa.worldwind.avkey.Play") {
            this.stopSlideShow();
        } else if (string == "gov.nasa.worldwind.avkey.Stop") {
            this.startSlideShow();
        }
    }

    protected void onPreviousPressed(ActionEvent actionEvent) {
        if (!this.hasPreviousIndex()) {
            return;
        }
        int n = this.getPreviousIndex();
        this.goToImage(n);
    }

    protected void onNextPressed(ActionEvent actionEvent) {
        if (!this.hasNextIndex()) {
            return;
        }
        int n = this.getNextIndex();
        this.goToImage(n);
    }

    protected void onBeginPressed(ActionEvent actionEvent) {
        this.goToImage(0);
    }

    protected void onEndPressed(ActionEvent actionEvent) {
        int n = this.imageSources.size() - 1;
        if (n < 0) {
            return;
        }
        this.goToImage(n);
    }

    protected void onResizePressed(ActionEvent actionEvent) {
        if (this.getAnnotation() == null) {
            return;
        }
        Dimension dimension = this.getPreferredImageSize();
        if (dimension.equals(SMALL_IMAGE_PREFERRED_SIZE)) {
            this.setPreferredImageSize(LARGE_IMAGE_PREFERRED_SIZE);
            SlideShowAnnotation slideShowAnnotation = (SlideShowAnnotation)this.getAnnotation();
            slideShowAnnotation.setSizeButtonState("SlideShowAnnotation.Decrease");
        } else {
            this.setPreferredImageSize(SMALL_IMAGE_PREFERRED_SIZE);
            SlideShowAnnotation slideShowAnnotation = (SlideShowAnnotation)this.getAnnotation();
            slideShowAnnotation.setSizeButtonState("SlideShowAnnotation.Increase");
        }
    }

    protected void retrieveAndSetImage(Object object, int n) {
        PowerOfTwoPaddedImage powerOfTwoPaddedImage = this.getImage(object);
        if (powerOfTwoPaddedImage != null) {
            this.doSetImage(powerOfTwoPaddedImage, n);
            return;
        }
        this.startImageRetrieval(object, n);
    }

    protected void doRetrieveAndSetImage(Object object, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SlideShowAnnotationController.this.updateTimer != null) {
                    SlideShowAnnotationController.this.updateTimer.stop();
                }
                SlideShowAnnotationController.this.getAnnotation().setBusy(true);
                SlideShowAnnotationController.this.getWorldWindow().redraw();
            }
        });
        final PowerOfTwoPaddedImage powerOfTwoPaddedImage = this.readImage(object);
        this.putImage(object, powerOfTwoPaddedImage);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SlideShowAnnotationController.this.doSetImage(powerOfTwoPaddedImage, n);
                SlideShowAnnotationController.this.getAnnotation().setBusy(false);
                SlideShowAnnotationController.this.getWorldWindow().redraw();
                if (SlideShowAnnotationController.this.updateTimer != null) {
                    SlideShowAnnotationController.this.updateTimer.start();
                }
            }
        });
    }

    protected PowerOfTwoPaddedImage readImage(Object object) {
        try {
            if (object instanceof BufferedImage) {
                return PowerOfTwoPaddedImage.fromBufferedImage((BufferedImage)object);
            }
            if (object instanceof String) {
                return PowerOfTwoPaddedImage.fromPath((String)object);
            }
            if (object instanceof URL) {
                return PowerOfTwoPaddedImage.fromBufferedImage(ImageIO.read((URL)object));
            }
            String string = Logging.getMessage("generic.UnrecognizedSourceType", object);
            Logging.logger().severe(string);
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToReadFrom", object);
            Logging.logger().severe(string);
        }
        return null;
    }

    protected void startImageRetrieval(final Object object, final int n) {
        this.readThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SlideShowAnnotationController.this.doRetrieveAndSetImage(object, n);
            }
        });
        this.readThread.start();
    }

    protected void stopImageRetrieval() {
        if (this.readThread != null && this.readThread.isAlive()) {
            this.readThread.interrupt();
        }
        this.readThread = null;
    }

    protected PowerOfTwoPaddedImage getImage(Object object) {
        return (PowerOfTwoPaddedImage)WorldWind.getMemoryCache(BUFFERED_IMAGE_CACHE_NAME).getObject(object);
    }

    protected boolean putImage(Object object, PowerOfTwoPaddedImage powerOfTwoPaddedImage) {
        MemoryCache memoryCache;
        boolean bl;
        long l = ImageUtil.computeSizeInBytes(powerOfTwoPaddedImage.getPowerOfTwoImage());
        boolean bl2 = bl = l < (memoryCache = WorldWind.getMemoryCache(BUFFERED_IMAGE_CACHE_NAME)).getCapacity();
        if (bl) {
            memoryCache.add(object, powerOfTwoPaddedImage, l);
        }
        return bl;
    }

    protected boolean nextSlideShowImage() {
        if (this.getAnnotation() == null) {
            return false;
        }
        if (this.hasNextIndex()) {
            int n = this.getNextIndex();
            this.doGoToImage(n);
        }
        return this.hasNextIndex();
    }

    protected void onSlideShowUpdate() {
        if (!this.nextSlideShowImage()) {
            this.stopSlideShow();
        }
    }

    protected void startSlideShowUpdate() {
        this.updateTimer = new Timer(2000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SlideShowAnnotationController.this.onSlideShowUpdate();
            }
        });
        this.updateTimer.setCoalesce(true);
        this.updateTimer.start();
    }

    protected void stopSlideShowUpdate() {
        if (this.updateTimer != null) {
            this.updateTimer.stop();
        }
        this.updateTimer = null;
    }

    protected String createTitle(Object object) {
        String string = this.getImageName(object);
        return string != null ? string : "";
    }

    protected String createPositionText(int n, int n2) {
        if (n2 <= 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n + 1).append(" of ").append(n2);
        return stringBuilder.toString();
    }

    protected String getImageName(Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString();
        int n = (string = WWIO.stripTrailingSeparator(string)).lastIndexOf("/");
        if (n == -1) {
            n = string.lastIndexOf("\\");
        }
        if (n != -1 && n < string.length() - 1) {
            string = string.substring(n + 1, string.length());
        }
        return string;
    }
}

