/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.lineofsight;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.Polygon;
import gov.nasa.worldwind.terrain.HighResolutionTerrain;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;

public class PolygonIntersection
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLatitude", 40.5);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLongitude", -120.4);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", 125000.0);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialHeading", 27);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialPitch", 30);
        ApplicationTemplate.start("World Wind Polygon Intersection", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected HighResolutionTerrain terrain;
        protected Polygon polygon;
        protected RenderableLayer layer;

        public AppFrame() {
            super(true, true, false);
            ArrayList<Position> arrayList = new ArrayList<Position>();
            arrayList.add(Position.fromDegrees(40.4, -120.6, 10000.0));
            arrayList.add(Position.fromDegrees(40.4, -120.4, 10000.0));
            arrayList.add(Position.fromDegrees(40.6, -120.4, 10000.0));
            arrayList.add(Position.fromDegrees(40.6, -120.6, 10000.0));
            this.polygon = new Polygon(arrayList);
            this.polygon.setAltitudeMode(2);
            this.polygon.setReferencePosition(Position.fromDegrees(40.4, -120.6, 0.0));
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.LIGHT_GRAY);
            this.polygon.setAttributes(basicShapeAttributes);
            this.layer = new RenderableLayer();
            this.layer.addRenderable(this.polygon);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), this.layer);
            this.terrain = new HighResolutionTerrain(this.getWwd().getModel().getGlobe(), 20.0);
            Timer timer = new Timer(3000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Position position = Position.fromDegrees(40.5, -120.5, 0.0);
                    Position position2 = new Position(position, 20000.0);
                    AppFrame.this.drawLine(position, position2);
                    AppFrame.this.performIntersection();
                }
            });
            timer.start();
        }

        protected void performIntersection() {
            try {
                Position position = Position.fromDegrees(40.5, -120.5, 0.0);
                Vec4 vec4 = this.terrain.getSurfacePoint(position);
                Position position2 = new Position(position, 20000.0);
                Vec4 vec42 = this.terrain.getSurfacePoint(position2);
                Line line = new Line(vec42, vec4.subtract3(vec42));
                List<Intersection> list = this.polygon.intersect(line, this.terrain);
                if (list != null) {
                    for (Intersection intersection : list) {
                        this.drawIntersection(intersection);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }

        protected void drawLine(Position position, Position position2) {
            Path path = new Path(position, position2);
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            path.setAltitudeMode(2);
            basicShapeAttributes.setOutlineMaterial(Material.GREEN);
            basicShapeAttributes.setOutlineOpacity(0.6);
            basicShapeAttributes.setDrawOutline(true);
            basicShapeAttributes.setDrawInterior(false);
            path.setAttributes(basicShapeAttributes);
            this.layer.addRenderable(path);
            this.layerPanel.update(this.getWwd());
            this.getWwd().redraw();
        }

        protected void drawIntersection(Intersection intersection) {
            PointPlacemark pointPlacemark = new PointPlacemark(intersection.getIntersectionPosition());
            pointPlacemark.setAltitudeMode(2);
            PointPlacemarkAttributes pointPlacemarkAttributes = new PointPlacemarkAttributes();
            pointPlacemarkAttributes.setLineMaterial(Material.CYAN);
            pointPlacemarkAttributes.setScale(8.0);
            pointPlacemarkAttributes.setUsePointAsDefaultImage(true);
            pointPlacemark.setAttributes(pointPlacemarkAttributes);
            this.layer.addRenderable(pointPlacemark);
            this.getWwd().redraw();
        }
    }
}

