/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwind.util.BasicDragger;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import javax.swing.Timer;

public class VideoOnTerrain
extends ApplicationTemplate {
    protected static final int IMAGE_SIZE = 512;
    protected static final double IMAGE_OPACITY = 0.5;
    protected static final double IMAGE_SELECTED_OPACITY = 0.8;
    protected static final List<LatLon> CORNERS = Arrays.asList(LatLon.fromDegrees(37.8313, -105.0653), LatLon.fromDegrees(37.8313, -105.0396), LatLon.fromDegrees(37.8539, -105.04), LatLon.fromDegrees(37.8539, -105.0653));

    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLatitude", 37.8432);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLongitude", -105.0527);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", 7000);
        ApplicationTemplate.start("World Wind Video on Terrain", AppFrame.class);
    }

    protected static class SurfaceImageDragger
    implements SelectListener {
        protected WorldWindow wwd;
        protected SurfaceImage lastHighlit;
        protected BasicDragger dragger;

        public SurfaceImageDragger(WorldWindow worldWindow) {
            this.wwd = worldWindow;
            this.dragger = new BasicDragger(worldWindow);
        }

        @Override
        public void selected(SelectEvent selectEvent) {
            PickedObjectList pickedObjectList;
            if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") && !this.dragger.isDragging()) {
                this.highlight(selectEvent.getTopObject());
                this.wwd.redraw();
            }
            if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd")) {
                this.dragger.selected(selectEvent);
                if (this.dragger.isDragging()) {
                    this.wwd.redraw();
                }
            }
            if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") && (pickedObjectList = this.wwd.getObjectsAtCurrentPosition()) != null) {
                this.highlight(pickedObjectList.getTopObject());
                this.wwd.redraw();
            }
        }

        protected void highlight(Object object) {
            if (this.lastHighlit == object) {
                return;
            }
            if (this.lastHighlit != null) {
                this.lastHighlit.setOpacity(0.5);
                this.lastHighlit = null;
            }
            if (object instanceof SurfaceImage) {
                this.lastHighlit = (SurfaceImage)object;
                this.lastHighlit.setOpacity(0.8);
            }
        }
    }

    protected static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected long counter;
        protected long start = System.currentTimeMillis();

        public AppFrame() {
            super(true, true, true);
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setName("Video on terrain");
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), renderableLayer);
            this.layerPanel.update(this.getWwd());
            this.getWwd().addSelectListener(new SurfaceImageDragger(this.getWwd()));
            final SurfaceImage surfaceImage = new SurfaceImage((Object)this.makeImage(), CORNERS);
            surfaceImage.setOpacity(0.5);
            renderableLayer.addRenderable(surfaceImage);
            Timer timer = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    List<LatLon> list = surfaceImage.getCorners();
                    surfaceImage.setImageSource((Object)AppFrame.this.makeImage(), list);
                    AppFrame.this.getWwd().redraw();
                }
            });
            timer.start();
        }

        protected BufferedImage makeImage() {
            BufferedImage bufferedImage = new BufferedImage(512, 512, 6);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setPaint(Color.WHITE);
            graphics2D.fill3DRect(0, 0, 512, 512, false);
            graphics2D.setPaint(Color.RED);
            graphics2D.setFont(Font.decode("ARIAL-BOLD-50"));
            graphics2D.drawString(Long.toString(++this.counter) + " frames", 10, 128);
            graphics2D.drawString(Long.toString((System.currentTimeMillis() - this.start) / 1000L) + " sec", 10, 256);
            graphics2D.drawString("Heap:" + Long.toString(Runtime.getRuntime().totalMemory()), 10, 384);
            graphics2D.dispose();
            return bufferedImage;
        }
    }
}

