/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.globes.EarthFlat;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.SkyColorLayer;
import gov.nasa.worldwind.layers.SkyGradientLayer;
import gov.nasa.worldwind.view.orbit.FlatOrbitView;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.FlatWorldPanel;
import java.awt.Component;

public class FlatWorld
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.GlobeClassName", EarthFlat.class.getName());
        Configuration.setValue("gov.nasa.worldwind.avkey.ViewClassName", FlatOrbitView.class.getName());
        ApplicationTemplate.start("World Wind Flat World", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            LayerList layerList = this.getWwd().getModel().getLayers();
            for (int i = 0; i < layerList.size(); ++i) {
                if (!(layerList.get(i) instanceof SkyGradientLayer)) continue;
                layerList.set(i, new SkyColorLayer());
            }
            this.getLayerPanel().update(this.getWwd());
            this.getLayerPanel().add((Component)new FlatWorldPanel(this.getWwd()), "South");
        }
    }
}

