/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Cone;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Cones
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Cones", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            this.getLayerPanel().add((Component)this.makeDetailHintControlPanel(), "South");
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.YELLOW);
            basicShapeAttributes.setInteriorOpacity(0.7);
            basicShapeAttributes.setEnableLighting(true);
            basicShapeAttributes.setOutlineMaterial(Material.RED);
            basicShapeAttributes.setOutlineWidth(2.0);
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setDrawOutline(false);
            BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes();
            basicShapeAttributes2.setInteriorMaterial(Material.PINK);
            basicShapeAttributes2.setInteriorOpacity(1.0);
            basicShapeAttributes2.setEnableLighting(true);
            basicShapeAttributes2.setOutlineMaterial(Material.WHITE);
            basicShapeAttributes2.setOutlineWidth(2.0);
            basicShapeAttributes2.setDrawOutline(false);
            Cone cone = new Cone(Position.fromDegrees(40.0, -120.0, 80000.0), 100000.0, 50000.0);
            cone.setAltitudeMode(0);
            cone.setAttributes(basicShapeAttributes);
            cone.setVisible(true);
            cone.setValue("gov.nasa.worldwind.avkey.DisplayName", "Cone with equal axes, ABSOLUTE altitude mode");
            renderableLayer.addRenderable(cone);
            Cone cone2 = new Cone(Position.fromDegrees(37.5, -115.0, 50000.0), 50000.0, 50000.0, 50000.0);
            cone2.setAltitudeMode(2);
            cone2.setAttributes(basicShapeAttributes);
            cone2.setVisible(true);
            cone2.setValue("gov.nasa.worldwind.avkey.DisplayName", "Cone with equal axes, RELATIVE_TO_GROUND altitude mode");
            renderableLayer.addRenderable(cone2);
            Cone cone3 = new Cone(Position.fromDegrees(35.0, -110.0, 50000.0), 50000.0, 50000.0, 50000.0);
            cone3.setAltitudeMode(1);
            cone3.setAttributes(basicShapeAttributes);
            cone3.setVisible(true);
            cone3.setValue("gov.nasa.worldwind.avkey.DisplayName", "Cone with equal axes, CLAMP_TO_GROUND altitude mode");
            renderableLayer.addRenderable(cone3);
            Cone cone4 = new Cone(Position.fromDegrees(0.0, -90.0, 600000.0), 1200000.0, 600000.0);
            cone4.setAltitudeMode(2);
            cone4.setImageSources("gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            cone4.setAttributes(basicShapeAttributes);
            cone4.setVisible(true);
            cone4.setValue("gov.nasa.worldwind.avkey.DisplayName", "Cone with a texture");
            renderableLayer.addRenderable(cone4);
            Cone cone5 = new Cone(Position.ZERO, 1000000.0, 500000.0, 100000.0);
            cone5.setAltitudeMode(0);
            cone5.setAttributes(basicShapeAttributes);
            cone5.setVisible(true);
            cone5.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled Cone with default orientation");
            renderableLayer.addRenderable(cone5);
            Cone cone6 = new Cone(Position.fromDegrees(0.0, 30.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            cone6.setAltitudeMode(2);
            cone6.setAttributes(basicShapeAttributes2);
            cone6.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled Cone with a pre-set orientation");
            cone6.setVisible(true);
            renderableLayer.addRenderable(cone6);
            Cone cone7 = new Cone(Position.fromDegrees(30.0, 30.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            cone7.setAltitudeMode(2);
            cone7.setImageSources("gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            cone7.setAttributes(basicShapeAttributes2);
            cone7.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled Cone with a pre-set orientation");
            cone7.setVisible(true);
            renderableLayer.addRenderable(cone7);
            Cone cone8 = new Cone(Position.fromDegrees(60.0, 30.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            cone8.setAltitudeMode(2);
            cone8.setAttributes(basicShapeAttributes2);
            cone8.setVisible(true);
            cone8.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled Cone with a pre-set orientation");
            renderableLayer.addRenderable(cone8);
            Cone cone9 = new Cone(Position.fromDegrees(-45.0, -180.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            cone9.setAltitudeMode(2);
            cone9.setAttributes(basicShapeAttributes2);
            cone9.setVisible(true);
            cone9.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled, oriented Cone in the 3rd 'quadrant' (-X, -Y, -Z)");
            renderableLayer.addRenderable(cone9);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }

        protected JPanel makeDetailHintControlPanel() {
            JPanel jPanel = new JPanel(new BorderLayout(0, 10));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Detail Hint")));
            JPanel jPanel2 = new JPanel(new BorderLayout(0, 5));
            int n = -10;
            int n2 = 10;
            int n3 = 0;
            JSlider jSlider = new JSlider(n, n2, n3);
            jSlider.setMajorTickSpacing(10);
            jSlider.setMinorTickSpacing(1);
            jSlider.setPaintTicks(true);
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            hashtable.put(-10, new JLabel("-1.0"));
            hashtable.put(0, new JLabel("0.0"));
            hashtable.put(10, new JLabel("1.0"));
            jSlider.setLabelTable(hashtable);
            jSlider.setPaintLabels(true);
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    double d = (double)((JSlider)changeEvent.getSource()).getValue() / 10.0;
                    AppFrame.this.setConeDetailHint(d);
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel2.add((Component)jSlider, "South");
            JPanel jPanel3 = new JPanel(new GridLayout(2, 0));
            jPanel3.add(jPanel2);
            jPanel.add((Component)jPanel3, "South");
            return jPanel;
        }

        protected RenderableLayer getLayer() {
            for (Layer layer : this.getWwd().getModel().getLayers()) {
                if (!layer.getName().contains("Renderable")) continue;
                return (RenderableLayer)layer;
            }
            return null;
        }

        protected void setConeDetailHint(double d) {
            for (Renderable renderable : this.getLayer().getRenderables()) {
                Cone cone = (Cone)renderable;
                cone.setDetailHint(d);
            }
            System.out.println("Cone detail hint set to " + d);
        }
    }
}

