/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager;

import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.LayerNode;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.LayerTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class LayerTree
extends JTree {
    public LayerTree(LayerTreeModel layerTreeModel) {
        super(layerTreeModel);
        this.initialize();
    }

    protected void initialize() {
        this.setOpaque(false);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer(new LayerNodeTreeCellRenderer());
        this.setEditable(true);
        this.setCellEditor(new LayerNodeTreeCellEditor(this));
        ToolTipManager.sharedInstance().registerComponent(this);
        this.expandRow(0);
    }

    public boolean isShowInternalNodes() {
        return ((LayerTreeModel)this.getModel()).isIncludeInternalLayers();
    }

    public void setShowInternalNodes(boolean bl) {
        ((LayerTreeModel)this.getModel()).setIncludeInternalLayers(bl);
    }

    public void clearTree() {
        LayerTreeModel layerTreeModel = (LayerTreeModel)this.getModel();
        if (layerTreeModel == null || layerTreeModel.getRoot() == null) {
            return;
        }
        this.setModel(new LayerTreeModel());
    }

    private static class LayerNodeTreeCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private LayerTree tree;
        private LayerNodeTreeCellRenderer renderer;
        private LayerNode currentValue;

        public LayerNodeTreeCellEditor(JTree jTree) {
            this.tree = (LayerTree)jTree;
            this.renderer = new LayerNodeTreeCellRenderer();
            this.renderer.getLeafRenderer().checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    LayerNodeTreeCellEditor.this.currentValue.setSelected(itemEvent.getStateChange() == 1);
                    if (LayerNodeTreeCellEditor.this.stopCellEditing()) {
                        LayerNodeTreeCellEditor.this.fireEditingStopped();
                    }
                }
            });
            this.renderer.getGroupRenderer().checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    boolean bl = itemEvent.getStateChange() == 1;
                    LayerNodeTreeCellEditor.this.currentValue.setSelected(bl);
                    if (LayerNodeTreeCellEditor.this.stopCellEditing()) {
                        LayerNodeTreeCellEditor.this.fireEditingStopped();
                    }
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentValue;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (!(eventObject instanceof MouseEvent)) {
                return false;
            }
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return false;
            }
            LayerNode layerNode = (LayerNode)treePath.getLastPathComponent();
            return layerNode != null && layerNode.isEnableSelectionBox();
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            this.currentValue = (LayerNode)object;
            return this.renderer.getTreeCellRendererComponent(jTree, object, true, bl2, bl3, n, true);
        }
    }

    protected static class LayerNodeTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private CellPanel leafRenderer = new CellPanel();
        private CellPanel groupRenderer = new CellPanel();

        private LayerNodeTreeCellRenderer() {
            this.groupRenderer.setOpaque(false);
        }

        protected CellPanel getLeafRenderer() {
            return this.leafRenderer;
        }

        protected CellPanel getGroupRenderer() {
            return this.groupRenderer;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            LayerNode layerNode = (LayerNode)object;
            if (!bl3) {
                if (!layerNode.isEnableSelectionBox()) {
                    this.groupRenderer.layerTitle.setText(layerNode.toString());
                    this.groupRenderer.setToolTipText(layerNode.getToolTipText());
                    this.groupRenderer.checkBox.setEnabled(false);
                    this.groupRenderer.checkBox.setSelected(true);
                    return this.groupRenderer;
                }
                this.groupRenderer.layerTitle.setText(layerNode.toString());
                this.groupRenderer.checkBox.setEnabled(true);
                this.groupRenderer.checkBox.setSelected(layerNode.isSelected());
                this.groupRenderer.setToolTipText(layerNode.getToolTipText());
                return this.groupRenderer;
            }
            this.leafRenderer.layerTitle.setText(layerNode.toString());
            this.leafRenderer.checkBox.setSelected(layerNode.isSelected());
            this.leafRenderer.setToolTipText(layerNode.getToolTipText());
            if (layerNode.getLayer() != null) {
                this.leafRenderer.layerTitle.setEnabled(true);
                this.leafRenderer.checkBox.setEnabled(true);
            }
            return this.leafRenderer;
        }
    }

    protected static class CellPanel
    extends JPanel {
        private static final ImageIcon EARTH_ICON = new ImageIcon(LayerNodeTreeCellRenderer.class.getResource("/images/16x16-icon-earth.png"));
        protected JCheckBox checkBox;
        protected JLabel layerTitle = new JLabel(EARTH_ICON);

        public CellPanel() {
            super(new BorderLayout(5, 5));
            this.setOpaque(false);
            Font font = UIManager.getFont("Tree.font");
            if (font != null) {
                this.setFont(font);
            }
            this.setOpaque(false);
            JPanel jPanel = new JPanel(new GridLayout(1, 0, 0, 0));
            jPanel.setOpaque(false);
            this.checkBox = new JCheckBox();
            this.checkBox.setOpaque(false);
            this.checkBox.setHorizontalTextPosition(0);
            this.checkBox.setIconTextGap(0);
            Boolean bl = (Boolean)UIManager.get("Tree.drawsFocusBorderAroundIcon");
            this.checkBox.setFocusPainted(bl != null && bl != false);
            jPanel.add(this.checkBox);
            JLabel jLabel = new JLabel(EARTH_ICON);
            jLabel.setOpaque(false);
            jPanel.add(jLabel);
            this.layerTitle = new JLabel();
            this.layerTitle.setOpaque(false);
            this.layerTitle.setAlignmentX(2.0f);
            this.add((Component)jPanel, "West");
            this.add((Component)this.layerTitle, "Center");
        }
    }
}

