/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.ImageLibrary;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.ToolBar;
import gov.nasa.worldwindx.applications.worldwindow.features.Feature;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class AbstractFeature
extends AbstractAction
implements Feature {
    protected String featureID;
    protected Controller controller;

    protected AbstractFeature(String string, String string2, Registry registry) {
        super(string);
        this.putValue("gov.nasa.worldwindx.applications.worldwindow.ActionCommand", string);
        if (string2 != null && string2.length() > 0 && registry != null) {
            this.featureID = string2;
            registry.registerObject(string2, this);
        }
    }

    protected AbstractFeature(String string, String string2, String string3, Registry registry) {
        this(string, string2, registry);
        if (string3 != null && string3.length() > 0) {
            ImageIcon imageIcon = ImageLibrary.getIcon(string3);
            if (imageIcon != null) {
                this.putValue("SwingLargeIconKey", imageIcon);
            } else {
                this.putValue("SwingLargeIconKey", ImageLibrary.getWarningIcon(64));
            }
        }
    }

    @Override
    public void initialize(Controller controller) {
        this.controller = controller;
        this.setMenuAccellerator(this.controller);
    }

    @Override
    public boolean isInitialized() {
        return this.controller != null;
    }

    protected Object register(String string, Registry registry) {
        return registry.registerObject(string, this);
    }

    public Controller getController() {
        return this.controller;
    }

    @Override
    public String getFeatureID() {
        return this.featureID;
    }

    public String getStringValue(String string) {
        return (String)this.getValue(string);
    }

    @Override
    public String getName() {
        return (String)this.getValue("Name");
    }

    @Override
    public boolean isOn() {
        return this.isEnabled();
    }

    @Override
    public boolean isTwoState() {
        return false;
    }

    @Override
    public void turnOn(boolean bl) {
    }

    protected void addToToolBar() {
        ToolBar toolBar = this.controller.getToolBar();
        if (toolBar != null) {
            toolBar.addFeature(this);
        }
    }

    protected void setMenuAccellerator(Controller controller) {
        KeyStroke keyStroke;
        if (controller == null) {
            return;
        }
        Object object = controller.getRegisteredObject(this.getClass().getName() + ".Accelerator");
        if (object == null) {
            return;
        }
        if (object instanceof String && (keyStroke = KeyStroke.getKeyStroke((String)object)) != null) {
            this.putValue("AcceleratorKey", keyStroke);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.doActionPerformed(actionEvent);
        }
        catch (Exception exception) {
            Util.getLogger().log(Level.SEVERE, String.format("Error executing action %s.", this.getValue("Name")), exception);
        }
    }

    protected void doActionPerformed(ActionEvent actionEvent) {
        this.turnOn(!this.isOn());
        this.controller.redraw();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.doPropertyChange(propertyChangeEvent);
        }
        catch (Exception exception) {
            Util.getLogger().log(Level.SEVERE, String.format("Error handling property change %s.", this.getValue("Name")), exception);
        }
    }

    public void doPropertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

