/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.core;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.layers.AnnotationLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.ToolTipAnnotation;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeature;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;

public class ToolTipController
extends AbstractFeature
implements SelectListener {
    protected Object lastRolloverObject;
    protected Object lastHoverObject;
    protected AnnotationLayer layer;
    protected ToolTipAnnotation annotation;

    public ToolTipController(Registry registry) {
        super("ToolTip Controller", "gov.nasa.worldwindx.applications.worldwindow.feature.ToolTipController", registry);
    }

    @Override
    public void initialize(Controller controller) {
        super.initialize(controller);
        this.controller.getWWd().addSelectListener(this);
    }

    protected String getHoverText(SelectEvent selectEvent) {
        return selectEvent.getTopObject() != null && selectEvent.getTopObject() instanceof AVList ? ((AVList)selectEvent.getTopObject()).getStringValue("gov.nasa.worldwind.avkey.HoverText") : null;
    }

    protected String getRolloverText(SelectEvent selectEvent) {
        return selectEvent.getTopObject() != null && selectEvent.getTopObject() instanceof AVList ? ((AVList)selectEvent.getTopObject()).getStringValue("gov.nasa.worldwind.avkey.RolloverText") : null;
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        try {
            if (selectEvent.isRollover()) {
                this.handleRollover(selectEvent);
            } else if (selectEvent.isHover()) {
                this.handleHover(selectEvent);
            }
        }
        catch (Exception exception) {
            Util.getLogger().warning(exception.getMessage() != null ? exception.getMessage() : exception.toString());
        }
    }

    protected void handleRollover(SelectEvent selectEvent) {
        if (this.lastRolloverObject != null) {
            if (this.lastRolloverObject == selectEvent.getTopObject() && !WWUtil.isEmpty(this.getRolloverText(selectEvent))) {
                return;
            }
            this.hideToolTip();
            this.lastRolloverObject = null;
            this.controller.redraw();
        }
        if (this.getRolloverText(selectEvent) != null) {
            this.lastRolloverObject = selectEvent.getTopObject();
            this.showToolTip(selectEvent, this.getRolloverText(selectEvent));
            this.controller.redraw();
        }
    }

    protected void handleHover(SelectEvent selectEvent) {
        if (this.lastHoverObject != null) {
            if (this.lastHoverObject == selectEvent.getTopObject()) {
                return;
            }
            this.hideToolTip();
            this.lastHoverObject = null;
            this.controller.redraw();
        }
        if (this.getHoverText(selectEvent) != null) {
            this.lastHoverObject = selectEvent.getTopObject();
            this.showToolTip(selectEvent, this.getHoverText(selectEvent));
            this.controller.redraw();
        }
    }

    protected void showToolTip(SelectEvent selectEvent, String string) {
        if (this.annotation != null) {
            this.annotation.setText(string);
            this.annotation.setScreenPoint(selectEvent.getPickPoint());
        } else {
            this.annotation = new ToolTipAnnotation(string);
        }
        if (this.layer == null) {
            this.layer = new AnnotationLayer();
            this.layer.setPickEnabled(false);
        }
        this.layer.removeAllAnnotations();
        this.layer.addAnnotation(this.annotation);
        this.addLayer(this.layer);
    }

    protected void hideToolTip() {
        if (this.layer != null) {
            this.layer.removeAllAnnotations();
            this.removeLayer(this.layer);
            this.layer.dispose();
            this.layer = null;
        }
        if (this.annotation != null) {
            this.annotation.dispose();
            this.annotation = null;
        }
    }

    protected void addLayer(Layer layer) {
        if (!this.controller.getActiveLayers().contains(layer)) {
            this.controller.addInternalLayer(layer);
        }
    }

    protected void removeLayer(Layer layer) {
        this.controller.getActiveLayers().remove(layer);
    }
}

