/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.eurogeoss;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.ViewControlsLayer;
import gov.nasa.worldwind.layers.ViewControlsSelectListener;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.applications.eurogeoss.CatalogPanel;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.ClickAndGoSelectListener;
import gov.nasa.worldwindx.examples.WMSLayersPanel;
import gov.nasa.worldwindx.examples.layermanager.LayerAndElevationManagerPanel;
import gov.nasa.worldwindx.examples.util.HighlightController;
import gov.nasa.worldwindx.examples.util.ToolTipController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class EuroGeossApp {
    protected static final String EUROGEOSS_SERVICE_TITLE = "EuroGEOSS Catalog";
    protected static final String EUROGEOSS_SERVICE_URL = "http://23.21.170.207/geodab-dswg/services/cswisogeo";
    protected static final String NEO_SERVICE_TITLE = "NASA Earth Observations (NEO) WMS";
    protected static final String NEO_SERVICE_URL = "http://neowms.sci.gsfc.nasa.gov/wms/wms";

    public static AppFrame start(String string, Class clazz) {
        if (Configuration.isMacOS() && string != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", string);
        }
        try {
            final AppFrame appFrame = (AppFrame)clazz.newInstance();
            appFrame.setTitle(string);
            appFrame.setDefaultCloseOperation(3);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    appFrame.setVisible(true);
                }
            });
            return appFrame;
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, "Exception at application start", exception);
            return null;
        }
    }

    public static void main(String[] stringArray) {
        EuroGeossApp.start("World Wind EuroGEOSS Client", AppFrame.class);
    }

    static {
        System.setProperty("java.net.useSystemProxies", "true");
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "World Wind Application");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        } else if (Configuration.isWindowsOS()) {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
    }

    public static class AppFrame
    extends JFrame {
        protected AppPanel wwjPanel;
        protected JTabbedPane tabbedPane;
        protected CatalogPanel catalogPanel;
        protected LayerAndElevationManagerPanel layerManagerPanel;

        public AppFrame() {
            this.initialize();
            WWUtil.alignComponent(null, this, "gov.nasa.worldwind.avkey.Center");
        }

        protected void initialize() {
            this.wwjPanel = new AppPanel();
            this.tabbedPane = new JTabbedPane();
            this.catalogPanel = new CatalogPanel(EuroGeossApp.EUROGEOSS_SERVICE_URL, this.getWwd());
            this.layerManagerPanel = new LayerAndElevationManagerPanel(this.getWwd());
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.tabbedPane.add(EuroGeossApp.EUROGEOSS_SERVICE_TITLE, this.catalogPanel);
            this.addWMSLayersTab(EuroGeossApp.NEO_SERVICE_TITLE, EuroGeossApp.NEO_SERVICE_URL);
            this.tabbedPane.add("Layers", this.layerManagerPanel);
            this.getContentPane().setLayout(new BorderLayout(0, 0));
            this.getContentPane().add((Component)this.tabbedPane, "West");
            this.getContentPane().add((Component)this.wwjPanel, "Center");
            ViewControlsLayer viewControlsLayer = new ViewControlsLayer();
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), viewControlsLayer);
            this.getWwd().addSelectListener(new ViewControlsSelectListener(this.getWwd(), viewControlsLayer));
            for (Layer layer : this.getWwd().getModel().getLayers()) {
                if (!(layer instanceof SelectListener)) continue;
                this.getWwd().addSelectListener((SelectListener)((Object)layer));
            }
            this.pack();
            WWUtil.alignComponent(null, this, "gov.nasa.worldwind.avkey.Center");
            this.setResizable(true);
        }

        protected void addWMSLayersTab(String string, String string2) {
            try {
                WMSLayersPanel wMSLayersPanel = new WMSLayersPanel(this.getWwd(), string2, new Dimension(500, 0));
                this.tabbedPane.add(string, wMSLayersPanel);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "Unable to add WMS server " + string2, exception);
            }
        }

        public WorldWindow getWwd() {
            return this.wwjPanel.wwd;
        }
    }

    public static class AppPanel
    extends JPanel {
        protected WorldWindow wwd = new WorldWindowGLCanvas();
        protected StatusBar statusBar;
        protected ToolTipController toolTipController;
        protected HighlightController highlightController;

        public AppPanel() {
            super(new BorderLayout());
            ((Component)((Object)this.wwd)).setPreferredSize(new Dimension(1200, 800));
            Model model = (Model)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ModelClassName");
            this.wwd.setModel(model);
            this.wwd.addSelectListener(new ClickAndGoSelectListener(this.wwd, WorldMapLayer.class));
            this.add((Component)((Object)this.wwd), "Center");
            this.statusBar = new StatusBar();
            this.add((Component)this.statusBar, "Last");
            this.statusBar.setEventSource(this.wwd);
            this.toolTipController = new ToolTipController(this.wwd, "gov.nasa.worldwind.avkey.DisplayName", null);
            this.highlightController = new HighlightController(this.wwd, "gov.nasa.worldwind.SelectEvent.Rollover");
        }
    }
}

