/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwindx.applications.dataimporter.FileStoreDataSet;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class FileStoreTableModel
extends AbstractTableModel {
    protected static final String[] columnTitles = new String[]{"Key", "Dataset", "Type", "Size (MB)"};
    protected static final Class[] columnTypes = new Class[]{Color.class, String.class, String.class, Long.class};
    protected List<FileStoreDataSet> dataSets = new ArrayList<FileStoreDataSet>();

    public void setDataSets(List<FileStoreDataSet> list) {
        this.dataSets.clear();
        if (list != null) {
            this.dataSets.addAll(list);
        }
        this.fireTableDataChanged();
    }

    public List<FileStoreDataSet> getDataSets() {
        return this.dataSets;
    }

    @Override
    public int getRowCount() {
        return this.dataSets.size();
    }

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public String getColumnName(int n) {
        return columnTitles[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return columnTypes[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        FileStoreDataSet fileStoreDataSet = this.dataSets.get(n);
        switch (n2) {
            case 0: {
                return fileStoreDataSet.getColor();
            }
            case 1: {
                return fileStoreDataSet.getName();
            }
            case 2: {
                return fileStoreDataSet.getDatasetType();
            }
            case 3: {
                Formatter formatter = new Formatter();
                return formatter.format("%5.1f", (double)fileStoreDataSet.getSize() / 1000000.0);
            }
        }
        return null;
    }

    public Integer getRowForDataSet(FileStoreDataSet fileStoreDataSet) {
        int n = 0;
        for (FileStoreDataSet fileStoreDataSet2 : this.dataSets) {
            if (fileStoreDataSet2 == fileStoreDataSet) {
                return n;
            }
            ++n;
        }
        return null;
    }

    public FileStoreDataSet getRow(int n) {
        Iterator<FileStoreDataSet> iterator = this.dataSets.iterator();
        for (int i = 0; i < n; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    public void removeDataSet(FileStoreDataSet fileStoreDataSet) {
        this.dataSets.remove(fileStoreDataSet);
        this.fireTableDataChanged();
    }

    public FileStoreDataSet getDataSetByName(String string) {
        for (FileStoreDataSet fileStoreDataSet : this.dataSets) {
            if (!fileStoreDataSet.getName().equals(string)) continue;
            return fileStoreDataSet;
        }
        return null;
    }
}

