/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.antenna;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class Interpolator2D {
    protected boolean wrapS = false;
    protected boolean wrapT = false;
    protected Double minS;
    protected Double maxS;
    protected Double minT;
    protected Double maxT;
    protected Double minValue;
    protected Double maxValue;
    protected TreeMap<Double, TreeMap<Double, Double>> map = new TreeMap();

    public boolean isWrapS() {
        return this.wrapS;
    }

    public void setWrapS(boolean bl) {
        this.wrapS = bl;
    }

    public boolean isWrapT() {
        return this.wrapT;
    }

    public void setWrapT(boolean bl) {
        this.wrapT = bl;
    }

    public void addValue(double d, double d2, double d3) {
        TreeMap<Double, Double> treeMap = this.map.get(d);
        if (treeMap == null) {
            treeMap = new TreeMap();
            this.map.put(d, treeMap);
        }
        treeMap.put(d2, d3);
        if (this.maxValue == null || d3 > this.maxValue) {
            this.maxValue = d3;
        }
        if (this.minValue == null || d3 < this.minValue) {
            this.minValue = d3;
        }
        if (this.maxS == null || d > this.maxS) {
            this.maxS = d;
        }
        if (this.minS == null || d < this.minS) {
            this.minS = d;
        }
        if (this.maxT == null || d2 > this.maxT) {
            this.maxT = d2;
        }
        if (this.minT == null || d2 < this.minT) {
            this.minT = d2;
        }
    }

    public Double getMinValue() {
        return this.minValue;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }

    public Double getMinS() {
        return this.minS;
    }

    public Double getMaxS() {
        return this.maxS;
    }

    public Double getMinT() {
        return this.minT;
    }

    public Double getMaxT() {
        return this.maxT;
    }

    public Double getValue(double d, double d2) {
        Map.Entry<Double, TreeMap<Double, Double>> entry = this.map.floorEntry(d);
        if (entry == null && this.wrapS) {
            entry = this.map.lastEntry();
        } else if (entry == null) {
            return null;
        }
        Map.Entry<Double, Double> entry2 = entry.getValue().floorEntry(d2);
        if (entry2 == null && this.wrapT) {
            entry2 = entry.getValue().lastEntry();
        } else if (entry2 == null) {
            return null;
        }
        Map.Entry<Double, Double> entry3 = entry.getValue().ceilingEntry(d2);
        if (entry3 == null && this.wrapT) {
            entry3 = entry.getValue().firstEntry();
        } else if (entry3 == null) {
            return null;
        }
        Map.Entry<Double, TreeMap<Double, Double>> entry4 = this.map.ceilingEntry(d);
        if (entry4 == null && this.wrapS) {
            entry4 = this.map.firstEntry();
        } else if (entry4 == null) {
            return null;
        }
        Map.Entry<Double, Double> entry5 = entry4.getValue().floorEntry(d2);
        if (entry5 == null && this.wrapT) {
            entry5 = entry4.getValue().lastEntry();
        } else if (entry5 == null) {
            return null;
        }
        Map.Entry<Double, Double> entry6 = entry4.getValue().ceilingEntry(d2);
        if (entry6 == null && this.wrapT) {
            entry6 = entry4.getValue().firstEntry();
        } else if (entry6 == null) {
            return null;
        }
        double d3 = entry2.getValue();
        double d4 = entry5.getValue();
        double d5 = entry3.getValue();
        double d6 = entry6.getValue();
        double d7 = entry.getKey();
        double d8 = entry4.getKey();
        double d9 = entry2.getKey();
        double d10 = entry6.getKey();
        double d11 = d8 - d7 != 0.0 ? (d - d7) / (d8 - d7) : 0.0;
        double d12 = d11 * d4 + (1.0 - d11) * d3;
        double d13 = d11 * d6 + (1.0 - d11) * d5;
        double d14 = d10 - d9 != 0.0 ? (d2 - d9) / (d10 - d9) : 0.0;
        double d15 = d14 * d13 + (1.0 - d14) * d12;
        return d15;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFromStream(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        String string = "[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?";
        Pattern pattern = Pattern.compile("\\s*" + string + "\\s+" + string + "\\s+" + string);
        Scanner scanner = new Scanner(inputStream);
        try {
            while (scanner.hasNextLine()) {
                String string2 = scanner.findInLine(pattern);
                if (string2 == null) {
                    scanner.nextLine();
                    continue;
                }
                String[] stringArray = string2.split("\\s+");
                if (stringArray.length < 3) continue;
                double d = Double.parseDouble(stringArray[0]);
                double d2 = Double.parseDouble(stringArray[1]);
                double d3 = Double.parseDouble(stringArray[2]);
                if (d2 < 0.0) {
                    d2 += 360.0;
                }
                this.addValue(d, d2, d3);
            }
        }
        finally {
            scanner.close();
        }
    }

    public void addFromFile(File file) throws FileNotFoundException {
        if (file == null || !file.exists()) {
            return;
        }
        this.addFromStream(new FileInputStream(file));
    }
}

