/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications;

import gov.nasa.worldwind.BasicFactory;
import gov.nasa.worldwind.event.BulkRetrievalEvent;
import gov.nasa.worldwind.event.BulkRetrievalListener;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.retrieve.BulkRetrievable;
import gov.nasa.worldwind.retrieve.BulkRetrievalThread;
import gov.nasa.worldwind.terrain.CompoundElevationModel;

public class BulkDownloadAlaska {
    public static void main(String[] stringArray) {
        try {
            Sector sector = Sector.fromDegrees(55.7, 71.1, -169.2, -129.5);
            BulkRetrievable bulkRetrievable = (BulkRetrievable)BasicFactory.create("gov.nasa.worldwind.avkey.LayerFactory", "config/Earth/BMNG256.xml");
            System.out.println(bulkRetrievable.getName());
            BulkRetrievalThread bulkRetrievalThread = bulkRetrievable.makeLocal(sector, 0.0, new BulkRetrievalListener(){

                @Override
                public void eventOccurred(BulkRetrievalEvent bulkRetrievalEvent) {
                    System.out.println(bulkRetrievalEvent.getItem());
                }
            });
            bulkRetrievalThread.join();
            bulkRetrievable = (BulkRetrievable)BasicFactory.create("gov.nasa.worldwind.avkey.LayerFactory", "config/Earth/Landsat256.xml");
            System.out.println(bulkRetrievable.getName());
            bulkRetrievalThread = bulkRetrievable.makeLocal(sector, 0.0, new BulkRetrievalListener(){

                @Override
                public void eventOccurred(BulkRetrievalEvent bulkRetrievalEvent) {
                    System.out.println(bulkRetrievalEvent.getItem());
                }
            });
            bulkRetrievalThread.join();
            CompoundElevationModel compoundElevationModel = (CompoundElevationModel)BasicFactory.create("gov.nasa.worldwind.avkey.ElevationModelFactory", "config/Earth/EarthElevations256.xml");
            bulkRetrievable = (BulkRetrievable)((Object)compoundElevationModel.getElevationModels().get(0));
            System.out.println(bulkRetrievable.getName());
            bulkRetrievalThread = bulkRetrievable.makeLocal(sector, 0.0, new BulkRetrievalListener(){

                @Override
                public void eventOccurred(BulkRetrievalEvent bulkRetrievalEvent) {
                    System.out.println(bulkRetrievalEvent.getItem());
                }
            });
            bulkRetrievalThread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

