/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.timeline;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.TreeSet;
import org.esa.snap.productlibrary.rcp.toolviews.model.DatabaseStatistics;
import org.esa.snap.productlibrary.rcp.toolviews.timeline.TimelinePlot;

class YearsPlot
extends TimelinePlot {
    YearsPlot(DatabaseStatistics stats) {
        super(stats);
    }

    @Override
    protected void paintPlot(Graphics2D g2d) {
        Map<Integer, DatabaseStatistics.YearData> yearDataMap = this.stats.getYearDataMap();
        TreeSet<Integer> years = new TreeSet<Integer>(yearDataMap.keySet());
        int numYears = years.size();
        int maxYearCnt = this.stats.getOverallMaxYearCnt();
        int w = this.getWidth();
        int h = this.getHeight() - 15;
        this.interval = (float)w / (float)numYears;
        float halfInterval = this.interval / 2.0f;
        float barWidth = halfInterval / 2.0f;
        int y = this.getHeight() - 2;
        float x = halfInterval;
        for (Integer year : years) {
            YearsPlot.drawButton(g2d, String.valueOf(year), (int)x - 20, y, yearDataMap.get(year).isSelected());
            float newH = (float)yearDataMap.get((Object)year).yearCnt / (float)maxYearCnt * (float)h;
            YearsPlot.drawBar(g2d, (int)(x - barWidth), h - (int)newH, (int)halfInterval, Math.max(1, (int)newH), h);
            x += this.interval;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TreeSet<Integer> sortedYears;
        Integer[] years;
        DatabaseStatistics.YearData yearData;
        int x = (int)((float)e.getX() / this.interval);
        Map<Integer, DatabaseStatistics.YearData> yearDataMap = this.stats.getYearDataMap();
        yearData.setSelected(!(yearData = yearDataMap.get((years = (sortedYears = new TreeSet<Integer>(yearDataMap.keySet())).toArray(new Integer[sortedYears.size()]))[x])).isSelected());
        this.repaint();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int x = (int)((float)event.getX() / this.interval);
        Map<Integer, DatabaseStatistics.YearData> yearDataMap = this.stats.getYearDataMap();
        TreeSet<Integer> sortedYears = new TreeSet<Integer>(yearDataMap.keySet());
        Integer[] years = sortedYears.toArray(new Integer[sortedYears.size()]);
        Integer value = yearDataMap.get((Object)years[x]).yearCnt;
        if (value == 0) {
            return "";
        }
        return String.valueOf(years[x]) + ": " + value;
    }
}

