/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.timeline;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JPanel;
import org.esa.snap.productlibrary.rcp.toolviews.model.DatabaseStatistics;

class TimelinePlot
extends JPanel
implements MouseListener {
    protected final DatabaseStatistics stats;
    protected float interval;

    TimelinePlot(DatabaseStatistics stats) {
        this.stats = stats;
        this.setToolTipText("");
        this.addMouseListener(this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        try {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            this.paintPlot(g2d);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void paintPlot(Graphics2D g2d) {
        Map<Integer, DatabaseStatistics.YearData> yearDataMap = this.stats.getYearDataMap();
        TreeSet<Integer> years = new TreeSet<Integer>(yearDataMap.keySet());
        int numYears = years.size();
        int maxDayCnt = this.stats.getOverallMaxDayCnt();
        int w = this.getWidth();
        int h = this.getHeight() - 15;
        this.interval = (float)w / (float)numYears;
        float halfInterval = this.interval / 2.0f;
        int y = this.getHeight() - 2;
        float x = halfInterval;
        for (Integer year : years) {
            g2d.setColor(Color.BLACK);
            g2d.drawString(String.valueOf(year), x - 20.0f, (float)y);
            DatabaseStatistics.YearData data = yearDataMap.get(year);
            g2d.setColor(Color.BLACK);
            g2d.drawLine((int)(x - halfInterval), h - 10, (int)(x - halfInterval), h + 5);
            for (int d = 1; d < 366; ++d) {
                float pctX = (float)d / 365.0f;
                float newH = (float)data.dayOfYearMap.get(d).intValue() / (float)maxDayCnt * (float)h;
                TimelinePlot.drawBar(g2d, (int)(x - halfInterval + pctX * this.interval), (int)((float)h - newH), 1, (int)newH, h);
            }
            x += this.interval;
        }
    }

    static void drawBar(Graphics2D g2d, int x, int y, int w, int h, int maxH) {
        for (int i = 0; i < h; ++i) {
            double pct = Math.max(0.4, (double)i / (double)maxH);
            g2d.setColor(new Color(7, (int)(150.0 * pct), (int)(255.0 * pct)));
            g2d.drawLine(x, y + h - i, x + w, y + h - i);
        }
    }

    static void drawButton(Graphics2D g2d, String text, int x, int y, boolean selected) {
        int rw = g2d.getFontMetrics().stringWidth(text) + 10;
        int rh = g2d.getFontMetrics().getHeight() - 4;
        int rx = x - 5;
        int ry = y - rh + 1;
        if (selected) {
            g2d.setColor(Color.lightGray);
            g2d.fillRoundRect(rx, ry, rw, rh, 5, 5);
        }
        g2d.setColor(Color.blue);
        g2d.drawRoundRect(rx, ry, rw, rh, 5, 5);
        g2d.setColor(Color.BLACK);
        g2d.drawString(text, x, y);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

