/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.listviews;

import java.io.File;
import java.util.ArrayList;
import org.esa.snap.core.datamodel.quicklooks.Quicklook;
import org.esa.snap.core.datamodel.quicklooks.Thumbnail;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.productlibrary.rcp.toolviews.ProductLibraryActions;
import org.esa.snap.productlibrary.rcp.toolviews.listviews.ListView;
import org.esa.snap.productlibrary.rcp.toolviews.model.SortingDecorator;
import org.esa.snap.rcp.quicklooks.ThumbnailPanel;

public class ThumbnailView
extends ThumbnailPanel
implements ListView {
    private ProductEntry[] productEntryList;

    public ThumbnailView(ProductLibraryActions productLibraryActions) {
        super(true);
        this.setComponentPopupMenu(productLibraryActions.createEntryTablePopup());
    }

    public void onSelectionChanged() {
        this.notifySelectionChanged();
    }

    public void onOpenAction() {
        this.notifyOpenAction();
    }

    @Override
    public File[] getSelectedFiles() {
        ArrayList<File> list = new ArrayList<File>();
        for (ThumbnailPanel.ThumbnailDrawing item : this.getSelection()) {
            Quicklook ql = (Quicklook)item.getThumbnail();
            for (ProductEntry entry : this.productEntryList) {
                if (!entry.getQuickLook().equals(ql)) continue;
                list.add(entry.getFile());
            }
        }
        return list.toArray(new File[list.size()]);
    }

    @Override
    public ProductEntry[] getSelectedProductEntries() {
        ArrayList<ProductEntry> list = new ArrayList<ProductEntry>();
        for (ThumbnailPanel.ThumbnailDrawing item : this.getSelection()) {
            Quicklook ql = (Quicklook)item.getThumbnail();
            for (ProductEntry entry : this.productEntryList) {
                if (!entry.getQuickLook().equals(ql)) continue;
                list.add(entry);
            }
        }
        return list.toArray(new ProductEntry[list.size()]);
    }

    @Override
    public ProductEntry getEntryOverMouse() {
        return null;
    }

    @Override
    public void sort(SortingDecorator.SORT_BY sortBy) {
    }

    @Override
    public int getTotalCount() {
        return this.productEntryList.length;
    }

    @Override
    public int getSelectionCount() {
        return this.getSelection().length;
    }

    @Override
    public void updateUI() {
    }

    @Override
    public void setProductEntryList(ProductEntry[] productEntryList) {
        this.productEntryList = productEntryList;
        ArrayList<Quicklook> thumbnails = new ArrayList<Quicklook>(productEntryList.length);
        for (ProductEntry productEntry : productEntryList) {
            if (productEntry.getQuickLook() == null) continue;
            thumbnails.add(productEntry.getQuickLook());
        }
        this.update(thumbnails.toArray(new Thumbnail[thumbnails.size()]));
    }
}

