/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.extensions;

import com.bc.ceres.core.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIRegistry;
import org.esa.snap.productlibrary.rcp.toolviews.extensions.ProductLibraryActionExt;
import org.esa.snap.productlibrary.rcp.toolviews.extensions.ProductLibraryActionExtDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ProductLibraryActionExtRegistry {
    private static ProductLibraryActionExtRegistry instance = null;
    private final Map<String, ProductLibraryActionExtDescriptor> actionExtDescriptors = new HashMap<String, ProductLibraryActionExtDescriptor>();
    private static Comparator<ProductLibraryActionExtDescriptor> descriptorComparator = (a, b) -> a.getPosition() - b.getPosition();

    public ProductLibraryActionExtRegistry() {
        this.registerActions();
    }

    public static ProductLibraryActionExtRegistry getInstance() {
        if (instance == null) {
            instance = new ProductLibraryActionExtRegistry();
        }
        return instance;
    }

    public ProductLibraryActionExtDescriptor[] getDescriptors() {
        ArrayList<ProductLibraryActionExtDescriptor> values = new ArrayList<ProductLibraryActionExtDescriptor>(this.actionExtDescriptors.values());
        values.sort(descriptorComparator);
        return values.toArray(new ProductLibraryActionExtDescriptor[values.size()]);
    }

    private void registerActions() {
        FileObject fileObj = FileUtil.getConfigFile((String)"ProductLibraryActions");
        if (fileObj == null) {
            SystemUtils.LOG.warning("No ProductLibrary Action found.");
            return;
        }
        FileObject[] files = fileObj.getChildren();
        List orderedFiles = FileUtil.getOrder(Arrays.asList(files), (boolean)true);
        for (FileObject file : orderedFiles) {
            ProductLibraryActionExtDescriptor actionExtDescriptor = null;
            try {
                actionExtDescriptor = ProductLibraryActionExtRegistry.createDescriptor(file);
            }
            catch (Exception e) {
                SystemUtils.LOG.severe(String.format("Failed to create ProductLibrary action from layer.xml path '%s'", file.getPath()));
            }
            if (actionExtDescriptor == null) continue;
            ProductLibraryActionExtDescriptor existingDescriptor = this.actionExtDescriptors.get(actionExtDescriptor.getId());
            if (existingDescriptor != null) {
                SystemUtils.LOG.warning(String.format("ProductLibrary action [%s] has been redeclared!\n", actionExtDescriptor.getId()));
            }
            this.actionExtDescriptors.put(actionExtDescriptor.getId(), actionExtDescriptor);
            SystemUtils.LOG.fine(String.format("New ProductLibrary action added from layer.xml path '%s': %s", file.getPath(), actionExtDescriptor.getId()));
        }
    }

    public static ProductLibraryActionExtDescriptor createDescriptor(FileObject fileObject) {
        String id = fileObject.getName();
        Class actionExtClass = OperatorUIRegistry.getClassAttribute((FileObject)fileObject, (String)"actionExtClass", ProductLibraryActionExt.class, (boolean)false);
        Integer position = (Integer)fileObject.getAttribute("position");
        Assert.argument((actionExtClass != null ? 1 : 0) != 0, (String)"Attribute 'actionExtClass' must be provided");
        Assert.argument((position != null ? 1 : 0) != 0, (String)"Attribute 'position' must be provided");
        return new ProductLibraryActionExtDescriptor(id, actionExtClass, position);
    }
}

