/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.util.ResourceUtils;
import org.esa.snap.graphbuilder.rcp.dialogs.BatchGraphDialog;
import org.esa.snap.graphbuilder.rcp.utils.ClipboardUtils;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.productlibrary.rcp.toolviews.DBScanner;
import org.esa.snap.productlibrary.rcp.toolviews.LabelBarProgressMonitor;
import org.esa.snap.productlibrary.rcp.toolviews.ProductFileHandler;
import org.esa.snap.productlibrary.rcp.toolviews.ProductLibraryToolView;
import org.esa.snap.productlibrary.rcp.toolviews.extensions.ProductLibraryActionExt;
import org.esa.snap.productlibrary.rcp.toolviews.extensions.ProductLibraryActionExtDescriptor;
import org.esa.snap.productlibrary.rcp.toolviews.extensions.ProductLibraryActionExtRegistry;
import org.esa.snap.productlibrary.rcp.toolviews.model.SortingDecorator;
import org.esa.snap.productlibrary.rcp.utils.ProductOpener;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.SnapFileChooser;
import org.esa.snap.ui.UIUtils;

public class ProductLibraryActions {
    private static final ImageIcon selectAllIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/productlibrary/icons/select-all24.png", ProductLibraryToolView.class);
    private static final ImageIcon openIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/productlibrary/icons/open24.png", ProductLibraryToolView.class);
    private static final ImageIcon copyIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/productlibrary/icons/copy24.png", ProductLibraryToolView.class);
    private static final ImageIcon batchIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/productlibrary/icons/batch24.png", ProductLibraryToolView.class);
    private final ProductLibraryToolView toolView;
    private JButton selectAllButton;
    private JButton openAllSelectedButton;
    private JButton copySelectedButton;
    private JButton batchProcessButton;
    private List<ProductLibraryActionExt> actionExtList = new ArrayList<ProductLibraryActionExt>();
    private JMenuItem copyToItem;
    private JMenuItem moveToItem;
    private JMenuItem deleteItem;
    private File currentDirectory;
    private final List<ProductLibraryActionListener> listenerList = new ArrayList<ProductLibraryActionListener>(1);

    public ProductLibraryActions(ProductLibraryToolView toolView) {
        this.toolView = toolView;
    }

    public JPanel createCommandPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.selectAllButton = DialogUtils.createButton((String)"selectAllButton", (String)"Select all", (ImageIcon)selectAllIcon, (JPanel)panel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.toolView.selectAll();
            }
        });
        this.openAllSelectedButton = DialogUtils.createButton((String)"openAllSelectedButton", (String)"Open selected", (ImageIcon)openIcon, (JPanel)panel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.openAllSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performOpenAction();
            }
        });
        this.copySelectedButton = DialogUtils.createButton((String)"copySelectedButton", (String)"Copy to clipboard", (ImageIcon)copyIcon, (JPanel)panel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.copySelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performCopyAction();
            }
        });
        this.batchProcessButton = DialogUtils.createButton((String)"batchProcessButton", (String)"Batch", (ImageIcon)batchIcon, (JPanel)panel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.batchProcessButton.setToolTipText("Right click to select a graph");
        this.batchProcessButton.setComponentPopupMenu(this.createGraphPopup());
        this.batchProcessButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.batchProcess(ProductLibraryActions.this.toolView.getSelectedProductEntries(), null);
            }
        });
        panel.add(this.selectAllButton);
        panel.add(this.openAllSelectedButton);
        panel.add(this.copySelectedButton);
        panel.add(this.batchProcessButton);
        panel.add(Box.createRigidArea(new Dimension(24, 24)));
        for (ProductLibraryActionExtDescriptor desc : ProductLibraryActionExtRegistry.getInstance().getDescriptors()) {
            final ProductLibraryActionExt action = desc.createActionExt(this);
            this.actionExtList.add(action);
            JButton button = action.getButton(panel);
            panel.add(button);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    action.performAction();
                }
            });
        }
        return panel;
    }

    private static void batchProcess(ProductEntry[] productEntryList, File graphFile) {
        BatchGraphDialog batchDlg = new BatchGraphDialog(SnapApp.getDefault().getAppContext(), "Batch Processing", "batchProcessing", false);
        batchDlg.setInputFiles(productEntryList);
        if (graphFile != null) {
            batchDlg.LoadGraph(graphFile);
        }
        batchDlg.show();
    }

    public void selectionChanged(ProductEntry[] selections) {
        boolean enable = selections.length > 0;
        this.openAllSelectedButton.setEnabled(enable);
        this.copySelectedButton.setEnabled(enable);
        this.batchProcessButton.setEnabled(enable);
        for (ProductLibraryActionExt action : this.actionExtList) {
            action.selectionChanged(selections);
        }
    }

    private void performCopyAction() {
        File[] fileList = this.toolView.getSelectedFiles();
        if (fileList.length != 0) {
            ClipboardUtils.copyToClipboard((File[])fileList);
        }
    }

    private void performFileAction(ProductFileHandler.TYPE operationType) {
        File targetFolder;
        if (operationType.equals((Object)ProductFileHandler.TYPE.DELETE)) {
            targetFolder = null;
        } else {
            targetFolder = this.promptForRepositoryBaseDir();
            if (targetFolder == null) {
                return;
            }
        }
        ProductEntry[] entries = this.toolView.getSelectedProductEntries();
        LabelBarProgressMonitor progMon = this.toolView.createLabelBarProgressMonitor();
        ProductFileHandler fileHandler = new ProductFileHandler(entries, operationType, targetFolder, progMon);
        fileHandler.addListener(new MyFileHandlerListener());
        fileHandler.execute();
    }

    public File[] getSelectedFiles() {
        return this.toolView.getSelectedFiles();
    }

    public ProductEntry[] getSelectedProductEntries() {
        return this.toolView.getSelectedProductEntries();
    }

    public void performOpenAction() {
        ProductOpener.openProducts(this.getSelectedFiles());
    }

    public void findSlices(int dataTakeId) {
        this.toolView.findSlices(dataTakeId);
    }

    public File promptForRepositoryBaseDir() {
        JFileChooser fileChooser = ProductLibraryActions.createDirectoryChooser();
        fileChooser.setCurrentDirectory(this.currentDirectory);
        int response = fileChooser.showOpenDialog(SnapApp.getDefault().getMainFrame());
        this.currentDirectory = fileChooser.getCurrentDirectory();
        File selectedDir = fileChooser.getSelectedFile();
        if (selectedDir != null && selectedDir.isFile()) {
            selectedDir = selectedDir.getParentFile();
        }
        if (response == 0) {
            return selectedDir;
        }
        return null;
    }

    private static JFileChooser createDirectoryChooser() {
        SnapFileChooser fileChooser = new SnapFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Directories";
            }
        });
        fileChooser.setDialogTitle("Select Directory");
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(1);
        fileChooser.setApproveButtonText("Select");
        fileChooser.setApproveButtonMnemonic('S');
        return fileChooser;
    }

    public JPopupMenu createEntryTablePopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem selectAllItem = new JMenuItem("Select All");
        selectAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.toolView.selectAll();
            }
        });
        popup.add(selectAllItem);
        JMenuItem selectNoneItem = new JMenuItem("Select None");
        selectNoneItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.toolView.selectNone();
            }
        });
        popup.add(selectNoneItem);
        JMenuItem openSelectedItem = new JMenuItem("Open Selected");
        openSelectedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performOpenAction();
            }
        });
        popup.add(openSelectedItem);
        JMenuItem copySelectedItem = new JMenuItem("Copy Selected");
        copySelectedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performCopyAction();
            }
        });
        popup.add(copySelectedItem);
        popup.addSeparator();
        this.copyToItem = new JMenuItem("Copy Selected Files To...");
        this.copyToItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performFileAction(ProductFileHandler.TYPE.COPY_TO);
            }
        });
        popup.add(this.copyToItem);
        this.moveToItem = new JMenuItem("Move Selected Files To...");
        this.moveToItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.performFileAction(ProductFileHandler.TYPE.MOVE_TO);
            }
        });
        popup.add(this.moveToItem);
        this.deleteItem = new JMenuItem("Delete Selected Files");
        this.deleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dialogs.Answer status = Dialogs.requestDecision((String)"Deleting selected files", (String)"Are you sure you want to delete these products", (boolean)true, null);
                if (status == Dialogs.Answer.YES) {
                    ProductLibraryActions.this.performFileAction(ProductFileHandler.TYPE.DELETE);
                }
            }
        });
        popup.add(this.deleteItem);
        JMenuItem exploreItem = new JMenuItem("Browse Folder");
        exploreItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductEntry entry = ProductLibraryActions.this.toolView.getEntryOverMouse();
                if (entry != null && entry instanceof ProductEntry) {
                    ProductEntry prodEntry = entry;
                    try {
                        Desktop.getDesktop().open(prodEntry.getFile().getParentFile());
                    }
                    catch (Exception ex) {
                        System.out.println(ex.getMessage());
                    }
                }
            }
        });
        popup.add(exploreItem);
        popup.addSeparator();
        JMenu sortMenu = new JMenu("Sort By");
        popup.add(sortMenu);
        sortMenu.add(this.createSortItem("Product Name", SortingDecorator.SORT_BY.NAME));
        sortMenu.add(this.createSortItem("Product Type", SortingDecorator.SORT_BY.TYPE));
        sortMenu.add(this.createSortItem("Acquisition Date", SortingDecorator.SORT_BY.DATE));
        sortMenu.add(this.createSortItem("Mission", SortingDecorator.SORT_BY.MISSON));
        sortMenu.add(this.createSortItem("File Size", SortingDecorator.SORT_BY.FILESIZE));
        return popup;
    }

    private JMenuItem createSortItem(String name, final SortingDecorator.SORT_BY sortBy) {
        JMenuItem item = new JMenuItem(name);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryActions.this.toolView.sort(sortBy);
            }
        });
        return item;
    }

    public JPopupMenu createGraphPopup() {
        Path graphPath = ResourceUtils.getGraphFolder((String)"");
        JPopupMenu popup = new JPopupMenu();
        if (Files.exists(graphPath, new LinkOption[0])) {
            this.createGraphMenu(popup, graphPath.toFile());
        }
        return popup;
    }

    private void createGraphMenu(JPopupMenu menu, File path) {
        File[] filesList = path.listFiles();
        if (filesList == null || filesList.length == 0) {
            return;
        }
        for (final File file : filesList) {
            String name = file.getName();
            if (file.isDirectory() && !file.isHidden() && !name.equalsIgnoreCase("internal")) {
                JMenu subMenu = new JMenu(name);
                menu.add(subMenu);
                this.createGraphMenu(subMenu, file);
                continue;
            }
            if (!name.toLowerCase().endsWith(".xml")) continue;
            JMenuItem item = new JMenuItem(name.substring(0, name.indexOf(".xml")));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ProductLibraryActions.this.batchProcessButton.isEnabled()) {
                        ProductLibraryActions.batchProcess(ProductLibraryActions.this.toolView.getSelectedProductEntries(), file);
                    }
                }
            });
            menu.add(item);
        }
    }

    private void createGraphMenu(JMenu menu, File path) {
        File[] filesList = path.listFiles();
        if (filesList == null || filesList.length == 0) {
            return;
        }
        for (final File file : filesList) {
            String name = file.getName();
            if (file.isDirectory() && !file.isHidden() && !name.equalsIgnoreCase("internal")) {
                JMenu subMenu = new JMenu(name);
                menu.add(subMenu);
                this.createGraphMenu(subMenu, file);
                continue;
            }
            if (!name.toLowerCase().endsWith(".xml")) continue;
            JMenuItem item = new JMenuItem(name.substring(0, name.indexOf(".xml")));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ProductLibraryActions.this.batchProcessButton.isEnabled()) {
                        ProductLibraryActions.batchProcess(ProductLibraryActions.this.toolView.getSelectedProductEntries(), file);
                    }
                }
            });
            menu.add(item);
        }
    }

    public void updateContextMenu(ProductEntry[] selections) {
        boolean allValid = true;
        for (ProductEntry entry : selections) {
            if (ProductFileHandler.canMove(entry)) continue;
            allValid = false;
            break;
        }
        this.copyToItem.setEnabled(allValid);
        this.moveToItem.setEnabled(allValid);
        this.deleteItem.setEnabled(allValid);
    }

    public void addListener(ProductLibraryActionListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    private void notifyDirectoryChanged() {
        for (ProductLibraryActionListener listener : this.listenerList) {
            listener.notifyDirectoryChanged();
        }
    }

    private void notifySelectionChanged() {
        for (ProductLibraryActionListener listener : this.listenerList) {
            listener.notifySelectionChanged();
        }
    }

    private class MyFileHandlerListener
    implements ProductFileHandler.ProductFileHandlerListener {
        private MyFileHandlerListener() {
        }

        @Override
        public void notifyMSG(ProductFileHandler fileHandler, ProductFileHandler.ProductFileHandlerListener.MSG msg) {
            if (msg.equals((Object)ProductFileHandler.ProductFileHandlerListener.MSG.DONE)) {
                List<DBScanner.ErrorFile> errorList = fileHandler.getErrorList();
                if (!errorList.isEmpty()) {
                    ProductLibraryActions.this.toolView;
                    ProductLibraryToolView.handleErrorList(errorList);
                }
                if (fileHandler.getOperationType().equals((Object)ProductFileHandler.TYPE.MOVE_TO) || fileHandler.getOperationType().equals((Object)ProductFileHandler.TYPE.DELETE)) {
                    ProductLibraryActions.this.notifyDirectoryChanged();
                }
            }
            ProductLibraryActions.this.toolView.UpdateUI();
        }
    }

    public static interface ProductLibraryActionListener {
        public void notifyDirectoryChanged();

        public void notifySelectionChanged();
    }
}

