/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import weka.core.PluginManager;
import weka.core.WekaException;
import weka.gui.ExtensionFileFilter;
import weka.gui.Logger;
import weka.knowledgeflow.FlowExecutor;
import weka.knowledgeflow.FlowLoader;
import weka.knowledgeflow.JSONFlowLoader;
import weka.knowledgeflow.JSONFlowUtils;
import weka.knowledgeflow.LegacyFlowLoader;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.SetVariables;

public class Flow {
    public static final List<FileFilter> FLOW_FILE_EXTENSIONS = new ArrayList<FileFilter>();
    protected Map<String, StepManagerImpl> m_flowSteps = new LinkedHashMap<String, StepManagerImpl>();
    protected String m_flowName = "Untitled";

    public static FlowLoader getFlowLoader(String flowFileExtension, Logger log) throws WekaException {
        Set<String> availableLoaders = PluginManager.getPluginNamesOfType(FlowLoader.class.getCanonicalName());
        FlowLoader result = null;
        if (availableLoaders != null) {
            try {
                for (String l : availableLoaders) {
                    FlowLoader candidate = (FlowLoader)PluginManager.getPluginInstance(FlowLoader.class.getCanonicalName(), l);
                    if (!candidate.getFlowFileExtension().equalsIgnoreCase(flowFileExtension)) continue;
                    result = candidate;
                    break;
                }
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
        }
        if (result != null) {
            result.setLog(log);
        }
        return result;
    }

    public static Flow loadFlow(File flowFile, Logger log) throws WekaException {
        FlowLoader toUse;
        String extension = "kf";
        if (flowFile.toString().lastIndexOf(46) > 0) {
            extension = flowFile.toString().substring(flowFile.toString().lastIndexOf(46) + 1, flowFile.toString().length());
        }
        if ((toUse = Flow.getFlowLoader(extension, log)) == null) {
            throw new WekaException("Was unable to find a loader for flow file: " + flowFile.toString());
        }
        return toUse.readFlow(flowFile);
    }

    public static Flow loadFlow(InputStream is, FlowLoader loader) throws WekaException {
        return loader.readFlow(is);
    }

    public static Flow loadFlow(Reader r, FlowLoader loader) throws WekaException {
        return loader.readFlow(r);
    }

    public static Flow JSONToFlow(String flowJSON) throws WekaException {
        return Flow.JSONToFlow(flowJSON, false);
    }

    public static Flow JSONToFlow(String flowJSON, boolean dontComplainAboutMissingConnections) throws WekaException {
        return JSONFlowUtils.JSONToFlow(flowJSON, dontComplainAboutMissingConnections);
    }

    public void saveFlow(File file) throws WekaException {
        JSONFlowUtils.writeFlow(this, file);
    }

    public String getFlowName() {
        return this.m_flowName;
    }

    public void setFlowName(String name) {
        this.m_flowName = name;
    }

    public String getFlowID() {
        String ID = this.getFlowName();
        try {
            ID = ID + "_" + this.toJSON().hashCode();
        }
        catch (WekaException ex) {
            ex.printStackTrace();
        }
        return ID;
    }

    public synchronized void addAll(List<StepManagerImpl> steps) {
        for (StepManagerImpl s : steps) {
            this.addStep(s);
        }
    }

    public synchronized void addStep(StepManagerImpl manager) {
        String toAddName = manager.getManagedStep().getName();
        if (toAddName != null && toAddName.length() > 0) {
            boolean exactMatch = false;
            int maxCopyNum = 1;
            for (Map.Entry<String, StepManagerImpl> e : this.m_flowSteps.entrySet()) {
                String compName = e.getValue().getManagedStep().getName();
                if (toAddName.equals(compName)) {
                    exactMatch = true;
                    continue;
                }
                if (!compName.startsWith(toAddName)) continue;
                String num = compName.replace(toAddName, "");
                try {
                    int compNum = Integer.parseInt(num);
                    if (compNum <= maxCopyNum) continue;
                    maxCopyNum = compNum;
                }
                catch (NumberFormatException ex) {}
            }
            if (exactMatch) {
                toAddName = toAddName + "" + ++maxCopyNum;
                manager.getManagedStep().setName(toAddName);
            }
        }
        this.m_flowSteps.put(toAddName, manager);
    }

    public synchronized boolean connectSteps(StepManagerImpl source, StepManagerImpl target, String connectionType) {
        return this.connectSteps(source, target, connectionType, false);
    }

    public synchronized boolean connectSteps(StepManagerImpl source, StepManagerImpl target, String connectionType, boolean force) {
        boolean connSuccessful = false;
        if (this.findStep(source.getName()) == source && this.findStep(target.getName()) == target) {
            connSuccessful = source.addOutgoingConnection(connectionType, target, force);
        }
        return connSuccessful;
    }

    public synchronized void renameStep(StepManagerImpl step, String newName) throws WekaException {
        this.renameStep(step.getName(), newName);
    }

    public synchronized void renameStep(String oldName, String newName) throws WekaException {
        if (!this.m_flowSteps.containsKey(oldName)) {
            throw new WekaException("Step " + oldName + " does not seem to be part of the flow!");
        }
        StepManagerImpl toRename = this.m_flowSteps.remove(oldName);
        toRename.getManagedStep().setName(newName);
        this.m_flowSteps.put(newName, toRename);
    }

    public synchronized void removeStep(StepManagerImpl manager) throws WekaException {
        if (!this.m_flowSteps.containsKey(manager.getManagedStep().getName())) {
            throw new WekaException("Step " + manager.getManagedStep().getName() + " does not seem to be part of the flow!");
        }
        this.m_flowSteps.remove(manager.getManagedStep().getName());
        manager.clearAllConnections();
        for (Map.Entry<String, StepManagerImpl> e : this.m_flowSteps.entrySet()) {
            e.getValue().disconnectStep(manager.getManagedStep());
        }
    }

    public List<StepManagerImpl> getSteps() {
        return new ArrayList<StepManagerImpl>(this.m_flowSteps.values());
    }

    public Iterator<StepManagerImpl> iterator() {
        return this.m_flowSteps.values().iterator();
    }

    public int size() {
        return this.m_flowSteps.size();
    }

    public StepManagerImpl findStep(String stepName) {
        return this.m_flowSteps.get(stepName);
    }

    public List<StepManagerImpl> findPotentialStartPoints() {
        ArrayList<StepManagerImpl> startPoints = new ArrayList<StepManagerImpl>();
        for (Map.Entry<String, StepManagerImpl> e : this.m_flowSteps.entrySet()) {
            StepManagerImpl candidate = e.getValue();
            if (candidate.getIncomingConnections().size() != 0) continue;
            startPoints.add(candidate);
        }
        return startPoints;
    }

    public boolean initFlow(FlowExecutor executor) throws WekaException {
        boolean initOK = true;
        for (Map.Entry<String, StepManagerImpl> s : this.m_flowSteps.entrySet()) {
            s.getValue().setExecutionEnvironment(executor.getExecutionEnvironment());
        }
        for (Map.Entry<String, StepManagerImpl> s : this.m_flowSteps.entrySet()) {
            if (!(s.getValue().getManagedStep() instanceof SetVariables) || s.getValue().initStep()) continue;
            initOK = false;
            break;
        }
        if (initOK) {
            for (Map.Entry<String, StepManagerImpl> s : this.m_flowSteps.entrySet()) {
                if (s.getValue().initStep()) continue;
                initOK = false;
                break;
            }
        }
        return initOK;
    }

    public String toJSON() throws WekaException {
        return JSONFlowUtils.flowToJSON(this);
    }

    public Flow copyFlow() throws WekaException {
        return Flow.JSONToFlow(this.toJSON());
    }

    static {
        PluginManager.addPlugin(FlowLoader.class.getCanonicalName(), JSONFlowLoader.class.getCanonicalName(), JSONFlowLoader.class.getCanonicalName(), true);
        PluginManager.addPlugin(FlowLoader.class.getCanonicalName(), LegacyFlowLoader.class.getCanonicalName(), LegacyFlowLoader.class.getCanonicalName(), true);
        Set<String> flowLoaders = PluginManager.getPluginNamesOfType(FlowLoader.class.getCanonicalName());
        if (flowLoaders != null) {
            try {
                for (String f : flowLoaders) {
                    FlowLoader fl = (FlowLoader)PluginManager.getPluginInstance(FlowLoader.class.getCanonicalName(), f);
                    String extension = fl.getFlowFileExtension();
                    String description = fl.getFlowFileExtensionDescription();
                    FLOW_FILE_EXTENSIONS.add(new ExtensionFileFilter("." + extension, description + " (*." + extension + ")"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

