/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.util.internal;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.stream.Stream;
import org.esa.snap.rcp.util.SelectionSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class DefaultSelectionSupport<T>
implements SelectionSupport<T> {
    private final Class<T> type;
    private final Lookup.Result<T> itemResult;
    private final LinkedList<SelectionSupport.Handler<T>> handlerList;
    private final LookupListener lookupListener;
    private Collection<? extends T> currentlySelectedItems;
    private LookupListener theWeakListener;

    public DefaultSelectionSupport(Class<T> type) {
        this.type = type;
        this.currentlySelectedItems = Collections.emptyList();
        this.itemResult = Utilities.actionsGlobalContext().lookupResult(type);
        this.handlerList = new LinkedList();
        this.lookupListener = this.createLookupListener();
    }

    @Override
    public void addHandler(SelectionSupport.Handler<T> handler) {
        if (this.handlerList.isEmpty() && this.theWeakListener == null) {
            this.theWeakListener = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.lookupListener, this.itemResult);
            this.itemResult.addLookupListener(this.theWeakListener);
        }
        this.handlerList.add(handler);
    }

    @Override
    public void removeHandler(SelectionSupport.Handler<T> handler) {
        this.handlerList.remove(handler);
        if (this.handlerList.isEmpty()) {
            this.itemResult.removeLookupListener(this.theWeakListener);
            this.theWeakListener = null;
        }
    }

    private LookupListener createLookupListener() {
        return ev -> {
            Collection allItems = this.itemResult.allInstances();
            Stream<Object> deselectedStream = this.currentlySelectedItems.stream().filter(o -> !allItems.contains(o));
            A[] allDeselected = deselectedStream.toArray(value -> (Object[])Array.newInstance(this.type, value));
            Object firstDeselected = null;
            if (allDeselected.length > 0) {
                firstDeselected = allDeselected[0];
            }
            Stream<Object> newlySelectedStream = allItems.stream().filter(o -> !this.currentlySelectedItems.contains(o));
            A[] allNewlySelected = newlySelectedStream.toArray(value -> (Object[])Array.newInstance(this.type, value));
            Object firstSelected = null;
            if (allNewlySelected.length > 0) {
                firstSelected = allNewlySelected[0];
            }
            this.currentlySelectedItems = allItems;
            for (SelectionSupport.Handler handler : this.handlerList) {
                handler.selectionChange(firstDeselected, firstSelected);
            }
        };
    }
}

