/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.rcp.util.DateCellRenderer;
import org.esa.snap.rcp.util.DateTimePicker;
import org.jdesktop.swingx.table.DatePickerCellEditor;

public class DateTimePickerCellEditor
extends DatePickerCellEditor {
    public DateTimePickerCellEditor(DateFormat dateFormat, DateFormat timeFormat) {
        super(null);
        Date asDate = ProductData.UTC.create((Date)new Date(), (long)0L).getAsDate();
        DateTimePicker dateTimePicker = new DateTimePicker(asDate, Locale.getDefault(), dateFormat, timeFormat);
        dateTimePicker.getEditor().setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        dateTimePicker.addActionListener(this.getPickerActionListener());
        this.datePicker = dateTimePicker;
    }

    private DateTimePicker getEditor() {
        return (DateTimePicker)this.datePicker;
    }

    public void setTimeFormat(DateFormat timeFormat) {
        this.getEditor().setTimeFormat(timeFormat);
    }

    public DateFormat getTimeFormat() {
        return this.getEditor().getTimeFormat();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.ignoreAction = true;
        Date valueAsDate = this.getValueAsDate(value);
        this.getEditor().setDateTime(valueAsDate);
        this.ignoreAction = false;
        return this.datePicker;
    }

    public static void main(String[] args) {
        Locale.setDefault(Locale.ENGLISH);
        SwingUtilities.invokeLater(() -> {
            DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss");
            DateFormat timeFormat = ProductData.UTC.createDateFormat((String)"HH:mm:ss");
            Calendar calendar = DateTimePickerCellEditor.getCalendar();
            Object[] date1 = new Date[]{calendar.getTime()};
            calendar.roll(5, 1);
            Object[] date2 = new Date[]{(Date)calendar.getTime().clone()};
            calendar.roll(5, 1);
            calendar.roll(10, 3);
            Object[] date3 = new Date[]{calendar.getTime()};
            Object[] date4 = new Date[]{null};
            DefaultTableModel tableModel = new DefaultTableModel(0, 1);
            tableModel.addRow(date1);
            tableModel.addRow(date2);
            tableModel.addRow(date3);
            tableModel.addRow(date4);
            JTable table = new JTable(tableModel);
            DateTimePickerCellEditor timePickerCellEditor = new DateTimePickerCellEditor(dateFormat, timeFormat);
            timePickerCellEditor.setClickCountToStart(1);
            table.getColumnModel().getColumn(0).setPreferredWidth(250);
            table.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)((Object)timePickerCellEditor));
            table.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)((Object)new DateCellRenderer(dateFormat)));
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)table, "Center");
            JFrame frame = new JFrame("Test DateTime Picker");
            frame.setContentPane(panel);
            frame.setDefaultCloseOperation(3);
            frame.setLocationByPlatform(true);
            frame.pack();
            frame.setVisible(true);
        });
    }

    private static Calendar getCalendar() {
        Calendar calendar = ProductData.UTC.createCalendar();
        calendar.setTimeInMillis(new Date().getTime());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }
}

