/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.sync;

import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glayer.swing.LayerCanvas;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.netbeans.docwin.DocumentWindowManager;
import org.esa.snap.netbeans.docwin.WindowUtilities;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.sync.ImageCursorOverlay;
import org.esa.snap.rcp.windows.ProductSceneViewTopComponent;
import org.esa.snap.ui.PixelPositionListener;
import org.esa.snap.ui.product.ProductSceneView;

public class ImageCursorSynchronizer
implements Runnable {
    public static final String PROPERTY_KEY_AUTO_SYNC_CURSORS = "auto_sync_image_cursors";
    private static final GeoPos INVALID_GEO_POS = new GeoPos(Double.NaN, Double.NaN);
    private static final DocumentWindowManager.Predicate<Object, ProductSceneView> SCENE_VIEW_PREDICATE = DocumentWindowManager.Predicate.view(ProductSceneView.class);
    private Map<ProductSceneView, ImageCursorOverlay> psvOverlayMap;
    private Map<ProductSceneView, MyPixelPositionListener> viewPplMap;
    private PsvListUpdater psvOverlayMapUpdater;

    @Override
    public void run() {
        this.psvOverlayMap = new WeakHashMap<ProductSceneView, ImageCursorOverlay>();
        this.viewPplMap = new WeakHashMap<ProductSceneView, MyPixelPositionListener>();
        this.psvOverlayMapUpdater = new PsvListUpdater();
        Preferences preferences = SnapApp.getDefault().getPreferences();
        preferences.addPreferenceChangeListener(new ImageCursorSynchronizerPreferenceChangeListener());
    }

    private boolean isActive() {
        return SnapApp.getDefault().getPreferences().getBoolean(PROPERTY_KEY_AUTO_SYNC_CURSORS, false);
    }

    public void updateCursorOverlays(GeoPos geoPos, ProductSceneView sourceView) {
        if (!this.isActive()) {
            return;
        }
        for (Map.Entry<ProductSceneView, ImageCursorOverlay> entry : this.psvOverlayMap.entrySet()) {
            ProductSceneView view = entry.getKey();
            ImageCursorOverlay overlay = entry.getValue();
            if (overlay == null) {
                if (view == sourceView) continue;
                overlay = new ImageCursorOverlay(view, geoPos);
                this.psvOverlayMap.put(view, overlay);
                view.getLayerCanvas().addOverlay((LayerCanvas.Overlay)overlay);
                continue;
            }
            if (view != sourceView) {
                overlay.setGeoPosition(geoPos);
                view.getLayerCanvas().repaint();
                continue;
            }
            view.getLayerCanvas().removeOverlay((LayerCanvas.Overlay)overlay);
            this.psvOverlayMap.put(view, null);
        }
    }

    private void initPsvOverlayMap() {
        WindowUtilities.getOpened(ProductSceneViewTopComponent.class).map(ProductSceneViewTopComponent::getView).forEach(this::addPPL);
    }

    private void clearPsvOverlayMap() {
        for (Map.Entry<ProductSceneView, ImageCursorOverlay> entry : this.psvOverlayMap.entrySet()) {
            ProductSceneView view = entry.getKey();
            this.removePPL(view);
            view.getLayerCanvas().removeOverlay((LayerCanvas.Overlay)entry.getValue());
        }
        this.psvOverlayMap.clear();
    }

    private void addPPL(ProductSceneView view) {
        GeoCoding geoCoding = view.getProduct().getSceneGeoCoding();
        if (geoCoding != null && geoCoding.canGetPixelPos()) {
            this.psvOverlayMap.put(view, null);
            MyPixelPositionListener ppl = new MyPixelPositionListener(view);
            this.viewPplMap.put(view, ppl);
            view.addPixelPositionListener((PixelPositionListener)ppl);
        }
    }

    private void removePPL(ProductSceneView view) {
        MyPixelPositionListener ppl = this.viewPplMap.get(view);
        if (ppl != null) {
            this.viewPplMap.remove(view);
            view.removePixelPositionListener((PixelPositionListener)ppl);
        }
    }

    private class ImageCursorSynchronizerPreferenceChangeListener
    implements PreferenceChangeListener {
        private ImageCursorSynchronizerPreferenceChangeListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            if (ImageCursorSynchronizer.PROPERTY_KEY_AUTO_SYNC_CURSORS.equals(evt.getKey())) {
                if (ImageCursorSynchronizer.this.isActive()) {
                    ImageCursorSynchronizer.this.initPsvOverlayMap();
                    DocumentWindowManager.getDefault().addListener(SCENE_VIEW_PREDICATE, (DocumentWindowManager.Listener)ImageCursorSynchronizer.this.psvOverlayMapUpdater);
                } else {
                    DocumentWindowManager.getDefault().removeListener(SCENE_VIEW_PREDICATE, (DocumentWindowManager.Listener)ImageCursorSynchronizer.this.psvOverlayMapUpdater);
                    ImageCursorSynchronizer.this.clearPsvOverlayMap();
                }
            }
        }
    }

    private class MyPixelPositionListener
    implements PixelPositionListener {
        private final ProductSceneView view;

        private MyPixelPositionListener(ProductSceneView view) {
            this.view = view;
        }

        public void pixelPosChanged(ImageLayer baseImageLayer, int pixelX, int pixelY, int currentLevel, boolean pixelPosValid, MouseEvent e) {
            PixelPos pixelPos = this.computeLevelZeroPixelPos(baseImageLayer, pixelX, pixelY, currentLevel);
            GeoPos geoPos = this.view.getRaster().getGeoCoding().getGeoPos(pixelPos, null);
            ImageCursorSynchronizer.this.updateCursorOverlays(geoPos, this.view);
        }

        private PixelPos computeLevelZeroPixelPos(ImageLayer imageLayer, int pixelX, int pixelY, int currentLevel) {
            if (currentLevel != 0) {
                AffineTransform i2mTransform = imageLayer.getImageToModelTransform(currentLevel);
                Point2D modelP = i2mTransform.transform(new Point2D.Double((double)pixelX + 0.5, (double)pixelY + 0.5), null);
                AffineTransform m2iTransform = imageLayer.getModelToImageTransform();
                Point2D imageP = m2iTransform.transform(modelP, null);
                return new PixelPos((double)new Float(imageP.getX()).floatValue(), (double)new Float(imageP.getY()).floatValue());
            }
            return new PixelPos((double)pixelX + 0.5, (double)pixelY + 0.5);
        }

        public void pixelPosNotAvailable() {
            ImageCursorSynchronizer.this.updateCursorOverlays(INVALID_GEO_POS, null);
        }
    }

    private class PsvListUpdater
    implements DocumentWindowManager.Listener<Object, ProductSceneView> {
        private PsvListUpdater() {
        }

        public void windowOpened(DocumentWindowManager.Event<Object, ProductSceneView> e) {
            ImageCursorSynchronizer.this.addPPL((ProductSceneView)e.getWindow().getView());
        }

        public void windowClosed(DocumentWindowManager.Event<Object, ProductSceneView> e) {
            ImageCursorSynchronizer.this.removePPL((ProductSceneView)e.getWindow().getView());
        }
    }
}

