/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.preferences;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.core.Assert;
import com.bc.ceres.swing.binding.BindingContext;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.preferences.Preference;
import org.esa.snap.rcp.preferences.PreferencesPanel;
import org.esa.snap.runtime.Config;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.Lookup;

public abstract class DefaultConfigController
extends OptionsPanelController {
    private PreferencesPanel panel;
    private BindingContext bindingContext;

    protected abstract PropertySet createPropertySet();

    protected JPanel createPanel(BindingContext context) {
        Assert.state((boolean)this.isInitialised());
        return new PreferencesPanel(null, this.bindingContext).getComponent();
    }

    protected void configure(BindingContext context) {
    }

    protected BindingContext getBindingContext() {
        return this.bindingContext;
    }

    protected final PropertyContainer createPropertySet(Object bean) {
        return PropertyContainer.createObjectBacked((Object)bean, field -> {
            Class<Preference> annotationClass = Preference.class;
            Preference annotation = field.getAnnotation(annotationClass);
            if (annotation == null) {
                throw new IllegalStateException("Field '" + field.getName() + "' must be annotated with '" + annotationClass.getSimpleName() + "'.");
            }
            String label = annotation.label();
            String key = annotation.key();
            Object[] valueSet = annotation.valueSet();
            String valueRange = annotation.interval();
            String description = annotation.description();
            Validator validator = this.createValidator(annotation.validatorClass());
            Assert.state((boolean)StringUtils.isNotNullAndNotEmpty((String)label), (String)("Label of field '" + field.getName() + "' must not be null or empty."));
            Assert.state((boolean)StringUtils.isNotNullAndNotEmpty((String)key), (String)("Key of field '" + field.getName() + "' must not be null or empty."));
            boolean isDeprecated = field.getAnnotation(Deprecated.class) != null;
            PropertyDescriptor valueDescriptor = new PropertyDescriptor(key, field.getType());
            valueDescriptor.setDeprecated(isDeprecated);
            valueDescriptor.setAttribute("key", (Object)key);
            valueDescriptor.setAttribute("displayName", (Object)label);
            valueDescriptor.setAttribute("configName", (Object)annotation.config());
            valueDescriptor.setAttribute("propertyValidator", (Object)validator);
            valueDescriptor.setDescription(description);
            if (valueSet.length > 0) {
                valueDescriptor.setValueSet(new ValueSet(valueSet));
            }
            if (StringUtils.isNotNullAndNotEmpty((String)valueRange)) {
                valueDescriptor.setValueRange(ValueRange.parseValueRange((String)valueRange));
            }
            return valueDescriptor;
        });
    }

    public void update() {
        if (this.isInitialised()) {
            for (Property property : this.bindingContext.getPropertySet().getProperties()) {
                String key = property.getDescriptor().getAttribute("key").toString();
                String preferencesValue = this.getPreferences(property.getDescriptor()).get(key, null);
                if (preferencesValue == null) continue;
                try {
                    property.setValueFromText(preferencesValue);
                    SystemUtils.LOG.fine(String.format("Bean property value change: %s = %s", property.getName(), property.getValueAsText()));
                }
                catch (ValidationException e) {
                    SystemUtils.LOG.severe("Failed to set bean value from preferences: " + e.getMessage());
                }
            }
        }
    }

    public void applyChanges() {
        if (this.isInitialised()) {
            HashSet<Preferences> set = new HashSet<Preferences>();
            for (Property property : this.bindingContext.getPropertySet().getProperties()) {
                String key = property.getDescriptor().getAttribute("key").toString();
                String value = property.getValueAsText();
                Preferences preferences = this.getPreferences(property.getDescriptor());
                preferences.put(key, value);
                set.add(preferences);
                SystemUtils.LOG.fine(String.format("Preferences value change: %s = %s", key, preferences.get(key, null)));
            }
            for (Preferences preferences : set) {
                try {
                    preferences.flush();
                }
                catch (BackingStoreException e) {
                    SnapApp.getDefault().handleError("Failed to store user preferences.", e);
                }
            }
            this.setChanged(false);
        }
    }

    public void cancel() {
        if (this.isInitialised()) {
            this.setChanged(false);
        }
    }

    public boolean isValid() {
        if (!this.isInitialised()) {
            return false;
        }
        for (Property property : this.bindingContext.getPropertySet().getProperties()) {
            Validator validator = (Validator)property.getDescriptor().getAttribute("propertyValidator");
            try {
                validator.validateValue(property, property.getValue());
            }
            catch (ValidationException e) {
                return false;
            }
        }
        return true;
    }

    protected void setChanged(boolean changed) {
        this.panel.setChanged(changed);
    }

    public boolean isChanged() {
        return this.isInitialised() && this.panel.isChanged();
    }

    public JComponent getComponent(Lookup lookup) {
        if (!this.isInitialised()) {
            this.initialize();
        }
        return this.panel.getComponent();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.bindingContext != null) {
            this.bindingContext.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.bindingContext != null) {
            this.bindingContext.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected boolean isInitialised() {
        return this.bindingContext != null;
    }

    private void initialize() {
        this.bindingContext = new BindingContext(this.createPropertySet());
        this.panel = new PreferencesPanel(this.createPanel(this.bindingContext), this.bindingContext);
        this.panel.getComponent();
        this.configure(this.bindingContext);
    }

    private Preferences getPreferences(PropertyDescriptor propertyDescriptor) {
        String configName;
        Object configNameValue = propertyDescriptor.getAttribute("configName");
        String string = configName = configNameValue != null ? configNameValue.toString().trim() : null;
        if (configName == null || configName.isEmpty()) {
            return SnapApp.getDefault().getPreferences();
        }
        return Config.instance((String)configName).load().preferences();
    }

    private Validator createValidator(Class<? extends Validator> validatorClass) {
        Validator validator;
        try {
            validator = validatorClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
        return validator;
    }
}

