/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.placemark;

import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlacemarkGroup;
import org.esa.snap.core.datamodel.Product;

class UndoablePlacemarkActionFactory {
    UndoablePlacemarkActionFactory() {
    }

    static UndoablePlacemarkAction createUndoablePlacemarkRemoval(Product product, List<Placemark> placemarks, PlacemarkDescriptor placemarkDescriptor) {
        return new UndoablePlacemarkAction(new UndoablePlacemarkRemovalStrategy(product, placemarks, placemarkDescriptor));
    }

    static UndoablePlacemarkAction createUndoablePlacemarkInsertion(Product product, Placemark placemark, PlacemarkDescriptor placemarkDescriptor) {
        return new UndoablePlacemarkAction(new UndoablePlacemarkInsertionStrategy(product, placemark, placemarkDescriptor));
    }

    static UndoablePlacemarkAction createUndoablePlacemarkCopying(Product product, Placemark placemark, PlacemarkDescriptor placemarkDescriptor) {
        return new UndoablePlacemarkAction(new UndoablePlacemarkCopyingStrategy(product, placemark, placemarkDescriptor));
    }

    static UndoablePlacemarkAction createUndoablePlacemarkEditing(Product product, Placemark oldPlacemark, Placemark newPlacemark, PlacemarkDescriptor placemarkDescriptor) {
        return new UndoablePlacemarkAction(new UndoablePlacemarkEditingStrategy(product, oldPlacemark, newPlacemark, placemarkDescriptor));
    }

    private static class UndoablePlacemarkRemovalStrategy
    implements UndoablePlacemarkActionStrategy {
        private final List<Placemark> placemarks;
        private Product product;
        private PlacemarkDescriptor placemarkDescriptor;

        UndoablePlacemarkRemovalStrategy(Product product, List<Placemark> placemarks, PlacemarkDescriptor placemarkDescriptor) {
            this.product = product;
            this.placemarks = placemarks;
            this.placemarkDescriptor = placemarkDescriptor;
        }

        @Override
        public void undo() {
            PlacemarkGroup placemarkGroup = this.placemarkDescriptor.getPlacemarkGroup(this.product);
            for (Placemark placemark : this.placemarks) {
                placemarkGroup.add(placemark);
            }
        }

        @Override
        public void redo() {
            PlacemarkGroup placemarkGroup = this.placemarkDescriptor.getPlacemarkGroup(this.product);
            for (Placemark placemark : this.placemarks) {
                placemarkGroup.remove(placemark);
            }
        }

        @Override
        public String getPresentationName() {
            return "Removing " + this.placemarkDescriptor.getRoleLabel();
        }
    }

    private static class UndoablePlacemarkEditingStrategy
    implements UndoablePlacemarkActionStrategy {
        private final Placemark oldPlacemark;
        private Product product;
        private Placemark newPlacemark;
        private Placemark placemarkInView;
        private PlacemarkDescriptor placemarkDescriptor;

        UndoablePlacemarkEditingStrategy(Product product, Placemark oldPlacemark, Placemark newPlacemark, PlacemarkDescriptor placemarkDescriptor) {
            this.product = product;
            this.oldPlacemark = oldPlacemark;
            this.newPlacemark = Placemark.createPointPlacemark((PlacemarkDescriptor)newPlacemark.getDescriptor(), (String)newPlacemark.getName(), (String)newPlacemark.getLabel(), (String)newPlacemark.getDescription(), (PixelPos)newPlacemark.getPixelPos(), (GeoPos)newPlacemark.getGeoPos(), (GeoCoding)newPlacemark.getProduct().getSceneGeoCoding());
            this.placemarkInView = newPlacemark;
            this.placemarkDescriptor = placemarkDescriptor;
        }

        @Override
        public void undo() {
            this.placemarkInView.setName(this.oldPlacemark.getName());
            this.placemarkInView.setLabel(this.oldPlacemark.getLabel());
            this.placemarkInView.setDescription(this.oldPlacemark.getDescription());
            this.placemarkInView.setGeoPos(this.oldPlacemark.getGeoPos());
            this.placemarkInView.setStyleCss(this.oldPlacemark.getStyleCss());
        }

        @Override
        public void redo() {
            this.placemarkInView.setName(this.newPlacemark.getName());
            this.placemarkInView.setLabel(this.newPlacemark.getLabel());
            this.placemarkInView.setDescription(this.newPlacemark.getDescription());
            this.placemarkInView.setGeoPos(this.newPlacemark.getGeoPos());
            this.placemarkInView.setStyleCss(this.newPlacemark.getStyleCss());
        }

        @Override
        public String getPresentationName() {
            return "Editing " + this.placemarkDescriptor.getRoleLabel();
        }
    }

    private static class UndoablePlacemarkCopyingStrategy
    implements UndoablePlacemarkActionStrategy {
        private Product product;
        private Placemark newPlacemark;
        private PlacemarkDescriptor placemarkDescriptor;

        UndoablePlacemarkCopyingStrategy(Product product, Placemark newPlacemark, PlacemarkDescriptor placemarkDescriptor) {
            this.product = product;
            this.newPlacemark = newPlacemark;
            this.placemarkDescriptor = placemarkDescriptor;
        }

        @Override
        public void undo() {
            this.placemarkDescriptor.getPlacemarkGroup(this.product).remove(this.newPlacemark);
        }

        @Override
        public void redo() {
            this.placemarkDescriptor.getPlacemarkGroup(this.product).add(this.newPlacemark);
        }

        @Override
        public String getPresentationName() {
            return "Copying " + this.placemarkDescriptor.getRoleLabel();
        }
    }

    private static class UndoablePlacemarkInsertionStrategy
    implements UndoablePlacemarkActionStrategy {
        private Product product;
        private Placemark newPlacemark;
        private PlacemarkDescriptor placemarkDescriptor;

        UndoablePlacemarkInsertionStrategy(Product product, Placemark newPlacemark, PlacemarkDescriptor placemarkDescriptor) {
            this.product = product;
            this.newPlacemark = newPlacemark;
            this.placemarkDescriptor = placemarkDescriptor;
        }

        @Override
        public void undo() {
            this.placemarkDescriptor.getPlacemarkGroup(this.product).remove(this.newPlacemark);
        }

        @Override
        public void redo() {
            this.placemarkDescriptor.getPlacemarkGroup(this.product).add(this.newPlacemark);
        }

        @Override
        public String getPresentationName() {
            return "Insert " + this.placemarkDescriptor.getRoleLabel();
        }
    }

    private static interface UndoablePlacemarkActionStrategy {
        public void undo();

        public void redo();

        public String getPresentationName();
    }

    private static class UndoablePlacemarkAction
    extends AbstractUndoableEdit {
        private UndoablePlacemarkActionStrategy strategy;

        public UndoablePlacemarkAction(UndoablePlacemarkActionStrategy strategy) {
            this.strategy = strategy;
        }

        @Override
        public void undo() {
            super.undo();
            this.strategy.undo();
        }

        @Override
        public void redo() {
            super.redo();
            this.strategy.redo();
        }

        @Override
        public String getPresentationName() {
            return this.strategy.getPresentationName();
        }

        @Override
        public void die() {
            super.die();
            this.strategy = null;
        }
    }
}

