/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.placemark;

import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureCollection;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import java.awt.Color;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.product.ProductSceneView;
import org.esa.snap.ui.product.SimpleFeaturePointFigure;
import org.opengis.feature.simple.SimpleFeature;

public class PlacemarkUtils {
    public static Color getPlacemarkColor(Placemark placemark) {
        return PlacemarkUtils.getPlacemarkColor(placemark, SnapApp.getDefault().getSelectedProductSceneView());
    }

    public static Color getPlacemarkColor(Placemark placemark, ProductSceneView view) {
        Figure[] figures;
        String styleCss = placemark.getStyleCss();
        if (styleCss.contains(DefaultFigureStyle.FILL_COLOR.getName())) {
            return DefaultFigureStyle.createFromCss((String)styleCss).getFillColor();
        }
        for (Figure figure : figures = PlacemarkUtils.getFigures(view)) {
            SimpleFeature simpleFeature;
            if (!(figure instanceof SimpleFeaturePointFigure) || !(simpleFeature = ((SimpleFeaturePointFigure)figure).getSimpleFeature()).getID().equals(placemark.getName())) continue;
            return figure.getNormalStyle().getFillColor();
        }
        return Color.BLUE;
    }

    private static Figure[] getFigures(ProductSceneView view) {
        if (view == null) {
            return new Figure[0];
        }
        FigureCollection figureCollection = view.getFigureEditor().getFigureCollection();
        return figureCollection.getFigures();
    }
}

