/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.mask;

import java.awt.Color;
import javax.swing.table.AbstractTableModel;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.RasterDataNode;

class MaskTableModel
extends AbstractTableModel {
    private static final int IDX_VISIBILITY = 0;
    private static final int IDX_NAME = 1;
    private static final int IDX_TYPE = 2;
    private static final int IDX_COLOR = 3;
    private static final int IDX_TRANSPARENCY = 4;
    private static final int IDX_DESCRIPTION = 5;
    private static final int[] IDXS_MODE_MANAG_NO_BAND = new int[]{1, 2, 3, 4, 5};
    private static final int[] IDXS_MODE_MANAG_BAND = new int[]{0, 1, 2, 3, 4, 5};
    private static final int[] IDXS_MODE_NO_MANAG_NO_BAND = new int[]{1, 3, 4, 5};
    private static final int[] IDXS_MODE_NO_MANAG_BAND = new int[]{0, 1, 3, 4, 5};
    private static final Class[] COLUMN_CLASSES = new Class[]{Boolean.class, String.class, String.class, Color.class, Double.class, String.class};
    private static final String[] COLUMN_NAMES = new String[]{"Visibility", "Name", "Type", "Colour", "Transparency", "Description"};
    private static final boolean[] COLUMN_EDITABLE_STATES = new boolean[]{true, true, false, true, true, true};
    static int[] INITIAL_COLUMN_WIDTHS = new int[]{24, 60, 60, 60, 40, 320};
    private final MaskPNL maskPNL;
    private final boolean inManagmentMode;
    private int[] modeIdxs;
    private Product product;
    private RasterDataNode visibleBand;
    private int[] columnWidths;

    MaskTableModel(boolean inManagmentMode) {
        this.inManagmentMode = inManagmentMode;
        this.updateModeIdxs();
        this.maskPNL = new MaskPNL();
        this.columnWidths = (int[])INITIAL_COLUMN_WIDTHS.clone();
    }

    Product getProduct() {
        return this.product;
    }

    void setProduct(Product product, RasterDataNode visibleBand) {
        if (this.product != product) {
            if (this.product != null) {
                this.product.removeProductNodeListener((ProductNodeListener)this.maskPNL);
            }
            this.product = product;
            if (this.product != null) {
                this.product.addProductNodeListener((ProductNodeListener)this.maskPNL);
            }
        }
        this.visibleBand = visibleBand;
        this.updateModeIdxs();
        this.fireTableStructureChanged();
    }

    RasterDataNode getVisibleBand() {
        return this.visibleBand;
    }

    Mask getMask(int selectedRow) {
        ProductNodeGroup<Mask> maskGroup = this.getMaskGroup();
        return (Mask)maskGroup.get(selectedRow);
    }

    int getMaskIndex(String name) {
        return this.getMaskGroup().indexOf(name);
    }

    void addMask(Mask mask) {
        this.getProduct().getMaskGroup().add((ProductNode)mask);
        this.makeMaskVisible(mask);
        this.fireTableDataChanged();
    }

    public void addMask(Mask mask, int index) {
        this.getProduct().getMaskGroup().add(index, (ProductNode)mask);
        this.makeMaskVisible(mask);
        this.fireTableDataChanged();
    }

    private void makeMaskVisible(Mask mask) {
        if (this.visibleBand != null) {
            this.visibleBand.getOverlayMaskGroup().add((ProductNode)mask);
        }
    }

    void removeMask(Mask mask) {
        this.getProduct().getMaskGroup().remove((ProductNode)mask);
        this.fireTableDataChanged();
    }

    private ProductNodeGroup<Mask> getMaskGroup() {
        if (this.product == null) {
            return null;
        }
        if (this.visibleBand == null) {
            return this.product.getMaskGroup();
        }
        ProductNodeGroup visibleMasks = new ProductNodeGroup("Masks for " + this.visibleBand.getName());
        ProductNodeGroup maskGroup = this.product.getMaskGroup();
        for (int i = 0; i < maskGroup.getNodeCount(); ++i) {
            Mask mask = (Mask)maskGroup.get(i);
            if (mask.getRasterWidth() != this.visibleBand.getRasterWidth() || mask.getRasterHeight() != this.visibleBand.getRasterHeight()) continue;
            visibleMasks.add((ProductNode)mask);
        }
        return visibleMasks;
    }

    boolean isInManagmentMode() {
        return this.product != null && this.inManagmentMode;
    }

    int getVisibilityColumnIndex() {
        for (int i = 0; i < this.modeIdxs.length; ++i) {
            if (this.modeIdxs[i] != 0) continue;
            return i;
        }
        return -1;
    }

    void setPreferredColumnWidth(int columnIndex, int width) {
        this.columnWidths[this.modeIdxs[columnIndex]] = width;
    }

    int getPreferredColumnWidth(int columnIndex) {
        return this.columnWidths[this.modeIdxs[columnIndex]];
    }

    private void updateModeIdxs() {
        this.modeIdxs = this.inManagmentMode ? (this.visibleBand != null ? IDXS_MODE_MANAG_BAND : IDXS_MODE_MANAG_NO_BAND) : (this.visibleBand != null ? IDXS_MODE_NO_MANAG_BAND : IDXS_MODE_NO_MANAG_NO_BAND);
    }

    void clear() {
        this.setProduct(null, null);
    }

    public Class getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[this.modeIdxs[columnIndex]];
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[this.modeIdxs[columnIndex]];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return COLUMN_EDITABLE_STATES[this.modeIdxs[columnIndex]];
    }

    @Override
    public int getColumnCount() {
        return this.modeIdxs.length;
    }

    @Override
    public int getRowCount() {
        ProductNodeGroup<Mask> maskGroup = this.getMaskGroup();
        return maskGroup != null ? maskGroup.getNodeCount() : 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ProductNodeGroup<Mask> maskGroup = this.getMaskGroup();
        Mask mask = (Mask)maskGroup.get(rowIndex);
        int column = this.modeIdxs[columnIndex];
        if (column == 0) {
            if (this.visibleBand.getOverlayMaskGroup().contains((ProductNode)mask)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (column == 1) {
            return mask.getName();
        }
        if (column == 2) {
            return mask.getImageType().getName();
        }
        if (column == 3) {
            return mask.getImageColor();
        }
        if (column == 4) {
            return mask.getImageTransparency();
        }
        if (column == 5) {
            return mask.getDescription();
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ProductNodeGroup<Mask> maskGroup = this.getMaskGroup();
        Mask mask = (Mask)maskGroup.get(rowIndex);
        int column = this.modeIdxs[columnIndex];
        if (column == 0) {
            boolean visible = (Boolean)aValue;
            ProductNodeGroup overlayMaskGroup = this.visibleBand.getOverlayMaskGroup();
            if (visible) {
                if (!overlayMaskGroup.contains((ProductNode)mask)) {
                    overlayMaskGroup.add((ProductNode)mask);
                }
            } else {
                overlayMaskGroup.remove((ProductNode)mask);
            }
            this.visibleBand.fireImageInfoChanged();
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else if (column == 1) {
            mask.setName((String)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        } else if (column != 2) {
            if (column == 3) {
                mask.setImageColor((Color)aValue);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            } else if (column == 4) {
                mask.setImageTransparency(((Double)aValue).doubleValue());
                this.fireTableCellUpdated(rowIndex, columnIndex);
            } else if (column == 5) {
                mask.setDescription((String)aValue);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }
    }

    private class MaskPNL
    extends ProductNodeListenerAdapter {
        private MaskPNL() {
        }

        public void nodeAdded(ProductNodeEvent event) {
            this.processEvent(event);
        }

        public void nodeRemoved(ProductNodeEvent event) {
            this.processEvent(event);
        }

        public void nodeChanged(ProductNodeEvent event) {
            this.processEvent(event);
        }

        private void processEvent(ProductNodeEvent event) {
            if (event.getSourceNode() instanceof Mask) {
                MaskTableModel.this.fireTableDataChanged();
            } else if (event.getSourceNode() instanceof Placemark) {
                MaskTableModel.this.fireTableDataChanged();
            } else if (event.getSourceNode() == MaskTableModel.this.visibleBand && event.getPropertyName() != null && event.getPropertyName().equals("imageInfo")) {
                MaskTableModel.this.fireTableDataChanged();
            }
        }
    }
}

