/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.shapefile;

import com.bc.ceres.swing.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.layermanager.layersrc.shapefile.ShapefileAssistantPage3;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.crs.CrsForm;
import org.esa.snap.ui.crs.CrsSelectionPanel;
import org.esa.snap.ui.crs.CustomCrsForm;
import org.esa.snap.ui.crs.PredefinedCrsForm;
import org.esa.snap.ui.crs.ProductCrsForm;
import org.esa.snap.ui.layer.AbstractLayerSourceAssistantPage;
import org.esa.snap.ui.layer.LayerSourcePageContext;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class ShapefileAssistantPage2
extends AbstractLayerSourceAssistantPage {
    private CrsSelectionPanel crsSelectionPanel;

    ShapefileAssistantPage2() {
        super("Define CRS");
    }

    public Component createPageComponent() {
        AppContext snapContext = SnapApp.getDefault().getAppContext();
        ProductCrsForm productCrsForm = new ProductCrsForm(snapContext, SnapApp.getDefault().getSelectedProduct(SnapApp.SelectionSourceHint.VIEW));
        CustomCrsForm customCrsForm = new CustomCrsForm(snapContext);
        PredefinedCrsForm predefinedCrsForm = new PredefinedCrsForm(snapContext);
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableWeightY(Double.valueOf(1.0));
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        JPanel pageComponent = new JPanel((LayoutManager)tableLayout);
        JLabel label = new JLabel("<html><b>No CRS found for ESRI Shapefile. Please specify.</b>");
        this.crsSelectionPanel = new CrsSelectionPanel(new CrsForm[]{productCrsForm, customCrsForm, predefinedCrsForm});
        pageComponent.add(label);
        pageComponent.add((Component)this.crsSelectionPanel);
        return pageComponent;
    }

    public boolean validatePage() {
        try {
            this.crsSelectionPanel.getCrs(ProductUtils.getCenterGeoPos((Product)SnapApp.getDefault().getSelectedProduct(SnapApp.SelectionSourceHint.VIEW)));
        }
        catch (FactoryException ignored) {
            return false;
        }
        return true;
    }

    public boolean hasNextPage() {
        return true;
    }

    public AbstractLayerSourceAssistantPage getNextPage() {
        LayerSourcePageContext context = this.getContext();
        try {
            Product product = SnapApp.getDefault().getSelectedProduct(SnapApp.SelectionSourceHint.VIEW);
            GeoPos referencePos = ProductUtils.getCenterGeoPos((Product)product);
            CoordinateReferenceSystem crs = this.crsSelectionPanel.getCrs(referencePos);
            context.setPropertyValue("featureCollectionCrs", (Object)crs);
            return new ShapefileAssistantPage3();
        }
        catch (FactoryException e) {
            e.printStackTrace();
            context.showErrorDialog("Could not create CRS:\n" + e.getMessage());
            return null;
        }
    }

    public boolean canFinish() {
        return false;
    }
}

