/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.shapefile;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.layermanager.layersrc.FilePathListCellRenderer;
import org.esa.snap.rcp.layermanager.layersrc.HistoryComboBoxModel;
import org.esa.snap.rcp.layermanager.layersrc.shapefile.ShapefileAssistantPage2;
import org.esa.snap.rcp.layermanager.layersrc.shapefile.ShapefileAssistantPage3;
import org.esa.snap.ui.FileHistory;
import org.esa.snap.ui.UserInputHistory;
import org.esa.snap.ui.layer.AbstractLayerSourceAssistantPage;
import org.esa.snap.ui.layer.LayerSourcePageContext;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class ShapefileAssistantPage1
extends AbstractLayerSourceAssistantPage {
    private static final String PROPERTY_LAST_FILE_PREFIX = "ShapefileAssistant.Shapefile.history";
    private static final String PROPERTY_LAST_DIR = "ShapefileAssistant.Shapefile.lastDir";
    private HistoryComboBoxModel fileHistoryModel;

    ShapefileAssistantPage1() {
        super("Select ESRI Shapefile");
    }

    public Component createPageComponent() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.gridwidth = 2;
        panel.add((Component)new JLabel("Path to ESRI Shapefile (*.shp):"), gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.gridwidth = 1;
        final LayerSourcePageContext context = this.getContext();
        Preferences preferences = SnapApp.getDefault().getPreferences();
        FileHistory fileHistory = new FileHistory(5, PROPERTY_LAST_FILE_PREFIX);
        fileHistory.initBy(preferences);
        this.fileHistoryModel = new HistoryComboBoxModel((UserInputHistory)fileHistory);
        JComboBox<Object> shapefileBox = new JComboBox<Object>(this.fileHistoryModel);
        shapefileBox.setRenderer(new FilePathListCellRenderer(80));
        shapefileBox.setEditable(true);
        shapefileBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                context.updateState();
            }
        });
        panel.add(shapefileBox, gbc);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 1;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        JButton button = new JButton("...");
        button.addActionListener(new ShpaeFilechooserActionListener());
        panel.add((Component)button, gbc);
        return panel;
    }

    public boolean validatePage() {
        if (this.fileHistoryModel != null) {
            String path = (String)this.fileHistoryModel.getSelectedItem();
            return path != null && !path.trim().isEmpty();
        }
        return false;
    }

    public boolean hasNextPage() {
        return true;
    }

    public AbstractLayerSourceAssistantPage getNextPage() {
        LayerSourcePageContext context = this.getContext();
        this.fileHistoryModel.getHistory().copyInto(SnapApp.getDefault().getPreferences());
        String path = (String)this.fileHistoryModel.getSelectedItem();
        if (path != null && !path.trim().isEmpty()) {
            try {
                FeatureCollection fc;
                CoordinateReferenceSystem featureCrs;
                String oldPath = (String)context.getPropertyValue("fileName");
                if (!path.equals(oldPath)) {
                    context.setPropertyValue("fileName", (Object)path);
                    URL fileUrl = new File(path).toURI().toURL();
                    FeatureSource featureSource = FeatureUtils.getFeatureSource((URL)fileUrl);
                    context.setPropertyValue("featureCollection", (Object)featureSource.getFeatures());
                    context.setPropertyValue("selectedStyle", null);
                    context.setPropertyValue("styles", null);
                    context.setPropertyValue("featureCollectionCrs", null);
                }
                if ((featureCrs = (fc = (FeatureCollection)context.getPropertyValue("featureCollection")).getSchema().getCoordinateReferenceSystem()) == null) {
                    return new ShapefileAssistantPage2();
                }
                context.setPropertyValue("featureCollectionCrs", (Object)featureCrs);
                return new ShapefileAssistantPage3();
            }
            catch (Exception e) {
                e.printStackTrace();
                context.showErrorDialog("Failed to load ESRI shapefile:\n" + e.getMessage());
            }
        }
        return null;
    }

    public boolean canFinish() {
        return false;
    }

    private class ShpaeFilechooserActionListener
    implements ActionListener {
        private ShpaeFilechooserActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setAcceptAllFileFilterUsed(false);
            FileNameExtensionFilter shapefileFilter = new FileNameExtensionFilter("ESRI Shapefile", "shp");
            fileChooser.addChoosableFileFilter(shapefileFilter);
            fileChooser.setFileFilter(shapefileFilter);
            File lastDir = this.getLastDirectory();
            fileChooser.setCurrentDirectory(lastDir);
            LayerSourcePageContext pageContext = ShapefileAssistantPage1.this.getContext();
            fileChooser.showOpenDialog(pageContext.getWindow());
            if (fileChooser.getSelectedFile() != null) {
                String filePath = fileChooser.getSelectedFile().getPath();
                ShapefileAssistantPage1.this.fileHistoryModel.setSelectedItem(filePath);
                Preferences preferences = SnapApp.getDefault().getPreferences();
                preferences.put(ShapefileAssistantPage1.PROPERTY_LAST_DIR, fileChooser.getCurrentDirectory().getAbsolutePath());
                pageContext.updateState();
            }
        }

        private File getLastDirectory() {
            Preferences preferences = SnapApp.getDefault().getPreferences();
            String dirPath = preferences.get(ShapefileAssistantPage1.PROPERTY_LAST_DIR, System.getProperty("user.home"));
            File lastDir = new File(dirPath);
            if (!lastDir.isDirectory()) {
                lastDir = new File(System.getProperty("user.home"));
            }
            return lastDir;
        }
    }
}

