/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.editors;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureEditor;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import com.bc.ceres.swing.figure.support.NamedSymbol;
import com.bc.ceres.swing.selection.AbstractSelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.atomic.AtomicBoolean;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.ObjectUtils;
import org.esa.snap.ui.layer.AbstractLayerConfigurationEditor;
import org.esa.snap.ui.product.ProductSceneView;
import org.esa.snap.ui.product.SimpleFeatureFigure;
import org.esa.snap.ui.product.VectorDataFigureEditor;
import org.esa.snap.ui.product.VectorDataLayer;
import org.openide.util.Utilities;

public class VectorDataLayerEditor
extends AbstractLayerConfigurationEditor {
    private static final String FILL_COLOR_NAME = DefaultFigureStyle.FILL_COLOR.getName();
    private static final String FILL_OPACITY_NAME = DefaultFigureStyle.FILL_OPACITY.getName();
    private static final String STROKE_COLOR_NAME = DefaultFigureStyle.STROKE_COLOR.getName();
    private static final String STROKE_OPACITY_NAME = DefaultFigureStyle.STROKE_OPACITY.getName();
    private static final String STROKE_WIDTH_NAME = DefaultFigureStyle.STROKE_WIDTH.getName();
    private static final String SYMBOL_NAME_NAME = DefaultFigureStyle.SYMBOL_NAME.getName();
    private static final SimpleFeatureFigure[] NO_SIMPLE_FEATURE_FIGURES = new SimpleFeatureFigure[0];
    private static final ValueSet SYMBOL_VALUE_SET = new ValueSet((Object[])new String[]{NamedSymbol.PLUS.getName(), NamedSymbol.CROSS.getName(), NamedSymbol.STAR.getName(), NamedSymbol.SQUARE.getName(), NamedSymbol.CIRCLE.getName(), NamedSymbol.PIN.getName()});
    private final SelectionChangeHandler selectionChangeHandler = new SelectionChangeHandler();
    private final StyleUpdater styleUpdater = new StyleUpdater();
    private final AtomicBoolean isAdjusting = new AtomicBoolean(false);

    protected void addEditablePropertyDescriptors() {
        SimpleFeatureFigure[] figures = this.getFigures(false);
        PropertyDescriptor fillColor = new PropertyDescriptor(DefaultFigureStyle.FILL_COLOR);
        fillColor.setDefaultValue(this.getCommonStylePropertyValue((Figure[])figures, FILL_COLOR_NAME));
        this.addPropertyDescriptor(fillColor);
        PropertyDescriptor fillOpacity = new PropertyDescriptor(DefaultFigureStyle.FILL_OPACITY);
        fillOpacity.setDefaultValue(this.getCommonStylePropertyValue((Figure[])figures, FILL_OPACITY_NAME));
        this.addPropertyDescriptor(fillOpacity);
        PropertyDescriptor strokeColor = new PropertyDescriptor(DefaultFigureStyle.STROKE_COLOR);
        strokeColor.setDefaultValue(this.getCommonStylePropertyValue((Figure[])figures, STROKE_COLOR_NAME));
        this.addPropertyDescriptor(strokeColor);
        PropertyDescriptor strokeOpacity = new PropertyDescriptor(DefaultFigureStyle.STROKE_OPACITY);
        strokeOpacity.setDefaultValue(this.getCommonStylePropertyValue((Figure[])figures, STROKE_OPACITY_NAME));
        this.addPropertyDescriptor(strokeOpacity);
        PropertyDescriptor strokeWidth = new PropertyDescriptor(DefaultFigureStyle.STROKE_WIDTH);
        strokeWidth.setDefaultValue(this.getCommonStylePropertyValue((Figure[])figures, STROKE_WIDTH_NAME));
        this.addPropertyDescriptor(strokeWidth);
        PropertyDescriptor symbolName = new PropertyDescriptor(DefaultFigureStyle.SYMBOL_NAME);
        symbolName.setDefaultValue(this.getCommonStylePropertyValue((Figure[])figures, SYMBOL_NAME_NAME));
        symbolName.setValueSet(SYMBOL_VALUE_SET);
        symbolName.setNotNull(false);
        this.addPropertyDescriptor(symbolName);
        this.getBindingContext().bindEnabledState(SYMBOL_NAME_NAME, false, SYMBOL_NAME_NAME, null);
    }

    public void handleLayerContentChanged() {
        if (this.isAdjusting.compareAndSet(false, true)) {
            try {
                this.updateProperties(this.getFigures(false), this.getBindingContext());
            }
            finally {
                this.isAdjusting.set(false);
            }
        }
    }

    public void handleEditorAttached() {
        FigureEditor figureEditor = this.getFigureEditor();
        if (figureEditor != null) {
            figureEditor.addSelectionChangeListener((SelectionChangeListener)this.selectionChangeHandler);
        }
        this.getBindingContext().addPropertyChangeListener((PropertyChangeListener)this.styleUpdater);
    }

    public void handleEditorDetached() {
        FigureEditor figureEditor = this.getFigureEditor();
        if (figureEditor != null) {
            figureEditor.removeSelectionChangeListener((SelectionChangeListener)this.selectionChangeHandler);
        }
        this.getBindingContext().removePropertyChangeListener((PropertyChangeListener)this.styleUpdater);
    }

    private VectorDataNode getVectorDataNode() {
        FigureEditor figureEditor = this.getFigureEditor();
        if (figureEditor instanceof VectorDataFigureEditor) {
            VectorDataFigureEditor editor = (VectorDataFigureEditor)figureEditor;
            return editor.getVectorDataNode();
        }
        return null;
    }

    protected void updateProperties(SimpleFeatureFigure[] selectedFigures, BindingContext bindingContext) {
        this.updateProperty(bindingContext, FILL_COLOR_NAME, this.getCommonStylePropertyValue((Figure[])selectedFigures, FILL_COLOR_NAME));
        this.updateProperty(bindingContext, FILL_OPACITY_NAME, this.getCommonStylePropertyValue((Figure[])selectedFigures, FILL_OPACITY_NAME));
        this.updateProperty(bindingContext, STROKE_COLOR_NAME, this.getCommonStylePropertyValue((Figure[])selectedFigures, STROKE_COLOR_NAME));
        this.updateProperty(bindingContext, STROKE_OPACITY_NAME, this.getCommonStylePropertyValue((Figure[])selectedFigures, STROKE_OPACITY_NAME));
        this.updateProperty(bindingContext, STROKE_WIDTH_NAME, this.getCommonStylePropertyValue((Figure[])selectedFigures, STROKE_WIDTH_NAME));
        Object styleProperty = this.getCommonStylePropertyValue((Figure[])selectedFigures, SYMBOL_NAME_NAME);
        if (styleProperty != null) {
            this.updateProperty(bindingContext, SYMBOL_NAME_NAME, styleProperty);
        }
    }

    protected void updateProperty(BindingContext bindingContext, String propertyName, Object styleValue) {
        Object oldValue;
        PropertySet propertySet = bindingContext.getPropertySet();
        if (propertySet.isPropertyDefined(propertyName) && !ObjectUtils.equalObjects((Object)(oldValue = propertySet.getValue(propertyName)), (Object)styleValue)) {
            propertySet.setValue(propertyName, styleValue);
        }
    }

    protected void updateStyle(BindingContext bindingContext, String propertyName, FigureStyle style) {
        Object value = bindingContext.getPropertySet().getValue(propertyName);
        if (value != null) {
            style.setValue(propertyName, value);
        }
    }

    private void updateColorAndOpacity(String colorPropertyName, String opacityPropertyName) {
        boolean isTransparent;
        PropertySet propertySet = this.getBindingContext().getPropertySet();
        Color color = (Color)propertySet.getValue(colorPropertyName);
        boolean bl = isTransparent = color != null && color.getAlpha() == 0;
        if (isTransparent) {
            propertySet.setValue(opacityPropertyName, (Object)0.0);
        } else {
            Double transparency = (Double)propertySet.getValue(opacityPropertyName);
            if (transparency != null && transparency == 0.0) {
                propertySet.setValue(opacityPropertyName, (Object)0.5);
            }
        }
        this.getBindingContext().setComponentsEnabled(opacityPropertyName, !isTransparent);
    }

    private Object getCommonStylePropertyValue(Figure[] figures, String propertyName) {
        Object commonValue = null;
        for (Figure figure : figures) {
            Object value = figure.getNormalStyle().getValue(propertyName);
            if (commonValue == null) {
                commonValue = value;
                continue;
            }
            if (commonValue.equals(value)) continue;
            return null;
        }
        return commonValue;
    }

    private VectorDataLayer getVectorDataLayer() {
        Layer selectedLayer = this.getSelectedLayer();
        if (selectedLayer instanceof VectorDataLayer) {
            return (VectorDataLayer)selectedLayer;
        }
        return null;
    }

    private ProductSceneView getSelectedProductSceneView() {
        return (ProductSceneView)Utilities.actionsGlobalContext().lookup(ProductSceneView.class);
    }

    private FigureEditor getFigureEditor() {
        ProductSceneView view = this.getSelectedProductSceneView();
        return view != null ? view.getFigureEditor() : null;
    }

    private Layer getSelectedLayer() {
        ProductSceneView view = this.getSelectedProductSceneView();
        return view != null ? view.getSelectedLayer() : null;
    }

    private SimpleFeatureFigure[] getFigures(boolean selectedOnly) {
        ProductSceneView sceneView = this.getSelectedProductSceneView();
        SimpleFeatureFigure[] featureFigures = sceneView.getFeatureFigures(selectedOnly);
        if (featureFigures.length > 0) {
            return featureFigures;
        }
        return NO_SIMPLE_FEATURE_FIGURES;
    }

    private boolean areFiguresSelected() {
        ProductSceneView sceneView = this.getSelectedProductSceneView();
        return sceneView.getFigureEditor().getFigureSelection().isEmpty();
    }

    private class StyleUpdater
    implements PropertyChangeListener {
        private StyleUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Debug.trace((String)String.format("VectorDataLayerEditor$StyleUpdater (1): property change: name=%s, oldValue=%s, newValue=%s", evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()));
            if (evt.getNewValue() == null) {
                return;
            }
            String propertyName = evt.getPropertyName();
            if (FILL_COLOR_NAME.equals(propertyName)) {
                VectorDataLayerEditor.this.updateColorAndOpacity(FILL_COLOR_NAME, FILL_OPACITY_NAME);
            } else if (STROKE_COLOR_NAME.equals(propertyName)) {
                VectorDataLayerEditor.this.updateColorAndOpacity(STROKE_COLOR_NAME, STROKE_OPACITY_NAME);
            }
            if (VectorDataLayerEditor.this.isAdjusting.compareAndSet(false, true)) {
                try {
                    SimpleFeatureFigure[] figures = VectorDataLayerEditor.this.getFigures(true);
                    if (figures.length == 0) {
                        figures = VectorDataLayerEditor.this.getFigures(false);
                    }
                    for (SimpleFeatureFigure figure : figures) {
                        Object oldFigureValue = figure.getNormalStyle().getValue(propertyName);
                        Object newValue = evt.getNewValue();
                        if (newValue.equals(oldFigureValue)) continue;
                        Debug.trace((String)String.format("VectorDataLayerEditor$StyleUpdater (2): about to apply change: name=%s, oldValue=%s, newValue=%s", propertyName, oldFigureValue, evt.getNewValue()));
                        FigureStyle origStyle = figure.getNormalStyle();
                        DefaultFigureStyle style = new DefaultFigureStyle();
                        style.fromCssString(origStyle.toCssString());
                        VectorDataLayerEditor.this.updateStyle(VectorDataLayerEditor.this.getBindingContext(), evt.getPropertyName(), (FigureStyle)style);
                        figure.setNormalStyle((FigureStyle)style);
                        this.setFeatureStyleCss(figure, (FigureStyle)style);
                    }
                }
                finally {
                    VectorDataLayerEditor.this.isAdjusting.set(false);
                }
            }
        }

        private void setFeatureStyleCss(SimpleFeatureFigure selectedFigure, FigureStyle style) {
            VectorDataNode vectorDataNode = VectorDataLayerEditor.this.getVectorDataNode();
            if (vectorDataNode != null) {
                Placemark placemark = vectorDataNode.getPlacemarkGroup().getPlacemark(selectedFigure.getSimpleFeature());
                if (placemark != null) {
                    placemark.setStyleCss(style.toCssString());
                } else {
                    int index = selectedFigure.getSimpleFeature().getFeatureType().indexOf("style_css");
                    if (index != -1) {
                        selectedFigure.getSimpleFeature().setAttribute(index, (Object)style.toCssString());
                    }
                }
            }
        }
    }

    private class SelectionChangeHandler
    extends AbstractSelectionChangeListener {
        private SelectionChangeHandler() {
        }

        public void selectionChanged(SelectionChangeEvent event) {
            VectorDataLayerEditor.this.handleLayerContentChanged();
        }
    }
}

