/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager;

import com.bc.ceres.glayer.Layer;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.UIUtils;

class MoveLayerRightAction
extends AbstractAction {
    MoveLayerRightAction() {
        super("Move Layer Right", UIUtils.loadImageIcon((String)"icons/Right24.gif"));
        this.putValue("ActionCommandKey", this.getClass().getName());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Layer selectedLayer = SnapApp.getDefault().getSelectedProductSceneView().getSelectedLayer();
        Layer rootLayer = SnapApp.getDefault().getSelectedProductSceneView().getRootLayer();
        if (selectedLayer != null && rootLayer != selectedLayer) {
            this.moveRight(selectedLayer);
        }
    }

    void moveRight(Layer layer) {
        if (this.canMove(layer)) {
            Layer parentLayer = layer.getParent();
            int layerIndex = parentLayer.getChildIndex(layer.getId());
            Layer targetLayer = (Layer)parentLayer.getChildren().get(layerIndex - 1);
            parentLayer.getChildren().remove(layer);
            targetLayer.getChildren().add(layer);
        }
    }

    public boolean canMove(Layer layer) {
        Layer targetLayer;
        Layer parentLayer = layer.getParent();
        int layerIndex = parentLayer.getChildIndex(layer.getId());
        return layerIndex > 0 && (targetLayer = (Layer)parentLayer.getChildren().get(layerIndex - 1)).isCollectionLayer();
    }
}

