/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager;

import com.bc.ceres.glayer.Layer;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.UIUtils;

class MoveLayerDownAction
extends AbstractAction {
    MoveLayerDownAction() {
        super("Move Layer Down", UIUtils.loadImageIcon((String)"icons/Down24.gif"));
        this.putValue("ActionCommandKey", this.getClass().getName());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Layer selectedLayer = SnapApp.getDefault().getSelectedProductSceneView().getSelectedLayer();
        Layer rootLayer = SnapApp.getDefault().getSelectedProductSceneView().getRootLayer();
        if (selectedLayer != null && rootLayer != selectedLayer) {
            this.moveDown(selectedLayer);
        }
    }

    void moveDown(Layer layer) {
        if (this.canMove(layer)) {
            Layer parentLayer = layer.getParent();
            int layerIndex = parentLayer.getChildIndex(layer.getId());
            parentLayer.getChildren().remove(layer);
            parentLayer.getChildren().add(layerIndex + 1, layer);
        }
    }

    public boolean canMove(Layer layer) {
        int lastIndex;
        Layer parentLayer = layer.getParent();
        int layerIndex = parentLayer.getChildIndex(layer.getId());
        return layerIndex != (lastIndex = parentLayer.getChildren().size() - 1);
    }
}

