/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager;

import com.bc.ceres.glayer.Layer;
import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.border.EmptyBorder;
import org.esa.snap.rcp.windows.ToolTopComponent;
import org.esa.snap.ui.product.ProductSceneView;
import org.netbeans.api.annotations.common.NonNull;

public abstract class AbstractLayerTopComponent
extends ToolTopComponent {
    private ProductSceneView selectedView;
    private Layer selectedLayer;
    private final SelectedLayerPCL selectedLayerPCL = new SelectedLayerPCL();

    protected AbstractLayerTopComponent() {
        this.initUI();
    }

    protected ProductSceneView getSelectedView() {
        return this.selectedView;
    }

    protected Layer getSelectedLayer() {
        return this.selectedLayer;
    }

    protected abstract String getTitle();

    protected abstract String getHelpId();

    protected void initUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.setDisplayName(this.getTitle());
        this.setSelectedView(this.getSelectedProductSceneView());
    }

    protected void viewOpened(ProductSceneView view) {
    }

    protected void viewClosed(ProductSceneView view) {
    }

    protected void viewSelectionChanged(ProductSceneView oldView, ProductSceneView newView) {
    }

    protected void layerSelectionChanged(Layer oldLayer, Layer newLayer) {
    }

    private void setSelectedView(ProductSceneView newView) {
        ProductSceneView oldView = this.selectedView;
        if (newView != oldView) {
            if (oldView != null) {
                oldView.removePropertyChangeListener("selectedLayer", (PropertyChangeListener)this.selectedLayerPCL);
            }
            if (newView != null) {
                newView.addPropertyChangeListener("selectedLayer", (PropertyChangeListener)this.selectedLayerPCL);
            }
            this.selectedView = newView;
            this.viewSelectionChanged(oldView, newView);
            this.setSelectedLayer(newView != null ? newView.getSelectedLayer() : null);
        }
    }

    protected void setSelectedLayer(Layer newLayer) {
        Layer oldLayer = this.selectedLayer;
        if (newLayer != oldLayer) {
            this.selectedLayer = newLayer;
            this.layerSelectionChanged(oldLayer, newLayer);
        }
    }

    @Override
    protected void productSceneViewSelected(@NonNull ProductSceneView view) {
        this.setSelectedView(view);
        this.viewOpened(view);
    }

    @Override
    protected void productSceneViewDeselected(@NonNull ProductSceneView view) {
        this.setSelectedView(null);
    }

    private class SelectedLayerPCL
    implements PropertyChangeListener {
        private SelectedLayerPCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (AbstractLayerTopComponent.this.getSelectedView() != null) {
                AbstractLayerTopComponent.this.setSelectedLayer(AbstractLayerTopComponent.this.getSelectedView().getSelectedLayer());
            }
        }
    }
}

