/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.imgfilter.model;

import com.bc.ceres.core.Assert;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Filter {
    String name;
    String shorthand;
    Operation operation;
    boolean editable;
    HashSet<String> tags;
    double[] kernelElements;
    int kernelWidth;
    int kernelHeight;
    double kernelQuotient;
    int kernelOffsetX;
    int kernelOffsetY;
    transient List<Listener> listeners;
    private static int id = 1;

    public static Filter create(int kernelSize, String ... tags) {
        return Filter.create(Operation.CONVOLVE, kernelSize, tags);
    }

    public static Filter create(Operation operation, int kernelSize, String ... tags) {
        int id = Filter.id++;
        String name = System.getProperty("user.name") + id;
        String shorthand = "my" + id;
        return new Filter(name, shorthand, operation, kernelSize, kernelSize, null, 1.0, tags);
    }

    public Filter(String name, String shorthand, int kernelWidth, int kernelHeight, double[] kernelElements, double kernelQuotient, String ... tags) {
        this(name, shorthand, Operation.CONVOLVE, kernelWidth, kernelHeight, kernelElements, kernelQuotient, tags);
    }

    public Filter(String name, String shorthand, Operation operation, int kernelWidth, int kernelHeight, String ... tags) {
        this(name, shorthand, operation, kernelWidth, kernelHeight, null, 1.0, tags);
    }

    public Filter(String name, String shorthand, Operation operation, int kernelWidth, int kernelHeight, double[] kernelElements, double kernelQuotient, String ... tags) {
        Assert.notNull((Object)name, (String)"name");
        Assert.notNull((Object)shorthand, (String)"shorthand");
        Assert.notNull((Object)((Object)operation), (String)"operation");
        Assert.argument((kernelWidth > 0 ? 1 : 0) != 0, (String)"kernelWidth");
        Assert.argument((kernelHeight > 0 ? 1 : 0) != 0, (String)"kernelHeight");
        Assert.argument((Math.abs(kernelQuotient) > 0.0 ? 1 : 0) != 0, (String)"kernelQuotient");
        this.name = name;
        this.shorthand = shorthand;
        this.operation = operation;
        this.tags = new HashSet();
        this.tags.addAll(Arrays.asList(tags));
        this.kernelWidth = kernelWidth;
        this.kernelHeight = kernelHeight;
        this.kernelQuotient = kernelQuotient;
        this.kernelOffsetX = kernelWidth / 2;
        this.kernelOffsetY = kernelHeight / 2;
        if (kernelElements != null) {
            Assert.argument((kernelElements.length == kernelWidth * kernelHeight ? 1 : 0) != 0, (String)"kernelElements");
            this.kernelElements = (double[])kernelElements.clone();
        } else {
            this.kernelElements = new double[kernelWidth * kernelHeight];
            if (operation == Operation.CONVOLVE) {
                this.kernelElements[this.kernelOffsetY * kernelWidth + this.kernelOffsetX] = 1.0;
            } else {
                Arrays.fill(this.kernelElements, 1.0);
            }
        }
        this.listeners = new ArrayList<Listener>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!name.equals(this.name)) {
            this.name = name;
            this.fireChange("name");
        }
    }

    public String getShorthand() {
        return this.shorthand;
    }

    public void setShorthand(String shorthand) {
        if (!shorthand.equals(this.shorthand)) {
            this.shorthand = shorthand;
            this.fireChange("shorthand");
        }
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        if (operation != this.operation) {
            this.operation = operation;
            this.fireChange("operation");
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (editable != this.editable) {
            this.editable = editable;
            this.fireChange("editable");
        }
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(String ... tags) {
        this.setTags(new HashSet<String>(Arrays.asList(tags)));
    }

    private void setTags(HashSet<String> tags) {
        if (!tags.equals(this.tags)) {
            this.tags = tags;
            this.fireChange("tags");
        }
    }

    public double getKernelElement(int i, int j) {
        return this.getKernelElement(j * this.kernelWidth + i);
    }

    public double getKernelElement(int index) {
        return this.kernelElements[index];
    }

    public void setKernelElement(int i, int j, double value) {
        this.setKernelElement(j * this.kernelWidth + i, value);
    }

    public void setKernelElement(int index, double value) {
        if (value != this.kernelElements[index]) {
            this.kernelElements[index] = value;
            this.fireChange("kernelElements");
        }
    }

    public double[] getKernelElements() {
        return this.kernelElements;
    }

    public void setKernelElements(double[] kernelElements) {
        if (!Arrays.equals(kernelElements, this.kernelElements)) {
            if (kernelElements.length != this.kernelWidth * this.kernelHeight) {
                throw new IllegalArgumentException("kernelElements.length != kernelWidth * kernelHeight");
            }
            this.kernelElements = kernelElements;
            this.fireChange("kernelElements");
        }
    }

    public int getKernelWidth() {
        return this.kernelWidth;
    }

    public int getKernelHeight() {
        return this.kernelHeight;
    }

    public void setKernelSize(int width, int height) {
        if (width != this.kernelWidth || height != this.kernelHeight) {
            int oldWidth = this.kernelWidth;
            int oldHeight = this.kernelHeight;
            double[] oldElements = this.kernelElements;
            double[] elements = new double[width * height];
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    int oldI = i * oldWidth / width;
                    int oldJ = j * oldHeight / height;
                    int oldIndex = oldJ * oldWidth + oldI;
                    int newIndex = j * width + i;
                    elements[newIndex] = oldElements[oldIndex];
                }
            }
            this.kernelWidth = width;
            this.kernelHeight = height;
            this.kernelOffsetX = width / 2;
            this.kernelOffsetY = height / 2;
            this.kernelElements = elements;
            this.fireChange("kernelSize");
        }
    }

    public void fill(FillFunction fillFunction) {
        int w = this.kernelWidth;
        int h = this.kernelHeight;
        double x0 = -0.5 * (double)(w - 1);
        double y0 = -0.5 * (double)(h - 1);
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                double v;
                double x = x0 + (double)i;
                double y = y0 + (double)j;
                this.kernelElements[j * w + i] = v = fillFunction.compute(x, y, w, h);
            }
        }
        this.fireChange("kernelElements");
    }

    public void fillRectangle(double fillValue) {
        Arrays.fill(this.kernelElements, fillValue);
        this.fireChange("kernelElements");
    }

    public void fillEllipse(final double fillValue) {
        this.fill(new FillFunction(){

            @Override
            public double compute(double x, double y, int w, int h) {
                double a = 0.5 * (double)w;
                double b = 0.5 * (double)h;
                double r = x / a * (x / a) + y / b * (y / b);
                return r < 1.0 ? fillValue : 0.0;
            }
        });
    }

    public void fillGaussian() {
        this.fill(new FillFunction(){

            @Override
            public double compute(double x, double y, int w, int h) {
                double sigX = 0.2 * (double)w;
                double sigY = 0.2 * (double)h;
                double r = x / sigX * (x / sigX) + y / sigY * (y / sigY);
                double z = Math.exp(-0.5 * r);
                return Math.floor(Math.round((double)(2 * (1 + Math.min(w, h))) * z));
            }
        });
    }

    public void fillLaplacian() {
        this.fill(new FillFunction(){

            @Override
            public double compute(double x, double y, int w, int h) {
                double sigX = 0.15 * (double)w;
                double sigY = 0.15 * (double)h;
                double r = x / sigX * (x / sigX) + y / sigY * (y / sigY);
                double z = (r - 1.0) * Math.exp(-0.5 * r);
                return Math.floor(Math.round((double)(2 * (1 + Math.min(w, h))) * z));
            }
        });
    }

    public void fillRandom() {
        this.fill(new FillFunction(){

            @Override
            public double compute(double x, double y, int w, int h) {
                double range = Math.min(w, h);
                return Math.round(range * (2.0 * Math.random() - 1.0));
            }
        });
    }

    public double getKernelQuotient() {
        return this.kernelQuotient;
    }

    public void setKernelQuotient(double kernelQuotient) {
        if (kernelQuotient != this.kernelQuotient) {
            this.kernelQuotient = kernelQuotient;
            this.fireChange("kernelQuotient");
        }
    }

    public void adjustKernelQuotient() {
        if (this.operation == Operation.CONVOLVE) {
            double sum = 0.0;
            for (double v : this.kernelElements) {
                sum += v;
            }
            this.setKernelQuotient(sum != 0.0 ? sum : 1.0);
        } else {
            this.setKernelQuotient(1.0);
        }
    }

    public int getKernelOffsetX() {
        return this.kernelOffsetX;
    }

    public int getKernelOffsetY() {
        return this.kernelOffsetY;
    }

    public void setKernelOffset(int kernelOffsetX, int kernelOffsetY) {
        if (kernelOffsetX != this.kernelOffsetX || kernelOffsetY != this.kernelOffsetY) {
            this.kernelOffsetX = kernelOffsetX;
            this.kernelOffsetY = kernelOffsetY;
            this.fireChange("kernelOffset");
        }
    }

    public String getKernelElementsAsText() {
        return Filter.formatKernelElements(this.kernelElements, new Dimension(this.kernelWidth, this.kernelHeight), "\t");
    }

    public void setKernelElementsFromText(String text) {
        Dimension dim = new Dimension();
        double[] kernelElements = Filter.parseKernelElementsFromText(text, dim);
        if (kernelElements != null) {
            this.setKernelSize(dim.width, dim.height);
            this.setKernelElements(kernelElements);
        }
    }

    protected static double[] parseKernelElementsFromText(String text, Dimension dim) {
        String[][] tokens = Filter.tokenizeKernelElements(text);
        if (tokens == null) {
            return null;
        }
        int height = tokens.length;
        int width = tokens[0].length;
        double[] kernelElements = new double[width * height];
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                try {
                    kernelElements[j * width + i] = Double.parseDouble(tokens[j][i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        if (dim != null) {
            dim.width = width;
            dim.height = height;
        }
        return kernelElements;
    }

    public static String[][] tokenizeKernelElements(String text) {
        String[] lines = text.split("\n");
        int height = lines.length;
        int width = -1;
        String[][] strings = new String[height][];
        for (int j = 0; j < height; ++j) {
            String line = lines[j];
            String[] cells = line.split(",|;|\\s+");
            if (width == -1) {
                width = cells.length;
            } else if (width != cells.length) {
                return null;
            }
            strings[j] = cells;
        }
        return strings;
    }

    public static String formatKernelElements(double[] kernelElements, Dimension dim, String sep) {
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < dim.height; ++j) {
            for (int i = 0; i < dim.width; ++i) {
                double v;
                if (i != 0) {
                    text.append(sep);
                }
                if ((v = kernelElements[j * dim.width + i]) == (double)((int)v)) {
                    text.append((int)v);
                    continue;
                }
                text.append(v);
            }
            if (j >= dim.height - 1) continue;
            text.append('\n');
        }
        return text.toString();
    }

    public static XStream createXStream() {
        XStream xStream = new XStream();
        xStream.setClassLoader(Filter.class.getClassLoader());
        xStream.alias("filter", Filter.class);
        xStream.registerLocalConverter(Filter.class, "kernelElements", new SingleValueConverter(){

            public String toString(Object o) {
                double[] o1 = (double[])o;
                return Filter.formatKernelElements(o1, new Dimension(o1.length, 1), ",");
            }

            public Object fromString(String s) {
                return Filter.parseKernelElementsFromText(s, null);
            }

            public boolean canConvert(Class aClass) {
                return aClass.equals(double[].class);
            }
        });
        return xStream;
    }

    private Object readResolve() {
        if (this.tags == null) {
            this.tags = new HashSet();
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<Listener>();
        }
        if (this.kernelQuotient == 0.0) {
            this.kernelQuotient = 1.0;
        }
        return this;
    }

    public String toString() {
        return this.name;
    }

    public static boolean isKernelDataText(String text) {
        String[][] strings = Filter.tokenizeKernelElements(text);
        return strings != null;
    }

    public void fireChange(String propertyName) {
        Listener[] listeners;
        for (Listener listener : listeners = this.listeners.toArray(new Listener[this.listeners.size()])) {
            listener.filterChanged(this, propertyName);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    static interface FillFunction {
        public double compute(double var1, double var3, int var5, int var6);
    }

    public static interface Listener {
        public void filterChanged(Filter var1, String var2);
    }

    public static enum Operation {
        CONVOLVE,
        MIN,
        MAX,
        MEAN,
        MEDIAN,
        STDDEV,
        ERODE,
        DILATE,
        OPEN,
        CLOSE;

    }
}

