/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.imgfilter;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.rcp.imgfilter.model.FilterSet;
import org.esa.snap.rcp.imgfilter.model.FilterSetStore;

public class FilterSetFileStore
implements FilterSetStore {
    final File filtersDir;

    public FilterSetFileStore(File filtersDir) {
        this.filtersDir = filtersDir;
    }

    public List<FilterSet> loadFilterSetModels() throws IOException {
        XStream xStream = FilterSet.createXStream();
        File[] files = this.filtersDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml");
            }
        });
        ArrayList<FilterSet> list = new ArrayList<FilterSet>();
        if (files == null) {
            return list;
        }
        IOException ioe = null;
        for (File file : files) {
            try {
                FilterSet filterSet = new FilterSet();
                xStream.fromXML(file, (Object)filterSet);
                list.add(filterSet);
            }
            catch (Exception e) {
                ioe = new IOException(e);
            }
        }
        if (ioe != null && list.isEmpty()) {
            throw ioe;
        }
        return list;
    }

    @Override
    public void storeFilterSetModel(FilterSet filterSet) throws IOException {
        if (!this.filtersDir.exists() && !this.filtersDir.mkdirs()) {
            throw new IOException("Failed to create directory\n" + this.filtersDir);
        }
        File file = new File(this.filtersDir, filterSet.getName().toLowerCase() + "-filters.xml");
        XStream xStream = FilterSet.createXStream();
        try (FileWriter fileWriter = new FileWriter(file);){
            xStream.toXML((Object)filterSet, (Writer)fileWriter);
        }
    }
}

