/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Scaling;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.datamodel.StxFactory;
import org.esa.snap.rcp.colormanip.ColorManipulationChildForm;
import org.esa.snap.rcp.colormanip.ColorManipulationForm;
import org.esa.snap.rcp.colormanip.DiscreteCheckBox;
import org.esa.snap.rcp.colormanip.FormModel;
import org.esa.snap.rcp.colormanip.ImageInfoEditor2;
import org.esa.snap.rcp.colormanip.ImageInfoEditorModel1B;
import org.esa.snap.rcp.colormanip.ImageInfoEditorSupport;
import org.esa.snap.rcp.colormanip.LogDisplay;
import org.esa.snap.rcp.colormanip.MoreOptionsForm;
import org.esa.snap.ui.ImageInfoEditorModel;

class Continuous1BandGraphicalForm
implements ColorManipulationChildForm {
    public static final Scaling POW10_SCALING = new Pow10Scaling();
    private final ColorManipulationForm parentForm;
    private final ImageInfoEditor2 imageInfoEditor;
    private final ImageInfoEditorSupport imageInfoEditorSupport;
    private final JPanel contentPanel;
    private final AbstractButton logDisplayButton;
    private final AbstractButton evenDistButton;
    private final MoreOptionsForm moreOptionsForm;
    private final DiscreteCheckBox discreteCheckBox;

    Continuous1BandGraphicalForm(ColorManipulationForm parentForm) {
        this.parentForm = parentForm;
        this.imageInfoEditor = new ImageInfoEditor2(parentForm);
        this.imageInfoEditorSupport = new ImageInfoEditorSupport(this.imageInfoEditor);
        this.contentPanel = new JPanel(new BorderLayout(2, 2));
        this.contentPanel.add((Component)((Object)this.imageInfoEditor), "Center");
        this.moreOptionsForm = new MoreOptionsForm(this, parentForm.getFormModel().canUseHistogramMatching());
        this.discreteCheckBox = new DiscreteCheckBox(parentForm);
        this.moreOptionsForm.addRow(this.discreteCheckBox);
        parentForm.getFormModel().modifyMoreOptionsForm(this.moreOptionsForm);
        this.logDisplayButton = LogDisplay.createButton();
        this.logDisplayButton.addActionListener(e -> {
            boolean shouldLog10Display = this.logDisplayButton.isSelected();
            if (shouldLog10Display) {
                ImageInfo imageInfo = parentForm.getFormModel().getModifiedImageInfo();
                ColorPaletteDef cpd = imageInfo.getColorPaletteDef();
                if (LogDisplay.checkApplicability(cpd)) {
                    this.setLogarithmicDisplay(parentForm.getFormModel().getRaster(), true);
                    parentForm.applyChanges();
                } else {
                    LogDisplay.showNotApplicableInfo(parentForm.getContentPanel());
                    this.logDisplayButton.setSelected(false);
                }
            } else {
                this.setLogarithmicDisplay(parentForm.getFormModel().getRaster(), false);
                parentForm.applyChanges();
            }
        });
        this.evenDistButton = ImageInfoEditorSupport.createButton("org/esa/snap/rcp/icons/EvenDistribution24.gif");
        this.evenDistButton.setName("evenDistButton");
        this.evenDistButton.setToolTipText("Distribute sliders evenly between first and last slider");
        this.evenDistButton.addActionListener(parentForm.wrapWithAutoApplyActionListener(e -> this.distributeSlidersEvenly()));
    }

    @Override
    public Component getContentPanel() {
        return this.contentPanel;
    }

    @Override
    public ColorManipulationForm getParentForm() {
        return this.parentForm;
    }

    @Override
    public void handleFormShown(FormModel formModel) {
        this.updateFormModel(formModel);
    }

    @Override
    public void handleFormHidden(FormModel formModel) {
        if (this.imageInfoEditor.getModel() != null) {
            this.imageInfoEditor.setModel(null);
        }
    }

    @Override
    public void updateFormModel(FormModel formModel) {
        ImageInfoEditorModel oldModel = this.imageInfoEditor.getModel();
        ImageInfo imageInfo = this.parentForm.getFormModel().getModifiedImageInfo();
        ImageInfoEditorModel1B newModel = new ImageInfoEditorModel1B(imageInfo);
        this.imageInfoEditor.setModel((ImageInfoEditorModel)newModel);
        RasterDataNode raster = formModel.getRaster();
        this.setLogarithmicDisplay(raster, newModel.getImageInfo().isLogScaled());
        if (oldModel != null) {
            newModel.setHistogramViewGain(oldModel.getHistogramViewGain());
            newModel.setMinHistogramViewSample(oldModel.getMinHistogramViewSample());
            newModel.setMaxHistogramViewSample(oldModel.getMaxHistogramViewSample());
        }
        if (newModel.getSliderSample(0) < newModel.getMinHistogramViewSample() || newModel.getSliderSample(newModel.getSliderCount() - 1) > newModel.getMaxHistogramViewSample()) {
            this.imageInfoEditor.computeZoomInToSliderLimits();
        }
        this.discreteCheckBox.setDiscreteColorsMode(imageInfo.getColorPaletteDef().isDiscrete());
        this.logDisplayButton.setSelected(newModel.getImageInfo().isLogScaled());
        this.parentForm.revalidateToolViewPaneControl();
    }

    @Override
    public void resetFormModel(FormModel formModel) {
        this.updateFormModel(formModel);
        this.imageInfoEditor.computeZoomOutToFullHistogramm();
        this.parentForm.revalidateToolViewPaneControl();
    }

    @Override
    public void handleRasterPropertyChange(ProductNodeEvent event, RasterDataNode raster) {
        ImageInfoEditorModel model = this.imageInfoEditor.getModel();
        if (model != null) {
            if (event.getPropertyName().equals("stx")) {
                this.updateFormModel(this.parentForm.getFormModel());
            } else {
                this.setLogarithmicDisplay(raster, model.getImageInfo().isLogScaled());
            }
        }
    }

    @Override
    public RasterDataNode[] getRasters() {
        return this.parentForm.getFormModel().getRasters();
    }

    @Override
    public MoreOptionsForm getMoreOptionsForm() {
        return this.moreOptionsForm;
    }

    private void setLogarithmicDisplay(RasterDataNode raster, boolean logarithmicDisplay) {
        ImageInfoEditorModel model = this.imageInfoEditor.getModel();
        if (logarithmicDisplay) {
            StxFactory stxFactory = new StxFactory();
            Stx stx = stxFactory.withHistogramBinCount(Integer.valueOf(raster.getStx().getHistogramBinCount())).withLogHistogram(logarithmicDisplay).withResolutionLevel(Integer.valueOf(raster.getSourceImage().getModel().getLevelCount() - 1)).create(raster, ProgressMonitor.NULL);
            model.setDisplayProperties(raster.getName(), raster.getUnit(), stx, POW10_SCALING);
        } else {
            model.setDisplayProperties(raster.getName(), raster.getUnit(), raster.getStx(), Scaling.IDENTITY);
        }
        model.getImageInfo().setLogScaled(logarithmicDisplay);
    }

    private void distributeSlidersEvenly() {
        this.imageInfoEditor.distributeSlidersEvenly();
    }

    @Override
    public AbstractButton[] getToolButtons() {
        return new AbstractButton[]{this.imageInfoEditorSupport.autoStretch95Button, this.imageInfoEditorSupport.autoStretch100Button, this.imageInfoEditorSupport.zoomInVButton, this.imageInfoEditorSupport.zoomOutVButton, this.imageInfoEditorSupport.zoomInHButton, this.imageInfoEditorSupport.zoomOutHButton, this.logDisplayButton, this.evenDistButton, this.imageInfoEditorSupport.showExtraInfoButton};
    }

    static void setDisplayProperties(ImageInfoEditorModel model, RasterDataNode raster) {
        model.setDisplayProperties(raster.getName(), raster.getUnit(), raster.getStx(), raster.isLog10Scaled() ? POW10_SCALING : Scaling.IDENTITY);
    }

    private static class Pow10Scaling
    implements Scaling {
        private final Scaling log10Scaling = new Log10Scaling();

        private Pow10Scaling() {
        }

        public double scale(double value) {
            return this.log10Scaling.scaleInverse(value);
        }

        public double scaleInverse(double value) {
            return this.log10Scaling.scale(value);
        }
    }

    private static class Log10Scaling
    implements Scaling {
        private Log10Scaling() {
        }

        public final double scale(double value) {
            return value > 1.0E-9 ? Math.log10(value) : -9.0;
        }

        public final double scaleInverse(double value) {
            return value < -9.0 ? 1.0E-9 : Math.pow(10.0, value);
        }
    }
}

