/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.bandmaths;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeList;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.bandmaths.BandMathsDialog;
import org.esa.snap.rcp.bandmaths.Bundle;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class BandMathsAction
extends AbstractAction
implements HelpCtx.Provider {
    private static final String HELP_ID = "bandArithmetic";

    public BandMathsAction() {
        super(Bundle.CTL_BandMathsAction_MenuText());
        this.putValue("ShortDescription", Bundle.CTL_BandMathsAction_ShortDescription());
        ProductManager productManager = SnapApp.getDefault().getProductManager();
        this.setEnabled(productManager.getProductCount() > 0);
        productManager.addListener((ProductManager.Listener)new PMListener());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Product[] openedProducts;
        ProductNodeList products = new ProductNodeList();
        for (Product prod : openedProducts = SnapApp.getDefault().getProductManager().getProducts()) {
            products.add((ProductNode)prod);
        }
        Product product = SnapApp.getDefault().getSelectedProduct(SnapApp.SelectionSourceHint.EXPLORER);
        if (product == null) {
            product = (Product)products.getAt(0);
        }
        Collection selectedRasters = Utilities.actionsGlobalContext().lookupAll(RasterDataNode.class);
        String expression = selectedRasters.stream().map(ProductNode::getName).collect(Collectors.joining(" + "));
        BandMathsDialog bandMathsDialog = new BandMathsDialog(product, (ProductNodeList<Product>)products, expression, HELP_ID);
        bandMathsDialog.show();
    }

    private class PMListener
    implements ProductManager.Listener {
        private PMListener() {
        }

        public void productAdded(ProductManager.Event event) {
            this.updateEnableState();
        }

        public void productRemoved(ProductManager.Event event) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            BandMathsAction.this.setEnabled(SnapApp.getDefault().getProductManager().getProductCount() > 0);
        }
    }
}

