/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.vector;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import com.vividsolutions.jts.geom.Polygonal;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.prefs.Preferences;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.dataio.geometry.VectorDataNodeIO;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.vector.SeparateGeometriesDialog;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.SnapFileChooser;
import org.esa.snap.ui.product.ProductSceneView;
import org.opengis.feature.type.GeometryDescriptor;
import org.openide.util.HelpCtx;

public class VectorDataNodeImporter
implements HelpCtx.Provider {
    private final String dialogTitle;
    private final String shapeIoDirPreferencesKey;
    private String helpId;
    private SnapFileFilter filter;
    private final VectorDataNodeReader reader;

    public VectorDataNodeImporter(String helpId, SnapFileFilter filter, VectorDataNodeReader reader, String dialogTitle, String shapeIoDirPreferencesKey) {
        this.helpId = helpId;
        this.filter = filter;
        this.reader = reader;
        this.dialogTitle = dialogTitle;
        this.shapeIoDirPreferencesKey = shapeIoDirPreferencesKey;
    }

    public void importGeometry(SnapApp snapApp) {
        File[] files;
        Preferences preferences = snapApp.getPreferences();
        SnapFileChooser fileChooser = new SnapFileChooser();
        fileChooser.setDialogTitle(this.dialogTitle);
        fileChooser.setFileFilter((FileFilter)this.filter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setCurrentDirectory(this.getIODir(preferences));
        int result = fileChooser.showOpenDialog((Component)snapApp.getMainFrame());
        if (result == 0 && (files = fileChooser.getSelectedFiles()) != null && files.length > 0) {
            this.setIODir(preferences, files[0].getAbsoluteFile().getParentFile());
            for (File file : files) {
                this.importGeometry(snapApp, file);
            }
        }
    }

    private void importGeometry(SnapApp snapApp, File file) {
        VectorDataNode[] vectorDataNodes;
        VectorDataNode vectorDataNode;
        Product product = snapApp.getSelectedProduct(SnapApp.SelectionSourceHint.AUTO);
        if (product == null) {
            return;
        }
        GeoCoding geoCoding = product.getSceneGeoCoding();
        if (geoCoding == null || !geoCoding.canGetPixelPos()) {
            Dialogs.showError(this.dialogTitle, "Failed to import vector data.\nCurrent geo-coding cannot convert from geographic to pixel coordinates.");
            return;
        }
        try {
            vectorDataNode = this.readGeometry(snapApp, file, product);
            if (vectorDataNode == null) {
                return;
            }
        }
        catch (Exception e) {
            Dialogs.showError(this.dialogTitle, "Failed to import vector data.\nAn I/O Error occurred:\n" + e.getMessage());
            Debug.trace((Throwable)e);
            return;
        }
        if (vectorDataNode.getFeatureCollection().isEmpty()) {
            Dialogs.showError(this.dialogTitle, "The vector data was loaded successfully,\nbut no part is located within the scene boundaries.");
            return;
        }
        boolean individualShapes = false;
        String attributeName = null;
        GeometryDescriptor geometryDescriptor = vectorDataNode.getFeatureType().getGeometryDescriptor();
        int featureCount = vectorDataNode.getFeatureCollection().size();
        if (featureCount > 1 && geometryDescriptor != null && Polygonal.class.isAssignableFrom(geometryDescriptor.getType().getBinding())) {
            String text = "<html>The vector data set contains <b>" + featureCount + "</b> polygonal shapes.<br>" + "Shall they be imported separately?<br>" + "<br>" + "If you select <b>Yes</b>, the polygons can be used as individual masks<br>" + "and they will be displayed on individual layers.</i>";
            SeparateGeometriesDialog dialog = new SeparateGeometriesDialog(snapApp.getMainFrame(), vectorDataNode, this.helpId, text);
            int response = dialog.show();
            if (response == 32) {
                return;
            }
            individualShapes = response == 2;
            attributeName = dialog.getSelectedAttributeName();
        }
        for (VectorDataNode vectorDataNode1 : vectorDataNodes = VectorDataNodeIO.getVectorDataNodes((VectorDataNode)vectorDataNode, (boolean)individualShapes, attributeName)) {
            product.getVectorDataGroup().add((ProductNode)vectorDataNode1);
        }
        this.setLayersVisible(vectorDataNodes);
    }

    private void setLayersVisible(VectorDataNode[] vectorDataNodes) {
        ProductSceneView sceneView = SnapApp.getDefault().getSelectedProductSceneView();
        if (sceneView != null) {
            sceneView.setLayersVisible(vectorDataNodes);
        }
    }

    public static String findUniqueVectorDataNodeName(String suggestedName, ProductNodeGroup<VectorDataNode> vectorDataGroup) {
        String name = suggestedName;
        int index = 1;
        while (vectorDataGroup.contains(name)) {
            name = suggestedName + "_" + index;
            ++index;
        }
        return name;
    }

    private File getIODir(Preferences preferences) {
        File dir = SystemUtils.getUserHomeDir();
        return new File(preferences.get(this.shapeIoDirPreferencesKey, dir.getPath()));
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.helpId);
    }

    private VectorDataNode readGeometry(SnapApp snapApp, final File file, final Product product) throws IOException, ExecutionException, InterruptedException {
        ProgressMonitorSwingWorker<VectorDataNode, Object> worker = new ProgressMonitorSwingWorker<VectorDataNode, Object>((Component)snapApp.getMainFrame(), "Loading vector data"){

            protected VectorDataNode doInBackground(ProgressMonitor pm) throws Exception {
                return VectorDataNodeImporter.this.reader.readVectorDataNode(file, product, pm);
            }

            protected void done() {
                super.done();
            }
        };
        worker.executeWithBlocking();
        return (VectorDataNode)worker.get();
    }

    private void setIODir(Preferences preferences, File dir) {
        if (dir != null) {
            preferences.put(this.shapeIoDirPreferencesKey, dir.getPath());
        }
    }

    public static interface VectorDataNodeReader {
        public VectorDataNode readVectorDataNode(File var1, Product var2, ProgressMonitor var3) throws IOException;
    }
}

