/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.vector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.ui.ModalDialog;
import org.opengis.feature.type.AttributeType;

class SeparateGeometriesDialog
extends ModalDialog {
    private final JComboBox comboBox;

    public SeparateGeometriesDialog(Window mainFrame, VectorDataNode vectorDataNode, String helpId, String text) {
        super(mainFrame, "Import Geometry", 134, helpId);
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)new JLabel(text), "North");
        List types = vectorDataNode.getFeatureType().getTypes();
        ArrayList<String> names = new ArrayList<String>();
        for (AttributeType type : types) {
            if (!type.getBinding().equals(String.class)) continue;
            names.add(type.getName().getLocalPart());
        }
        this.comboBox = new JComboBox<String>(names.toArray(new String[names.size()]));
        if (names.size() > 0) {
            JPanel content2 = new JPanel(new BorderLayout());
            content2.add((Component)new JLabel("Attribute for mask/layer naming: "), "West");
            content2.add((Component)this.comboBox, "Center");
            content.add((Component)content2, "South");
        }
        this.setContent(content);
    }

    String getSelectedAttributeName() {
        if (this.comboBox.getItemCount() > 0) {
            return this.comboBox.getSelectedItem().toString();
        }
        return null;
    }
}

