/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.vector;

import com.bc.ceres.swing.TableLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.crs.CrsForm;
import org.esa.snap.ui.crs.CrsSelectionPanel;
import org.esa.snap.ui.crs.CustomCrsForm;
import org.esa.snap.ui.crs.PredefinedCrsForm;
import org.esa.snap.ui.crs.ProductCrsForm;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureCrsDialog
extends ModalDialog {
    private CrsSelectionPanel crsSelectionPanel;
    private Product product;
    private String title;

    public FeatureCrsDialog(Product product, String title) {
        super((Window)SnapApp.getDefault().getMainFrame(), title, 161, "importCSV");
        this.product = product;
        this.title = title;
        this.createUI();
    }

    private void createUI() {
        ProductCrsForm productCrsForm = new ProductCrsForm(SnapApp.getDefault().getAppContext(), this.product);
        CustomCrsForm customCrsForm = new CustomCrsForm(SnapApp.getDefault().getAppContext());
        PredefinedCrsForm predefinedCrsForm = new PredefinedCrsForm(SnapApp.getDefault().getAppContext());
        this.crsSelectionPanel = new CrsSelectionPanel(new CrsForm[]{productCrsForm, customCrsForm, predefinedCrsForm});
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setCellPadding(0, 0, new Insets(4, 10, 4, 4));
        JPanel contentPanel = new JPanel((LayoutManager)tableLayout);
        JLabel label = new JLabel();
        label.setText("<html><b>The vector data are not associated with a coordinate reference system (CRS).<br/>Please specify a CRS so that coordinates can be interpreted correctly.</b>");
        contentPanel.add(label);
        contentPanel.add((Component)this.crsSelectionPanel);
        this.setContent(contentPanel);
    }

    public CoordinateReferenceSystem getFeatureCrs() {
        CoordinateReferenceSystem crs = null;
        try {
            crs = this.crsSelectionPanel.getCrs(ProductUtils.getCenterGeoPos((Product)this.product));
        }
        catch (FactoryException e) {
            Dialogs.showError(this.title, "Cannot create coordinate reference system.\n" + e.getMessage());
        }
        return crs;
    }

    protected void onOK() {
        super.onOK();
        this.getParent().setVisible(true);
    }

    protected void onCancel() {
        super.onCancel();
        this.getParent().setVisible(true);
    }
}

